/*
   LCD RS pin to digital pin 5
   LCD Enable pin to digital pin 4
   LCD D4 pin to digital pin 0
   LCD D5 pin to digital pin 1
   LCD D6 pin to digital pin 2
   LCD D7 pin to digital pin 3
   LCD R/W pin to ground
   LCD VSS pin to ground
   LCD VCC pin to 3.3V
   100K pot:
   ends to 3.3V and ground
   wiper to LCD VO pin (pin 3)
*/

/*
 * Max freq. mbed board can measure (accurately) = 50kHz
 * circuit contains freq. divider to scale freq. down by 4
 * Thus max theoretical measurable freq = 200kHz
 * Duty cycle measurement before freq. divider
 * Duty cycle for high an low pulse times of >10us only
 */
/*********************************************************************/
#include <string>
#include <Pulse.h>
#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(D5, D4, D0, D1, D2, D3);//RS, E, D4, D5, D6, D7

/*********************************************************************/

Case 1:

lcd.printf("Frequency:");

string freqpin("D14");

double tHi; //to store avg time high

double tLo; //to store avg time low

float period;

float freq;

tHi = highTime(freqpin); //call function to compute avg high time

tLo = lowTime(freqpin); //call function to compute avg low time

period = period(tHi, tLo); //call function to compute period

duty = dutyCycle(tHi, period); //function to give duty cycle

freq = frequency(period); //function to give freq

if (freq < 1000) {

    lcd.locate(0,1);
    
    lcd.printf("%.2f Hz", freq);
    }
else if (1000 <= freq <= 200000){
    
    freq = freq / 1000;
    
    lcd.locate(0,1);

    lcd.printf("%.2f kHz", freq);
    }
else {
    
/*********************************************************************/
case 2:

string dutypin("D13");

double tHi; //to store avg time high

double tLo; //to store avg time low

float period;

double duty;

tHi = highTime(dutypin); //call function to compute avg high time

tLo = lowTime(dutypin); //call function to compute avg low time

period = period(tHi, tLo); //call function to compute period

duty = dutyCycle(tHi, period); //function to give duty cycle

/*********************************************************************/

double highTime(string x)
{
    PulseInOut InputPin(x);
    double highTimes[5]; //array to store times when input is high
    double result = 0; //to store avg time high

    for (int i = 0; i <= 5; i++) {

        highTimes[i] = int read_high_us(); //measure hi pulse x5

    }
    for (int j = 0; j <= 5; j++) {

        result = result + highTimes[j];
    }
    result = result / 5; //compute avg
    return result;
}

double lowTime(string x)
{
    PulseInOut InputPin(x);
    double lowTimes[5]; //array to store times when input is high
    double result = 0; //to store avg time high

    for (int i = 0; i <= 5; i++) {

        lowTimes[i] = int read_low_us(); //measure lo pulse x5

    }
    for (int j = 0; j <= 5; j++) {

        result = result + lowTimes[j];
    }
    result  = result / 5; //compute avg
    return result;

}

float period(double x, double y)
{
    float result;
    result = x + y;
    return result;
}

double dutyCycle(double x, float y)
{

    double result;
    result = (x / y) * 100;
    return result;
}

float frequency(float x)
{
    float result;
    result = (1000000 / x) * 4;
    return result;
}