/*
the code is set up to auto range for different known resistance value
it will base the case statement on its original Restimate value
the voltage drop across the transistor is different for each case
this value was found using simulations from LTspice 
a value for Runkown will be printed on the screen and this will be in a 
contunious loop from the switch
*/
//Case x:

lcd.locate(0,0);
lcd.printf("Resistance: "); //display on top line

DigitalOut 100ohm(D6) = 0; //Transistor connected to 100ohm resistor set to short circuit
DigitalOut 1kohm(D7) = 1; //All others set to open circuit      
DigitalOut 10kohm(D8) = 1; 
DigitalOut 100kohm(D9) = 1;
DigitalOut 1Mohm(D10) = 1;
DigitalOut 10Mohm(D11) = 1;

AnalogIn vo(A0);

double vout = (3.3 * vo)/ 4095; //converts analog read from bits to voltage

double rest;
int runkown;
double vt;

rest = (vout * 100) / (3.3 - vout); //rest is an estimate as it does not account for the voltage drop in transistor
                                    //this essentially  decides what pin we will use for final value
switch (rest)
{
    case 550: 
    vt = 0.0647875;                   // vt is based off ltspice values from simulations
    runknown = (vout * 100) / (3.3 - vt - vout);
    if (runknown < 10){
        lcd.printf("Out of Range");       //this will be out of the range of our design parameters
    }
    else{
        lcd.locate(0,1);                 
        lcd.printf("%u Ω", runknown);   // prints on the second row of the LCD screen 
        }
        break;
        
    case 5500:                          // this case is for if R is in a different range 
    vt = 0.0189; 
    100ohm = 1;
    1kohm = 0;
    vout = (3.3 * vo)/ 4095;
    runknown = (vout * 1000) / (3.3 - vt - vout); 
    lcd.locate(0,1);
    if (runknown < 1000){
        lcd.printf("%u Ω", runknown);     
    } // this if correct runknown to the appropriate magnitude 
    else {
        runknown = runknown / 1000; //runkown is now printed in KΩ
        lcd.printf("%.2f kΩ", runknown);
        }
        break;
        
    case 55000:
    vt = 0.0075148;
    100ohm = 1;
    10kohm = 0;
    vout = (3.3 * vo)/ 4095; 
    runknown = (vout * 10000) / (3.3 - vt - vout);
    lcd.locate(0,1);
    runknown = runknown / 1000;
    lcd.printf("%.2f kΩ", runknown);
        break;
        
    case 550000: 
    vt = 0.00612;
    100ohm = 1;
    100kohm = 0;
    vout = (3.3 * vo)/ 4095;
    runknown = (vout * 100000) / (3.3 - vt - vout);
    
    lcd.locate(0,1);
    
    if (runknown < 1000000){
        runknown = runknown / 1000;
        lcd.printf("%.2f kΩ", runknown);
        }
    else {
        runknown = runknown / 1000000;        // this will change the magnitude to MΩ
        lcd.printf("%.2f MΩ", runknown);
        }
        break;
        
    case 5500000: 
    vt = 0.0059684;
    100ohm = 1;
    1Mohm = 0;
    vout = (3.3 * vo)/ 4095;
    runknown = (vout * 1000000) / (3.3 - vt - vout);
    
    lcd.locate(0,1);
    runknown = runknown / 1000000;
    lcd.printf("%.2f MΩ", runknown);
        break;
        
    case 10000000:
    vt = 0.0059526; 
    100ohm = 1;
    10Mohm = 0;
    vout = (3.3 * vo)/ 4095;
    runknown = (vout * 10000000) / (3.3 - vt - vout);
    
    lcd.locate(0,1);
    runknown = runknown / 1000000;
    lcd.printf("%.2f MΩ", runknown);
        break;
        
    default:
    lcd.locate(0,1);
    lcd.printf("Out of Range"); // this will apear if runkown is outside the design parameters 
    break;
    
}    