#include "mbed.h"
#include <string>

// Funktionen erstellen
int changeCompBehaviorWithButton(DigitalIn btn, DigitalOut out);
int flashLedBus(BusOut myled);
int setLedBrightness(float brightness, PwmOut out);
float getTemperature();

char cmd[2];

// Output Array
BusOut myled(P1_13,P1_12,P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);
DigitalIn sw1(P0_10);
DigitalIn sw2(P0_15);
DigitalIn sw3(P0_23);
DigitalIn sw4(P1_16);

PwmOut rgb_green(p5);
PwmOut rgb_blue(p34);
PwmOut rgb_red(p36);

AnalogIn pot(p15);
AnalogIn ldr(p16);

DigitalOut led(LED1);

Serial pc(USBTX, USBRX);

I2C i2c(p28, p27);
 
const int addr = 0x90;
#define CONST 12

int main()
{
    pc.printf("MBED Prgramm gestartet!\r\n");
    while(1) {
        pc.printf("Potentiometer: \t%.3f\r\n",pot.read());
        pc.printf("LDR: \t\t%.3f\r\n",ldr.read());
        pc.printf("Temperatur: \t%.2f\r\n",getTemperature());
        pc.printf("Switch1: \t%d\r\n",sw1.read());
        pc.printf("Switch2: \t%d\r\n",sw2.read());
        pc.printf("Switch3: \t%d\r\n",sw3.read());
        pc.printf("Switch4: \t%d\r\n",sw4.read());
        pc.printf("+++++++++++++++++++++++++++++++++++++++++\r\n");
        wait(1);
    }

}

float getTemperature()
{
    cmd[0] = 0x01;
    cmd[1] = 0x00;
    i2c.write(addr, cmd, 2);

    wait(0.5);

    cmd[0] = 0x00;
    i2c.write(addr, cmd, 1);
    i2c.read(addr, cmd, 2);

    float tmp = (float((cmd[0]<<8)|cmd[1]) / 256.0);
    return tmp;
}

int changeCompBehaviorWithButton(DigitalIn btn, DigitalOut out)
{
    if(btn) {
        out = !out;
        return false;
    }
    return true;
}

int setLedBrightness(float brightness, PwmOut out)
{
    out.write(brightness);
    return true;
}

int flashLedBus(BusOut myled)
{
    int i;
    myled=0x0001; // auf Led 1 wird HIGH geschrieben
    wait(1);     // eine Sekunde warten
    myled=0x0003; // auf Led 2 wird HIGH geschrieben
    wait(1);
    myled=0x0006; // auf Led 3 wird HIGH geschrieben
    wait(1);
    myled=0x0018;
    wait(1);
    myled=0x0030;
    wait(1);
    myled=0x0060;
    // Forschleife
    for (i=1; i<12; i++) {
        // << kleiner - >> größer ...als
        myled=myled>>1;
        wait(0.1);
    }
    return true;
}


