#include "mbed.h"
#include "IRSensor.h"
#include "Controller.h"

DigitalOut myled(LED1);
DigitalIn mybutton(BUTTON1); 

AnalogIn v_distance(PA_0);  // Kreieren der Ein- und Ausgangsobjekte   
DigitalOut enable(PG_1);   
DigitalOut bit0(PF_0);   
DigitalOut bit1(PF_1);   
DigitalOut bit2(PF_2);

DigitalOut led0(PD_4);   
DigitalOut led1(PD_3);   
DigitalOut led2(PD_6);   
DigitalOut led3(PD_2);   
DigitalOut led4(PD_7);   
DigitalOut led5(PD_5); 

DigitalOut en_Motor(PG_0);
DigitalIn Error_Motor(PD_1);
DigitalIn Warn_Motor(PD_0); 
PwmOut MotorPWMLeft(PF_9); 
PwmOut MotorPWMRight(PF_8); 
EncoderCounter cnt_Left(PD_12,PD_13);
EncoderCounter cnt_Right(PB_4, PC_7);

IRSensor S_hinten(v_distance, bit0 , bit1, bit2, 0);
IRSensor S_hinten_links(v_distance, bit0 , bit1, bit2, 1);
IRSensor S_vorne_links(v_distance, bit0 , bit1, bit2, 2);
IRSensor S_vorne(v_distance, bit0 , bit1, bit2, 3);
IRSensor S_vorne_rechts(v_distance, bit0 , bit1, bit2, 4);
IRSensor S_hinten_rechts(v_distance, bit0 , bit1, bit2, 5);

Controller controller(MotorPWMLeft, MotorPWMRight, cnt_Left, cnt_Right);
int main() { 
    //Set Motor Settings
    en_Motor = 1; 
    
    //Set IR Settings
    enable = 1; 
    

    while(1) {
        float dist_hinten = S_hinten.read();  // gibt die Distanz in [m] zurueck  
        float dist_hinten_links = S_hinten_links.read();   
        float dist_vorne_links= S_vorne_links.read();   
        float dist_vorne = S_vorne.read();   
        float dist_vorne_rechts = S_vorne_rechts.read();   
        float dist_hinten_rechts = S_hinten_rechts.read();
       
        
        if(dist_hinten < 0.2f){
            led0 = 1; 
        }else{
            led0 = 0;    
        }
        if(dist_hinten_links < 0.2f){
            led1 = 1; 
        }else{
            led1 = 0;    
        }
        if(dist_vorne_links < 0.2f){
            led2 = 1; 
        }else{
            led2 = 0;    
        }
        if(dist_vorne < 0.2f){
            led3 = 1; 
        }else{
            led3 = 0;    
        }
        if(dist_vorne_rechts < 0.2f){
            led4 = 1; 
        }else{
            led4 = 0;    
        }
        if(dist_hinten_rechts < 0.2f){
            led5 = 1; 
        }else{
            led5 = 0;    
        }
        
        controller.setDesiredSpeedLeft(50.0); 
        controller.setDesiredSpeedRight(-50.0); 
        
        printf("Soll Links:%f    Ist Links%f    Soll Rechts:%f     Ist Rechts:%f \n\r",controller.getDesSpeedLeft(),controller.getSpeedLeft(),controller.getDesSpeedRight(),controller.getSpeedRight());
        
    }
}
