#ifndef ROBOT_H
#define ROBOT_H
#include "QEI.h"
#include "mbed.h"
#include "rtos.h"
#include "HC05.h"
//#include "MPU6050.h"
//#include "HC05.h"
//#include "ACS712.h"
//#include "MPU6050_6Axis_MotionApps20.h"
//#include "DMP.h"
//#include "IMUDATA.h"
//#include "ADNS5090.h"
#define BaudRate_bt 115200      //Baud rate of 9600
#define tx_bt       PTA2        //Bluetooth connection pins
#define rx_bt       PTA1        //Bluetooth connection pins
#define EN_BT       PTA4        //Bluetooth connection pins
//#define tx_mpu      PTE0    //MPU connection pins
//#define rx_mpu      PTE1    //MPU connection pins
//#define mpu_bandwidth MPU6050_BW_20 //set the MPU low pass filter bandwidth to 20hz

#define myledd PTB8        //status LED pin
#define CURRENTSENSOR_PIN PTB3
#define VOLTAGESENSOR_PIN PTB0

#define CURRENT_R1 180 //160.0     //values of the current sensor opamp resistors
#define CURRENT_R2 10
#define CURRENT_R3 80
#define CURRENT_R4 84.7
#define VREF3_3 3.3        //digital logic voltage
#define VREF5 5.0       //5v voltage        //NOTE: 5v voltage is consistent when using new batts, but not using old blue batts


//#define irL PTB1
//#define irC PTB3
//#define irR PTB2

#define LDR1 PTB1
#define LDR2 PTB2
#define buzz PTC8

#define MOT_PWMA_PIN   PTA5    //Motor control pins    
#define MOT_PWMB_PIN   PTA12
#define MOT_STBY_PIN   PTE31
#define MOT_AIN1_PIN   PTE30
#define MOT_AIN2_PIN   PTE29
#define MOT_BIN1_PIN   PTE24
#define MOT_BIN2_PIN   PTE25

#define M_PI 3.14159265359  //PI
#define gyroCorrect 3720    //divide raw gyro data by this to get result in RAD/SECOND (if gyroRange is 500 rad/s)

//Correct direction of motors. If number = 1, forward. If number = 0, backwards (for if motors are wired backwards)
#define MOTOR_R_DIRECTION   1
#define MOTOR_L_DIRECTION   1

#define MOTOR_INTERVAL 20     //defines the interval (in milliseconds) between when motor can be set
//NOTE: Can't make this less than 20ms, because that is the PWM frequency

//Key bindings for remote control robot - for the future try to use arrow keys instead of 'asdw'
#define ctrl_forward    'i'         //forward
#define ctrl_backward   'k'         //back
#define ctrl_left       'j'         //turn left
#define ctrl_right      'l'         //turn right
#define ctrl_calibrate  'c'         //re-calibrate the accelerometer and gyro
#define ctrl_turn_angle_cw    'o'         // turn angle
#define ctrl_turn_angle_ccw    'p'
// The nRF24L01+ supports transfers from 1 to 32 bytes, but Sparkfun's
//  "Nordic Serial Interface Board" (http://www.sparkfun.com/products/9019)
//  only handles 4 byte transfers in the ATMega code.
#define TRANSFER_SIZE   4

extern   HC05 bt;  //bluetooth connection
//extern   Serial bt;
//extern  QEI wheel;
extern QEI left;
extern QEI right;
//extern    MPU6050 mpu;   //MPU connection
extern    DigitalOut myled;   //(PTE3) Processor LED (1 = off, 0 = on)
//extern    DigitalOut btSwitch;
//extern    AnalogIn currentSensor;
extern    DigitalOut buzzer;
extern    DigitalOut key;
//extern    PwmOut buzzer;
extern    AnalogIn LDRsensor1;
extern    AnalogIn LDRsensor2;
//extern    AnalogIn voltageSensor;
    ///////////   Motor control variables   ///////////
extern    PwmOut PWMA;//(MOT_PWMA_PIN);
extern    PwmOut PWMB;//(MOT_PWMB_PIN);
extern    DigitalOut AIN1;//(MOT_AIN1_PIN);
extern    DigitalOut AIN2;//(MOT_AIN2_PIN);
extern    DigitalOut BIN1;//(MOT_BIN1_PIN);
extern    DigitalOut BIN2;//(MOT_BIN2_PIN);
extern    DigitalOut STBY;//(MOT_STBY_PIN);
    void motor_control(int Lspeed, int Rspeed);  //Input speed for motors. Integer between 0 and 100
    void stop();                           //stop motors
    void set_direction(double angle);            //set angle for the robot to face (from origin)
    void set_direction_deg(double angle);
    void set_speed(int Speed );      //set speed for robot to travel at
    void auto_enable(bool x);
    /**
    *   MPU CONTROLS
    */
    //  calibrate the gyro and accelerometer  //
   void calibrate();
    /**
    *   Status: find the distance, orientation, battery values, etc of the robot
    */
    //void distanceTravelled(double x[3])
    //void orientation(something quaternion? on xy plane?)
    double getCurrent();   //Get the current drawn by the robot
    double getCurrent(int n); //get the current, averaged over n samples
    double getVoltage();    //get the battery voltage (ask connor for completed function)
    void getIMU(float *adata, float *gdata);
    double ldrread1();
    double ldrread2();
    //void pl_buzzer1();
    void Led_on();
    void Led_off();
    double return_rotation();
    int isMPU();
    void initRobot();
    extern double pl_buzzer();
    extern void pl_buzzer(void const *args);
    extern int freq; 
    extern int rMotor;
    extern int lMotor ;
    extern int m_speed;
    extern Mutex stdio_mutex; 
    

    //Wireless connections

#endif