#include "mbed.h"
#include "DebouncedInterrupt.h"

DebouncedInterrupt mybutton(USER_BUTTON);
DigitalOut pin_out(PA_10);
DigitalOut led(LED1);
Serial sigfox(SERIAL_TX, SERIAL_RX);

bool etat = false;
bool buttontriggered = true;

void onUp()
{
    buttontriggered = true;
}

void buttonhandle()
{
    etat = !etat;
    if (etat == true) {
        led = 0;
        pin_out = 1;
        sigfox.printf("AT$ss=0000\r\n"); // code pour recevoir "eteint" sur le POC Radhius
        }
    else {
        led = 1;
        pin_out = 0;
        sigfox.printf("AT$ss=FFFF\r\n"); // code pour recevoir "allume" sur le POC Radhius
        }
}
 
int main()
{
    mybutton.attach(&onUp, IRQ_FALL, 100);
    while (1) {
        if (buttontriggered == true) {
            buttontriggered = false;
            buttonhandle();
            }
    }
}