
#include "mbed.h"
#include "eeprom.h"

EEPROM memory(PB_9,PB_8,5);// Pinname sda=PB_9 , Pinname scl=PB_8 , address=0 

int main()
{
    //// Initial data to write ///// 
    int8_t  data_dummy = 'r';
    int8_t  data[4];
    float   x = 0.0f; 
    float   j = 9785.26844;    

    //// Write data to Address 1 and 2 
    memory.write(0x0001,(int8_t)data_dummy);// write(address 16bit , data 8bit)
    wait_ms(1);
    memory.write(0x0002,(int8_t)'c');
    wait_ms(1);
    
    /// Read data from address 0x0001 to 0x0004, and store in data array  
    memory.read(0x0001,data,4); /* read at adress 0001=1 เก็บไว้ที่ array data ตำแหน่ง
    ที่ 1-4 โดยตัวที่ตำแหน่ง 0x0001 จะถูกอ่านแล้วเก้บไว้ที่ data[0]  0x0002 --> data[1]  0x0003 --> data[2] 0x0004--> data[3] */
    wait_ms(1);
    
    printf("read[1] = %c\n",data[0]);
    printf("read[2] = %c\n",data[1]);
    printf("read[3] = %c\n",data[2]);
    printf("read[4] = %c\n",data[3]);

    //// Write float data to address 0x000A
    memory.write(0x000A,j);
    wait_ms(1);

    //// Read float data, and store to x 
    memory.read(0x000A,x);// อ่านตัวแปรที่ตำแหน่ง 0x000A แล้วเก็บค่านั้นไว้ที่ x ซึ่งทำให้ตอนนี้ x=j
    wait_ms(1);
    
    printf("float = %f\n",x);
    
    /// Read data from address 0x000A to 0x000D, and store in data array  
    memory.read(0x000A,data,4);//อ่านค่าที่อยู่ใน adress 0x000A-->data[0] 0x000B-->data[1] 0x000C-->data[2] 0x000D-->data[3]
    printf("read[1]:0x000A = %X\n",(uint8_t)data[0]);
    printf("read[2]:0x000B = %X\n",(uint8_t)data[1]);
    printf("read[3]:0x000C = %X\n",(uint8_t)data[2]);
    printf("read[4]:0x000D = %X\n",(uint8_t)data[3]);
    // float j=9785.26844= 0x4618E513 แล้วถูกซอยย่อยเป็น 46-->data[3] 18-->data[2] E5-->data[1] 13-->data[0]

}