#include "mbed.h"
/**********************
 *      MCP4922
 **********************/
 
///SPI Interface
SPI MCP4922_SPI(D11,D12,D13);//MOSI ,MISO ,SCK
DigitalOut MCP4922_CS(D10);//CS

//Digital Output
DigitalOut MCP4922_LDAC(D8);
DigitalOut MCP4922_SHDN(D9);

//Analog input
AnalogIn ana(A0);
AnalogIn ou(A1);
//for change mode
DigitalIn sw(D7);

Serial ser(D1,D0);
//for 7 segment
DigitalOut sd(PC_0);
DigitalOut sc(PC_1);
DigitalOut sb(PB_0);
DigitalOut sa(PA_4);
DigitalOut sdo(D15);


DigitalOut s2d(D6);
DigitalOut s2c(D5);
DigitalOut s2b(D4);
DigitalOut s2a(D3);

void ss(float x)
{
    int nu1 = x/1000;
    int nu15= (int)x%1000;
    int nu2=nu15/100;
    BusOut a(PC_0,PC_1,PB_0,PA_4);
    a=nu1;
    BusOut b(D3,D4,D5,D6);        
    b=nu2;
    sdo=1;
    
}
int main()
{
    /******************************
     *****      setup       *******
     ******************************/

    /////////setup SPI//////////
    //set CS High
    MCP4922_CS=1;//สั่ง slave select หรือก็คือยังไม่ให้ mc4922 ทำงาน ถ้าให้ทำงานต้องส่งเป็น =0

    //set SPI mode [1,1]=> mode 3 @16bit
    MCP4922_SPI.format(16,3);// 16= จำนวนบิตที่จะส่ง ดูได้จาก datasheetของ mpc4922 bit0-bit15  3= clock polarity=1  clock phase=1

    //set SPI Frequency @20MHz
    MCP4922_SPI.frequency(1000000);

    //set Load DAC High (inactive)
    MCP4922_LDAC = 1;

    //set shutdown DAC High (inactive)
    MCP4922_SHDN = 1;

    //loop
    while(1) {
        
        /******************************************************************************
         * Set DAC output channal A @ 2.5v  Vref = 3.3v , DAC 12 bit ,Gain =0, Unbuffer
         * So DAC data = 3103
         * SPI data format CH,BUF,GA,SHDN,DATA[12:0]
         ******************************************************************************/

        /////prepare Data to tranfer/////
        //create data buffer
        uint16_t MCP4922_Sent_Data = 0; //MCP4922-Sent_Data เป็นตัวแปรขนาด 16bit
        
        int num;
        
        //switch mode
        if(sw==1){
            num=ana.read()*3.3*4096/3.31;
            }
        else {num=3.3-(ana.read()*3.3*4096/3.31);}
        
        //Set MCP4922_Sent_data[12:0] to expected DAC output
        MCP4922_Sent_Data = num & 0x0FFF;/*3103=DAC input code from analog output voltage (Vout) in datasheet    0x0FFF=bitwise 0000 1111 1111 1111 
        โดยนำ 3103 แปลงเป็นเลขฐานสอง ซึ่งจะมีเพียง 12 บิต แล้วนำเลขนั้นมา and กับ FFF ของ 0x0FFF ทำให้ตัวมันเอง ( อะไร and กับ 1 จะได้ตัวมันเอง)*/
        //Set Channal to output A => CH = 0 โดย set bit15=0
        MCP4922_Sent_Data |= 0b1000000000000000;

        //Set Buffer mode to Unbuffer => BUF = 0 โดย set bit14=0
        MCP4922_Sent_Data &= 0b1011111111111111;

        //Set GAIN mode to 1 => GA = 1 โดย set bit13=1
        MCP4922_Sent_Data |= 0b0010000000000000;

        //Set Shutdown channal mode to inactive => SHDN = 1 โดย set bit12=1
        MCP4922_Sent_Data |= 0b0001000000000000;

        /////sent data to MCP4922/////
        //set CS to LOW to activated MCP4922 SPI Interface สั่งให้เริ่มทำงานโดยให้ shift select=0
        MCP4922_CS = 0;

        //sent data buffer to mcp4922 แต่ output ยังไม่ออกเพราะ LDAC=1 อยู่
        MCP4922_SPI.write(MCP4922_Sent_Data);

        //set CS to High to End MCP4922 SPI Interface สั่งหยุดการทำงานโดยให้ shift select=1
        MCP4922_CS = 1;

        //set LDAC to LOW to Load data to output  Output ออกแล้วเพราะ LDAC=0
        MCP4922_LDAC = 0 ;
        
        //wait at least 100ns = 0.1 microsec ..... So set at 1 microsec
        wait_us(1);
        
        //set LDAC to High to prepare next output Output จะไม่ออกจนกว่า LDAC จะ=0
        MCP4922_LDAC = 1 ;
        ss(ana.read()*3300);
        //ser.printf("%0.2f \n",ou.read()*3.3);
        wait(0.01);
    }
}
