#include "mbed.h"
AnalogIn analog_value(A1);
DigitalOut l1(D13);
DigitalOut l2(D12);
DigitalOut l3(D11);
DigitalOut l4(D10);
DigitalOut l5(D9);
DigitalOut l6(D8);
DigitalOut l7(D7);
DigitalOut l8(D6);

DigitalOut sd(PC_0);
DigitalOut sc(PC_1);
DigitalOut sb(PB_0);
DigitalOut sa(PA_4);
DigitalOut sdo(PB_2);


DigitalOut s2d(PB_8);
DigitalOut s2c(PB_9);
DigitalOut s2b(PB_5);
DigitalOut s2a(PB_3);

DigitalIn  sw(D5);

void led(float mv)
{
    if (mv>413) {
        l1=1;
    } else {
        l1=0;
    }

    if (mv>825) {
        l2=1;
    } else {
        l2=0;
    }

    if (mv>1238) {
        l3=1;
    } else {
        l3=0;
    }

    if (mv>1650) {
        l4=1;
    } else {
        l4=0;
    }

    if (mv>2063) {
        l5=1;
    } else {
        l5=0;
    }

    if (mv>2475) {
        l6=1;
    } else {
        l6=0;
    }

    if (mv>2888) {
        l7=1;
    } else {
        l7=0;
    }

    if (mv>3200) {
        l8=1;
    } else {
        l8=0;
    }

    wait(0.02);
}

void ss(float x)
{
    //int segment[10][4]={{0,0,0,0},{0,0,0,1},{0,0,1,0},{0,0,1,1},{0,1,0,0},{0,1,0,1},{0,1,1,0},{0,1,1,1},{1,0,0,0},{1,0,0,1}};
    int nu1 = x/1000;
    int nu15 = (int)x%1000;
    int nu2=nu15/100;
    BusOut a(PA_4,PB_0,PC_1,PC_0);
    a=nu1;
    BusOut b(PB_3,PB_5,PB_9,PB_8);        
    b=nu2;
    sdo=1;
    
}    
int main()
{
    
    int x=0;
    while(1) {
        float meas_r = analog_value.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
        float mv = meas_r * 3300; // Converts value in the 0V-3.3V range
        if (sw==1){
            wait(0.5);
            x+=1;
            if (x>2){x=0;
            }
            }
        if (x==0){
            ss(mv);
            l1=0;
            l2=0;
            l3=0;
            l4=0;
            l5=0;
            l6=0;
            l7=0;
            l8=0;
            wait(0.01);
        }
        else {led(mv);
            ss(0);
        }
        
    }
}
