//
// This file contains function related to the motion 
// control of the home monitoring system
//

#include <vector>
#include <string>
#include <sstream>

// TODO - add timestamp to motion samples
#include "Motion.h"
  
Motion::Motion() {
    // These are motion deltas based on playing with
    // mbed application board motion sensors.
    //
    // Originally 0.097 was sufficient, but I get false 
    // motion of 0.14 sometimes.  This makes it somewhat less
    // responsive to small motion, but better than too many
    // false alarms.  I should look into motion sensors to
    // see what is up or if something has been fixed??
    min_motion.x = 0.15;  
    min_motion.y = 0.15;  
    min_motion.z = 0.15; 
	max_samples_limit = 100; // Max motion buffer is 100 deep
    max_samples = 20;
    sample_ptr = 0;
    wrapped_once = false;
	// WARNING - width here is important - must be 7 characters!
    motion_samples.resize(max_samples,"0.00000");
}

bool Motion::change_max_samples(int num_samples) {
    // WARNING - setting this dumps all saved data!
    if (num_samples > 0 && num_samples <= max_samples_limit) {
        max_samples = num_samples;
		// WARNING - width here is important - must be 7 characters!
        motion_samples.resize(max_samples, "0.00000");
		return true;
    }
    else {
        return false;
    }
}

void Motion::add_sample(double sample) {
    std::string str_sample;
    convert_sample(sample, str_sample);
    if (sample_ptr == max_samples) {
        wrapped_once = true;
        sample_ptr = 0;
        motion_samples[sample_ptr] = str_sample;
    }
    else {
        motion_samples[sample_ptr++] = str_sample;
    }
}

bool Motion::set_motion_thresh(motion_vec motion_thresh) {
	// FIXME - maybe add limit checking here.  At least 
	// limit to 7 character values?
	min_motion.x = motion_thresh.x;
	min_motion.y = motion_thresh.y;
	min_motion.z = motion_thresh.z;
	return true;
}

motion_vec Motion::get_motion_thresh(void) {
    return min_motion;
}

int Motion::get_max_samples() {
	return max_samples;
}

const std::vector<std::string> &Motion::get_samples(void) {
    // FIXME - need to copy out samples in order of oldest
    // to newest or maybe not if change to contain timestamp
    // and let the host worry about adding it.  If use multi-map
    // it would be sorted automatically.  Maybe a better idea.
    return motion_samples;
}

