#ifndef HOME_MON_COMM_H
#define HOME_MON_COMM_H

#include "USBHomeMon.h"
#include <stdio.h>
#include <vector>

/** Function to send an alert to the host
*
* @param alert - enum of different allowed alert types
* @param return - pass or fail based on ack from host
*/
bool send_alert(alert_type alert);
/** Function to wait for an ack from the host.
*
* @param return - true if host acked, false otherwise
*/
bool host_wait();
/** Function to check if host is alive
*
* Checks to see if there is any data on the serial port.  If so,
* checks command to see if it is a "connect".
*
* @param return - true if host sent connect message, false otherwise
*/
bool check_connection();
/** Function to get character over serial interface 
*
* @param return - character received over serial interface
*/
char rec_command() ;
/** Function to send multiple data samples to the host
*
* @param samples - vector of strings representing an array of values to be sent to host
* @param return - true if host properly received data, false otherwise
*/
bool send_samples(std::vector<std::string> samples);
/** Function to receive one sample from the host
*
* @param return - one sample value as a double
*/
double get_sample(void);
/** Function to parse messages from the host.  It takes the 
* motion and temperature class references to be able to set and get values.
*
* @param temp - reference to temperature object
* @param motion - reference to motion object storing motion db, thresholds, etc.
*/
void host_command_resp(msg_type msg, Temperature &temp, Motion &motion);
/** Function to parse the actual character received over serial interface
* do error checking and if okay passes it on to host_command_resp() method
*
* @param msg - Character message received from the host
*/
msg_type parse_msg(char msg) ;

#endif
