//
// This file contains function related to the temperature 
// control of the home monitoring system
//

#include "Temperature.h"
#include "HomeMonUtils.h"
#include <vector>
#include <string>
#include <sstream>

// TODO - add timestamp to temperature samples
  
Temperature::Temperature() {
	max_temp_limit = 150.0;  // Maximum allowed value
	min_temp_limit = -150.00; // Minimum allowed value
	max_samples_limit = 100; // Maximum of 100 samples in buffer
	period_limit = 0.1;  // No faster than 1/10th of a second
    min_temp = 80.0; // Farenheit
    max_temp = 86.0; // Farenheit
    temp_sample_period = 10.0;  // seconds
    max_samples = 20;
    sample_ptr = 0;
    wrapped_once = false;
	// WARNING - width is important here, must be 7 characters!
    temp_samples.resize(max_samples,"0.00000");
}

bool Temperature::change_max_samples(int num_samples) {
    // WARNING - setting this dumps all saved data!
    if (num_samples > 0  && num_samples <= max_samples_limit) {
        max_samples = num_samples;
		// WARNING - width is important here, must be 7 characters!
        temp_samples.resize(max_samples, "0.00000");
		return true;
    }
    else {
        return false;
    }
}

void Temperature::add_sample(double sample) {
    
    std::string str_sample;
    convert_sample(sample, str_sample);
    if (sample_ptr == max_samples) {
        wrapped_once = true;
        sample_ptr = 0;
        temp_samples[sample_ptr] = str_sample;
    }
    else {
        temp_samples[sample_ptr++] = str_sample;
    }
}

bool Temperature::set_period(double period) {
	// Only 7 digits max allowed in a number so make
	// sure period fits in that limit.  String sent to
	// host will be rounded to 7 digits before transmission
	if (period > period_limit && period < 999999.99) {
	    temp_sample_period = period;
		return true;
	}
	else {
		return false;
	}
}

bool Temperature::set_min(double min) {
	if (min > max_temp_limit || min < min_temp_limit || min > max_temp) {
		return false;
	}
	else {
        min_temp = min;
		return true;
	}
}

bool Temperature::set_max(double max) {
	if (max > max_temp_limit || max < min_temp_limit || max < min_temp) {
		return false;
	}
	else {
        max_temp = max;
		return true;
	}
}

double Temperature::get_min(void) {
    return min_temp;
}

double Temperature::get_max(void) {
    return max_temp;
}

double Temperature:: get_period() {
	return temp_sample_period;
}

int Temperature::get_max_samples() {
	return max_samples;
}

const std::vector<std::string> &Temperature::get_samples(void) {
    // FIXME - need to copy out samples in order of oldest
    // to newest or maybe not if change to contain timestamp
    // and let the host worry about adding it.  If use multi-map
    // it would be sorted automatically.  Maybe a better idea.
    return temp_samples;
}

