#include "mbed.h" //Librería default de mbed
#include "NVIC_set_all_priorities.h" //Librería para modificar todas las solicitudes de interrupciones al mismo tiempo
#include <ctype.h>
#include "arm_math.h" //Librería que contiene funciones de tranformada de fourier
#include "arm_const_structs.h"
#include "FastAnalogIn.h" //Librería modificada basada en la función de AnalogIn que reduce el tiempo de procesamiento de las señales ADC

//columnas
DigitalOut col0(PTA1);
DigitalOut col1(PTA2);
DigitalOut col2(PTD4);
DigitalOut col3(PTA12);
DigitalOut col4(PTA4);

//filas
DigitalOut floor1(PTA13);
DigitalOut floor2(PTD5);
DigitalOut floor3(PTD0);
DigitalOut floor4(PTD2);
DigitalOut floor5(PTD3);

 
char* x;
int count = 0;
Serial pc(USBTX, USBRX); //Se declaran los pines que se utilizarán para la comunicación serial mediante USB para debuggeo (PTA1 - RX, PTA2 - TX)
FastAnalogIn   segnal(PTC2); //Se declara el pin que recibirá la señal análoga del sensor
 
extern "C" void NMI_Handler()
{
}
 
////////////////////////////////////////////////////////////////////////////////
// CONFIGURACION
//Estos valores puedne modificarse para modificar los parametros de la transformada
////////////////////////////////////////////////////////////////////////////////
 
int SAMPLE_RATE_HZ = 40000;       // Frecuencian de muestreo en HZ del sistema
const int FFT_SIZE = 1024;           // Número de valores para la transformada rápida
float freq = 40000.0/1024.0;           // Frecuencia de activación de la interrupción de muestreo
float max[2];                        // Arreglo que almacena la frecuencia y magnitud mayores del espectro de Fourier
 
////////////////////////////////////////////////////////////////////////////////
// ESTADO INTERNO
// Configuraciones necesarias para el correcto funcionaiento del programa
////////////////////////////////////////////////////////////////////////////////
 
const static arm_cfft_instance_f32 *S;
Ticker samplingTimer;                       //objeto creado para habilitar las interrupciones con lso métodos de ticker
float samples[FFT_SIZE*2];                  //Arreglo en el que se almacenan las muestras del tomadas ADC
float magnitudes[FFT_SIZE];                 //Arreglo donde se almacenan las magnitudes de la FFT
int sampleCounter = 0;                      //Contador del número de muestras tomadas
 
////////////////////////////////////////////////////////////////////////////////
// FUNCIONES DE MUESTREO
////////////////////////////////////////////////////////////////////////////////
 
//Esta función permite realizar el muestreo de datos, se realiza como interrupción para asegurar el tiempo de muestreo deseado
void samplingCallback()
{
    // Lectura del ADC y almacenamiento del dato
    samples[sampleCounter] = (1023 * segnal) - 511.0f; //Se ajusta el valor de un rango de 0-1 a 0-511
    // La función que calcula la transformada requiere de un valor imaginario, en este caso se le asigna 0
    // ya que los valores muestreados son solamente reales.
    samples[sampleCounter+1] = 0.0;
    // Se ajusta la posición en el arreglo para almacenar el siguiente valor real
    sampleCounter += 2;
    //En caso de que el valor de sample counter sobrepase el tamaño del arreglo de almacenamiento se retira la interrupción
    //de muestreo del programa
    if (sampleCounter >= FFT_SIZE*2) {
        samplingTimer.detach();
    }
}
 
//Esta función permite reiniciar el contador de muestras e insertar nuevamente la interrupción de muestreo
void samplingBegin()
{
    sampleCounter = 0; //Se reinicia el contador de muestras
    samplingTimer.attach_us(&samplingCallback, 1000000/SAMPLE_RATE_HZ); //Se incertala interrupción de muestreo la cual es llamada con la frecuencia de Sample_rate_hz
}
 
//Función booleana que funciona como bandera para indicar que el meustreo de datos ha sido finalizado
bool samplingIsDone()
{
    return sampleCounter >= FFT_SIZE*2;
}
 
////////////////////////////////////////////////////////////////////////////////
// MAIN DEL PROGRAMA
////////////////////////////////////////////////////////////////////////////////
 
int main()
{
    //Configuración de las solicitudes de interrupción
    NVIC_set_all_irq_priorities(1);
 
    //Configuración de la velocidad de la comunicación serial
    pc.baud (115200); //Velocidad de la comunicación USB
 
    // Se incerta la interrupción de muestreo del ADC
    samplingBegin();
 
    // Init arm_ccft_32 el registro cambiara dependiendo de la variable FFT_SIZE
    switch (FFT_SIZE) {
        case 512:
            S = & arm_cfft_sR_f32_len512;
            break;
        case 1024:
            S = & arm_cfft_sR_f32_len1024;
            break;
        case 2048:
            S = & arm_cfft_sR_f32_len2048;
            break;
        case 4096:
            S = & arm_cfft_sR_f32_len4096;
            break;
    }
 
    while(1) {
        // Se calcula la FFT si se ha terminado el muestreo
        if (samplingIsDone()) {
 
            arm_cfft_f32(S, samples, 0, 1);
            arm_cmplx_mag_f32(samples, magnitudes, FFT_SIZE);
 
            for (int i = 0; i < FFT_SIZE/2+1; ++i) {
                //    pc.printf("%f, %f\r\n", i*freq, magnitudes[i]);  //Esta línea se activa solo si se desea conocer la magnitudes generada por la FFT
                //Sección de código que permite obtener el valor de frecuencia y magnitud mayor de los calculados
                if (magnitudes[i]>max[1]) {
                    max[0]=i*freq;
                    max[1]=magnitudes[i]; //Habilitar solo para debuggeo
                }
            }
            
            if (190<max[0] && max[0]<205) {
                x="primer patron";
                
                floor1 = 1;
                col3=1;
                col1=1;
                col0=1;
                wait_us(208);
                floor1 = 0;
                col3=0;
                col1=0;
                col0=0;
                wait_us(208);
                
                floor1 = 1;
                col3=1;
                col2=1;
                wait_us(208);
                floor1 = 0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor1 = 1;
                col3=1;
                col2=1;
                col0=1;
                wait_us(208);
                floor1 = 0;
                col3=0;
                col2=0;
                col0=0;
                wait_us(208);
                
            } else if (230<max[0] && max[0]<250) {
                x="segundo patron";
                
                floor1 = 1;
                col3=1;
                col1=1;
                col0=1;
                wait_us(208);
                floor1 = 0;
                col3=0;
                col1=0;
                col0=0;
                wait_us(208);
                
                floor1 = 1;
                col3=1;
                col2=1;
                wait_us(208);
                floor1 = 0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor1 = 1;
                col3=1;
                col2=1;
                col0=1;
                wait_us(208);
                floor1 = 0;
                col3=0;
                col2=0;
                col0=0;
                wait_us(208);
                
                floor2 = 1;
                col2=1;
                col1=1;
                wait_us(208);
                floor2 = 0;
                col2=0;
                col1=0;
                wait_us(208);
                
                floor2 = 1;
                col2=1;
                col1=1;
                col0=1;
                wait_us(208);
                floor2 = 0;
                col2=0;
                col1=0;
                col0=0;
                wait_us(208);
                
                floor2 = 1;
                col3=1;
                wait_us(208);
                floor2 = 0;
                col3=0;
                wait_us(208);
                
                floor2 = 1;
                col3=1;
                col1=1;
                col0=1;
                wait_us(208);
                floor2 = 0;
                col3=0;
                col1=0;
                col0=0;
                wait_us(208);
                
                
                floor2 = 1;
                col3=1;
                col2=1;
                wait_us(208);
                floor2 = 0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor2 = 1;
                col3=1;
                col2=1;
                col0=1;
                wait_us(208);
                floor2 = 1;
                col3=0;
                col2=0;
                col0=0;
                wait_us(208);
                
                floor2 = 1;
                col4=1;
                wait_us(208);
                floor2 = 0;
                col4=0;
                wait_us(208);
                
                floor2 = 1;
                col4=1;
                col0=1;
                wait_us(208);
                floor2 = 0;
                col4=0;
                col0=0;
                wait_us(208);
                
                floor2 = 1;
                col4=1;
                col1=1;
                wait_us(208);
                floor2 = 0;
                col4=0;
                col1=0;
                wait_us(208);
                
            } else if (310<max[0] && max[0]<320) {
                x="tercer patron";
                
                floor1 = 1;
                col3=1;
                col1=1;
                col0=1;
                wait_us(208);
                floor1 = 0;
                col3=0;
                col1=0;
                col0=0;
                wait_us(208);
                
                floor1 = 1;
                col3=1;
                col2=1;
                wait_us(208);
                floor1 = 0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor1 = 1;
                col3=1;
                col2=1;
                col0=1;
                wait_us(208);
                floor1 = 0;
                col3=0;
                col2=0;
                col0=0;
                wait_us(208);
                
                floor2 = 1;
                col2=1;
                col1=1;
                wait_us(208);
                floor2 = 0;
                col2=0;
                col1=0;
                wait_us(208);
                
                floor2 = 1;
                col2=1;
                col1=1;
                col0=1;
                wait_us(208);
                floor2 = 0;
                col2=0;
                col1=0;
                col0=0;
                wait_us(208);
                
                floor2 = 1;
                col3=1;
                wait_us(208);
                floor2 = 0;
                col3=0;
                wait_us(208);
                
                floor2 = 1;
                col3=1;
                col1=1;
                col0=1;
                wait_us(208);
                floor2 = 0;
                col3=0;
                col1=0;
                col0=0;
                wait_us(208);
                
                
                floor2 = 1;
                col3=1;
                col2=1;
                wait_us(208);
                floor2 = 0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor2 = 1;
                col3=1;
                col2=1;
                col0=1;
                wait_us(208);
                floor2 = 1;
                col3=0;
                col2=0;
                col0=0;
                wait_us(208);
                
                floor2 = 1;
                col4=1;
                wait_us(208);
                floor2 = 0;
                col4=0;
                wait_us(208);
                
                floor2 = 1;
                col4=1;
                col0=1;
                wait_us(208);
                floor2 = 0;
                col4=0;
                col0=0;
                wait_us(208);
                
                floor2 = 1;
                col4=1;
                col1=1;
                wait_us(208);
                floor2 = 0;
                col4=0;
                col1=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                wait_us(208);
                
                floor3 = 1;
                col1=1;
                wait_us(208);
                floor3 = 0;
                col1=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col1=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col1=0;
                wait_us(208);
                
                floor3 = 1;
                col1=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col1=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col1=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col1=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col3=1;
                wait_us(208);
                floor3 = 0;
                col3=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col1=1;
                col3=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col1=0;
                col3=0;
                wait_us(208);
                
                floor3 = 1;
                col3=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col3=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col4=1;
                wait_us(208);
                floor3 = 0;
                col4=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col4=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col4=0;
                wait_us(208);
                
                floor3 = 1;
                col1=1;
                col4=1;
                wait_us(208);
                floor3 = 0;
                col1=0;
                col4=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col4=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col4=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col4=1;
                col1=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col4=0;
                col1=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col1=1;
                col2=1;
                col4=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col1=0;
                col2=0;
                col4=0;
                wait_us(208);
                
            } else if (385<max[0] && max[0]<400) {
                x="cuarto patron";
                
                floor1 = 1;
                col3=1;
                col1=1;
                col0=1;
                wait_us(208);
                floor1 = 0;
                col3=0;
                col1=0;
                col0=0;
                wait_us(208);
                
                floor1 = 1;
                col3=1;
                col2=1;
                wait_us(208);
                floor1 = 0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor1 = 1;
                col3=1;
                col2=1;
                col0=1;
                wait_us(208);
                floor1 = 0;
                col3=0;
                col2=0;
                col0=0;
                wait_us(208);
                
                floor2 = 1;
                col2=1;
                col1=1;
                wait_us(208);
                floor2 = 0;
                col2=0;
                col1=0;
                wait_us(208);
                
                floor2 = 1;
                col2=1;
                col1=1;
                col0=1;
                wait_us(208);
                floor2 = 0;
                col2=0;
                col1=0;
                col0=0;
                wait_us(208);
                
                floor2 = 1;
                col3=1;
                wait_us(208);
                floor2 = 0;
                col3=0;
                wait_us(208);
                
                floor2 = 1;
                col3=1;
                col1=1;
                col0=1;
                wait_us(208);
                floor2 = 0;
                col3=0;
                col1=0;
                col0=0;
                wait_us(208);
                
                
                floor2 = 1;
                col3=1;
                col2=1;
                wait_us(208);
                floor2 = 0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor2 = 1;
                col3=1;
                col2=1;
                col0=1;
                wait_us(208);
                floor2 = 1;
                col3=0;
                col2=0;
                col0=0;
                wait_us(208);
                
                floor2 = 1;
                col4=1;
                wait_us(208);
                floor2 = 0;
                col4=0;
                wait_us(208);
                
                floor2 = 1;
                col4=1;
                col0=1;
                wait_us(208);
                floor2 = 0;
                col4=0;
                col0=0;
                wait_us(208);
                
                floor2 = 1;
                col4=1;
                col1=1;
                wait_us(208);
                floor2 = 0;
                col4=0;
                col1=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                wait_us(208);
                
                floor3 = 1;
                col1=1;
                wait_us(208);
                floor3 = 0;
                col1=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col1=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col1=0;
                wait_us(208);
                
                floor3 = 1;
                col1=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col1=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col1=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col1=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col3=1;
                wait_us(208);
                floor3 = 0;
                col3=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col1=1;
                col3=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col1=0;
                col3=0;
                wait_us(208);
                
                floor3 = 1;
                col3=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col3=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col4=1;
                wait_us(208);
                floor3 = 0;
                col4=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col4=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col4=0;
                wait_us(208);
                
                floor3 = 1;
                col1=1;
                col4=1;
                wait_us(208);
                floor3 = 0;
                col1=0;
                col4=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col4=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col4=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col4=1;
                col1=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col4=0;
                col1=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col1=1;
                col2=1;
                col4=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col1=0;
                col2=0;
                col4=0;
                wait_us(208);
                
                floor4 = 1;
                col0=1;
                wait_us(208);
                floor4 = 0;
                col0=0;
                wait_us(208);
                
                floor4 = 1;
                col1=1;
                wait_us(208);
                floor4 = 0;
                col1=0;
                wait_us(208);
                
                floor4 = 1;
                col0=1;
                col1=1;
                wait_us(208);
                floor4 = 0;
                col0=0;
                col1=0;
                wait_us(208);
                
                floor4 = 1;
                col1=1;
                col2=1;
                wait_us(208);
                floor4 = 0;
                col1=0;
                col2=0;
                wait_us(208);
                
                floor4 = 1;
                col0=1;
                col1=1;
                col2=1;
                wait_us(208);
                floor4 = 0;
                col0=0;
                col1=0;
                col2=0;
                wait_us(208);
                
                floor4 = 1;
                col3=1;
                wait_us(208);
                floor4 = 0;
                col3=0;
                wait_us(208);
                
                floor4 = 1;
                col0=1;
                col1=1;
                col3=1;
                wait_us(208);
                floor4 = 0;
                col0=0;
                col1=0;
                col3=0;
                wait_us(208);
                
                floor4 = 1;
                col3=1;
                col2=1;
                wait_us(208);
                floor4 = 0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor4 = 1;
                col0=1;
                col3=1;
                col2=1;
                wait_us(208);
                floor4 = 0;
                col0=0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor4 = 1;
                col4=1;
                wait_us(208);
                floor4 = 0;
                col4=0;
                wait_us(208);
                
                floor4 = 1;
                col0=1;
                col4=1;
                wait_us(208);
                floor4 = 0;
                col0=0;
                col4=0;
                wait_us(208);
                
                floor4 = 1;
                col1=1;
                col4=1;
                wait_us(208);
                floor4 = 0;
                col1=0;
                col4=0;
                wait_us(208);
                
                floor4 = 1;
                col0=1;
                col4=1;
                col2=1;
                wait_us(208);
                floor4 = 0;
                col0=0;
                col4=0;
                col2=0;
                wait_us(208);
                
                floor4 = 1;
                col4=1;
                col1=1;
                col2=1;
                wait_us(208);
                floor4 = 0;
                col4=0;
                col1=0;
                col2=0;
                wait_us(208);
                
                floor4 = 1;
                col0=1;
                col1=1;
                col2=1;
                col4=1;
                wait_us(208);
                floor4 = 0;
                col0=0;
                col1=0;
                col2=0;
                col4=0;
                wait_us(208);
                
            } else if (495<max[0] && max[0]<505) {
                x="quinto patron";
                
                floor1 = 1;
                col3=1;
                col1=1;
                col0=1;
                wait_us(208);
                floor1 = 0;
                col3=0;
                col1=0;
                col0=0;
                wait_us(208);
                
                floor1 = 1;
                col3=1;
                col2=1;
                wait_us(208);
                floor1 = 0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor1 = 1;
                col3=1;
                col2=1;
                col0=1;
                wait_us(208);
                floor1 = 0;
                col3=0;
                col2=0;
                col0=0;
                wait_us(208);
                
                floor2 = 1;
                col2=1;
                col1=1;
                wait_us(208);
                floor2 = 0;
                col2=0;
                col1=0;
                wait_us(208);
                
                floor2 = 1;
                col2=1;
                col1=1;
                col0=1;
                wait_us(208);
                floor2 = 0;
                col2=0;
                col1=0;
                col0=0;
                wait_us(208);
                
                floor2 = 1;
                col3=1;
                wait_us(208);
                floor2 = 0;
                col3=0;
                wait_us(208);
                
                floor2 = 1;
                col3=1;
                col1=1;
                col0=1;
                wait_us(208);
                floor2 = 0;
                col3=0;
                col1=0;
                col0=0;
                wait_us(208);
                
                
                floor2 = 1;
                col3=1;
                col2=1;
                wait_us(208);
                floor2 = 0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor2 = 1;
                col3=1;
                col2=1;
                col0=1;
                wait_us(208);
                floor2 = 1;
                col3=0;
                col2=0;
                col0=0;
                wait_us(208);
                
                floor2 = 1;
                col4=1;
                wait_us(208);
                floor2 = 0;
                col4=0;
                wait_us(208);
                
                floor2 = 1;
                col4=1;
                col0=1;
                wait_us(208);
                floor2 = 0;
                col4=0;
                col0=0;
                wait_us(208);
                
                floor2 = 1;
                col4=1;
                col1=1;
                wait_us(208);
                floor2 = 0;
                col4=0;
                col1=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                wait_us(208);
                
                floor3 = 1;
                col1=1;
                wait_us(208);
                floor3 = 0;
                col1=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col1=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col1=0;
                wait_us(208);
                
                floor3 = 1;
                col1=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col1=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col1=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col1=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col3=1;
                wait_us(208);
                floor3 = 0;
                col3=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col1=1;
                col3=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col1=0;
                col3=0;
                wait_us(208);
                
                floor3 = 1;
                col3=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col3=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col4=1;
                wait_us(208);
                floor3 = 0;
                col4=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col4=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col4=0;
                wait_us(208);
                
                floor3 = 1;
                col1=1;
                col4=1;
                wait_us(208);
                floor3 = 0;
                col1=0;
                col4=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col4=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col4=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col4=1;
                col1=1;
                col2=1;
                wait_us(208);
                floor3 = 0;
                col4=0;
                col1=0;
                col2=0;
                wait_us(208);
                
                floor3 = 1;
                col0=1;
                col1=1;
                col2=1;
                col4=1;
                wait_us(208);
                floor3 = 0;
                col0=0;
                col1=0;
                col2=0;
                col4=0;
                wait_us(208);
                
                floor4 = 1;
                col0=1;
                wait_us(208);
                floor4 = 0;
                col0=0;
                wait_us(208);
                
                floor4 = 1;
                col1=1;
                wait_us(208);
                floor4 = 0;
                col1=0;
                wait_us(208);
                
                floor4 = 1;
                col0=1;
                col1=1;
                wait_us(208);
                floor4 = 0;
                col0=0;
                col1=0;
                wait_us(208);
                
                floor4 = 1;
                col1=1;
                col2=1;
                wait_us(208);
                floor4 = 0;
                col1=0;
                col2=0;
                wait_us(208);
                
                floor4 = 1;
                col0=1;
                col1=1;
                col2=1;
                wait_us(208);
                floor4 = 0;
                col0=0;
                col1=0;
                col2=0;
                wait_us(208);
                
                floor4 = 1;
                col3=1;
                wait_us(208);
                floor4 = 0;
                col3=0;
                wait_us(208);
                
                floor4 = 1;
                col0=1;
                col1=1;
                col3=1;
                wait_us(208);
                floor4 = 0;
                col0=0;
                col1=0;
                col3=0;
                wait_us(208);
                
                floor4 = 1;
                col3=1;
                col2=1;
                wait_us(208);
                floor4 = 0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor4 = 1;
                col0=1;
                col3=1;
                col2=1;
                wait_us(208);
                floor4 = 0;
                col0=0;
                col3=0;
                col2=0;
                wait_us(208);
                
                floor4 = 1;
                col4=1;
                wait_us(208);
                floor4 = 0;
                col4=0;
                wait_us(208);
                
                floor4 = 1;
                col0=1;
                col4=1;
                wait_us(208);
                floor4 = 0;
                col0=0;
                col4=0;
                wait_us(208);
                
                floor4 = 1;
                col1=1;
                col4=1;
                wait_us(208);
                floor4 = 0;
                col1=0;
                col4=0;
                wait_us(208);
                
                floor4 = 1;
                col0=1;
                col4=1;
                col2=1;
                wait_us(208);
                floor4 = 0;
                col0=0;
                col4=0;
                col2=0;
                wait_us(208);
                
                floor4 = 1;
                col4=1;
                col1=1;
                col2=1;
                wait_us(208);
                floor4 = 0;
                col4=0;
                col1=0;
                col2=0;
                wait_us(208);
                
                floor4 = 1;
                col0=1;
                col1=1;
                col2=1;
                col4=1;
                wait_us(208);
                floor4 = 0;
                col0=0;
                col1=0;
                col2=0;
                col4=0;
                wait_us(208);
                
                floor5 = 1;
                col1=1;
                col2=1;
                wait_us(208);
                floor5 = 0;
                col1=0;
                col2=0;
                wait_us(208);
                
                floor5 = 1;
                col1=1;
                col2=1;
                col0=1;
                wait_us(208);
                floor5 = 0;
                col1=0;
                col2=0;
                col0=0;
                wait_us(208);
                
                floor5 = 1;
                col3=1;
                wait_us(208);
                floor5 = 0;
                col3=0;
                wait_us(208);
                
                floor5 = 1;
                col4=1;
                wait_us(208);
                floor5 = 0;
                col4=0;
                wait_us(208);
                
                floor5 = 1;
                col4=1;
                col0=1;
                wait_us(208);
                floor5 = 0;
                col4=0;
                col0=0;
                wait_us(208);
                
                floor5 = 1;
                col4=1;
                col1=1;
                wait_us(208);
                floor5 = 0;
                col4=0;
                col1=0;
                wait_us(208);
                
            }/* else if (618<max[0] && max[0]<635) {
                x="sexto patron";
            } else if (775<max[0] && max[0]<805) {
                x="septimo patron";
            } else if (995<max[0] && max[0]<1025) {
                x="octavo patron";
            }*/
            count++;
            if(count == 5){
                pc.printf("%s",x);
                count = 0;
            }
            
            max[0]=0;
            max[1]=0;
 
            // Se vuelve a incertar la interrupción de muestreo
            samplingBegin();
        }
    }
}