
/************** Program rele  *******************************/

#include <mbed.h>
#include "rtos.h"

#include "task.h"
#include "ext_vars.h"

#define UART_BAUD 	9600	// скорость 
#define MAX_LEN  	30		// макс. длинна строки  usb

//--------------- input / output ---------------------------------------
// outputs
DigitalOut led(PC_13);			// выход LED на плате

DigitalOut y_01(PB_12);			// out y01
DigitalOut y_02(PB_13);			// out y02
DigitalOut y_03(PB_14);			// out y03
DigitalOut y_04(PB_15);			// out y04
DigitalOut y_05(PA_8);			// out y05
DigitalOut y_06(PA_9);			// out y06

// inputs
DigitalIn  x_01(PB_9);			// inp x01
DigitalIn  x_02(PB_8);			// inp x02
DigitalIn  x_03(PB_7);			// inp x03
DigitalIn  x_04(PB_6);			// inp x04
DigitalIn  x_05(PB_5);			// inp x05
DigitalIn  x_06(PB_4);			// inp x06
DigitalIn  x_07(PB_3);			// inp x07	
DigitalIn  x_08(PA_15);	    	// inp x08

//------- discr input  ------------
DigitalIn  swd_01(PA_0);		// dip 1
DigitalIn  swd_02(PA_1);		// dip 2
DigitalIn  swd_03(PA_2);		// dip 3
DigitalIn  swd_04(PA_3);		// dip 4 

//--------  Prototype functions ----------------------------------------
void 	read_inputs(); 			// сохр.состояния входов в памяти
void 	write_outs();			// формирование выходов
void    save_stat();			// сохранение сост. переменных
void	logic_tasks();			// логические задачи
void  	timers();				// обработка таймеров
int   	read_val(); 			// вычитывание значения из строки
void	pc_rd();				// работа с serial портом 

/*********************  Threads  **************************************/
Thread	read_uart;

//--------  for SERIAL interface ---------------------------------------
Serial pc(PB_10, PB_11);		// tx, rx
int    pc_i = 99;
int    pc_m = 0;
char   pc_buffer[100];

//----------- Local vars -----------------------------------------------
int delay_time = 10;
int t_sys = 0; 

// Переменные для проверки прихода значений из енергонезависимой памяти с rasp-pico
int check_par1 = 0;
int check_par2 = 0;
int check_par3 = 0;
int check_par4 = 0;
int check_par5 = 0;


//----------- EXT VARS -------------------------------------------------
// DC inputs
int x01 = 0;		int x01_m = 0; 
int x02 = 0;		int x02_m = 0; 
int x03 = 0;		int x03_m = 0; 
int x04 = 0;		int x04_m = 0; 
int x05 = 0;		int x05_m = 0; 
int x06 = 0;		int x06_m = 0; 
int x07 = 0;		int x07_m = 0; 
int x08 = 0;		int x08_m = 0;
// Dip inputs 
int swd01 = 0; 		int swd01_m = 0;
int swd02 = 0;		int swd02_m = 0;
int swd03 = 0;		int swd03_m = 0;
int swd04 = 0;		int swd04_m = 0;
// Outputs
int y01 = 0;		int y01_m = 0; 
int y02 = 0;		int y02_m = 0; 
int y03 = 0;		int y03_m = 0; 
int y04 = 0;		int y04_m = 0; 
int y05 = 0;		int y05_m = 0; 
int y06 = 0;		int y06_m = 0; 
// Timers
int t01 = 0;		int t101 = 0;
int t02 = 0;		int t102 = 0;
int t03 = 0;		int t103 = 0;
int t04 = 0;		int t104 = 0;
int t05 = 0;		int t105 = 0;
// Parametrs
int pr001 = 0; 	
int pr002 = 0; 	
int pr003 = 0; 	
int pr004 = 0; 	
int pr005 = 0; 
// Alarms
int al000 = 0;
// VrXXX 
int vr000 = 0;
int vr001 = 1;

/****************************  main  **********************************/
int main(void)
{		
	//----- настраиваем порт serial  ------ 
	pc.baud(UART_BAUD);
	
	//--- запускаем логич.задач по таймеру  delay_time msec ------
    RtosTimer t_msec(&logic_tasks); 
    t_msec.start(delay_time); 	
    
    //-------  запускаем  потоки  Thread  ------
    read_uart.start(pc_rd); // чтение UART
	
    while(true)
    {
		led = !led;
		
		// проверяем usb
       	if (pc_i > 1 && pc_i == pc_m) {            
            pc_buffer[pc_i++] = 0; pc_i = 0; 
			// ---  устанавливаем значение  переменных ----
            if(strstr(pc_buffer, "=")) {
				if(strstr(pc_buffer, "pr001")) { pr001 = read_val(); pc.printf("ok\n"); check_par1 = 1; }
				if(strstr(pc_buffer, "pr002")) { pr002 = read_val(); pc.printf("ok\n"); check_par2 = 1; }
				if(strstr(pc_buffer, "pr003")) { pr003 = read_val(); pc.printf("ok\n"); check_par3 = 1; }
				if(strstr(pc_buffer, "pr004")) { pr004 = read_val(); pc.printf("ok\n"); check_par4 = 1; }
				if(strstr(pc_buffer, "pr005")) { pr005 = read_val(); pc.printf("ok\n"); check_par5 = 1; }	
				
				if(strstr(pc_buffer, "vr000")) { vr000 = read_val(); pc.printf("ok\n"); }
				if(strstr(pc_buffer, "vr001")) { vr001 = read_val(); pc.printf("ok\n"); }
				
				if(strstr(pc_buffer, "al000")) { al000 = read_val(); pc.printf("ok\n"); }
			}
			
			// --- отправляем в serial значение переменных --- 
			if(strstr(pc_buffer, "?")) {
				if(strstr(pc_buffer, "pr001?")) { pc.printf("pr001:%d\n", pr001); }
				if(strstr(pc_buffer, "pr002?")) { pc.printf("pr002:%d\n", pr002); }
				if(strstr(pc_buffer, "pr003?")) { pc.printf("pr003:%d\n", pr003); }
				if(strstr(pc_buffer, "pr004?")) { pc.printf("pr004:%d\n", pr004); }
				if(strstr(pc_buffer, "pr005?")) { pc.printf("pr005:%d\n", pr005); }
				
				if(strstr(pc_buffer, "vr000?")) { pc.printf("vr000:%d\n", vr000); }
				if(strstr(pc_buffer, "vr001?")) { pc.printf("vr001:%d\n", vr001); }
				
				if(strstr(pc_buffer, "al000?")) { pc.printf("al000:%d\n", al000); }
			}
			
		 } else { pc_m = pc_i; } 

		Thread::wait(250);
    }
}

/****************  логические задачи контроллера  *********************/

// логические  задачи.  вызываются для выполнения
// каждые delay_time мсек
void logic_tasks() {
	
	// подготовка входн.информации  
	timers();      
	read_inputs();
	
	// логичeские задачи (организационный блок)
	// запускаем лог задачи только после получения всех параметров из rasp-pico 
	if(check_par1 == 1 && check_par2 == 1 && check_par3 == 1
	   && check_par4 == 1 && check_par5 == 1) {
		task();
	}
	
	// формирование выходн.информации
	write_outs(); 
	save_stat(); 
}

//----------------------------------------
// формирование  значения  переменных
// в соответствии  с  сигналами на  входах контроллер
void read_inputs() {
	// читаем локальные входа контроллера
	x01 = x_01;		x05 = x_05;
	x02 = x_02;		x06 = x_06;
	x03 = x_03;		x07 = x_07;
	x04 = x_04;		x08 = x_08;
	swd01 = swd_01; swd02 = swd_02;
	swd03 = swd_03; swd04 = swd_04;   	
}

//----------------------------------------
// установка   выходов  контроллера
// в соответствии  значения преременным
void write_outs(){
	// устанавливаем локальные выходы 
	y_01 = y01;	y_04 = y04;
	y_02 = y02;	y_05 = y05;
	y_03 = y03;	y_06 = y06;
}

//----------------------------------------
//  сохранение значения переменных  для  обработки
//  в  след.цикле  (установка, сброс)
void save_stat(){	
	x01_m = x01; x02_m = x02; x03_m = x03; x04_m = x04;    
	x05_m = x05; x06_m = x06; x07_m = x07; x08_m = x08;    
	y01_m = y01; y02_m = y02; y03_m = y03; y04_m = y04;    
	y05_m = y05; y06_m = y06;
	swd01_m = swd01; 
	swd02_m = swd02; 
	swd03_m = swd03; 
	swd04_m	= swd04; 
}

//----------------------------------------
//  изменение значения  секундных  и  милисекундных  таймеров 
//  (дискретность delay_time мсек)
void timers(){
	
	int i = delay_time;  	// время цикла в мсек
	int max1 = 60000;		// макс. значение  для мсек таймеров (60sec)
	int max2 = 36000;		// макс. значение для сек  таймеров  (10час)
	
	// timers,  1s
	if(t_sys < 1000) {
		t_sys = t_sys + i;
	} else {
		t_sys = 0;
		if(t101 < max2) { t101 = t101 + 1; }
		if(t102 < max2) { t102 = t102 + 1; }
		if(t103 < max2) { t103 = t103 + 1; }
		if(t104 < max2) { t104 = t104 + 1; }
		if(t105 < max2) { t105 = t105 + 1; }
	}
	
	// timers,  10ms
	if(t01 < max1) { t01 = t01 + i; }
	if(t02 < max1) { t02 = t02 + i; }
	if(t03 < max1) { t03 = t03 + i; }
	if(t04 < max1) { t04 = t04 + i; }
	if(t05 < max1) { t05 = t05 + i; }
}

//----------------------------------------
// поиск и чтение  значения  из  строки 
// возвращает целое число. 0-999999 
int read_val() {
	char inp_c[10];
	int  val = 0;
	int  i = 0;
	int  p = 0;
	
	while(p < MAX_LEN) {	
		if(pc_buffer[p] == '=') { break; }
		p++; 
	}
	
	p++;
	i = 0; if(pc_buffer[p + i] >= 48 && pc_buffer[p + i] <= 57) { inp_c[i] = pc_buffer[p + i]; } else { inp_c[i] = 0; }
	i = 1; if(pc_buffer[p + i] >= 48 && pc_buffer[p + i] <= 57) { inp_c[i] = pc_buffer[p + i]; } else { inp_c[i] = 0; }
	i = 2; if(pc_buffer[p + i] >= 48 && pc_buffer[p + i] <= 57) { inp_c[i] = pc_buffer[p + i]; } else { inp_c[i] = 0; }
	i = 3; if(pc_buffer[p + i] >= 48 && pc_buffer[p + i] <= 57) { inp_c[i] = pc_buffer[p + i]; } else { inp_c[i] = 0; }
	i = 4; if(pc_buffer[p + i] >= 48 && pc_buffer[p + i] <= 57) { inp_c[i] = pc_buffer[p + i]; } else { inp_c[i] = 0; }
	i = 5; if(pc_buffer[p + i] >= 48 && pc_buffer[p + i] <= 57) { inp_c[i] = pc_buffer[p + i]; } else { inp_c[i] = 0; }
	inp_c[6] = 0 ;
	
	val = atoi(inp_c);
	return val;
}

//----------------------------------------
// посимвольный прием из USB и  сохранение  
// информации в буфере, обрабатывается после того как все принято
void pc_rd()
{
	sprintf(pc_buffer, "buff_ok");
	while(1) 
	{
		if(pc.readable()) {
			pc_buffer[pc_i] = pc.getc();
			if(pc_i < MAX_LEN) { pc_i++; }
			pc_buffer[pc_i] = 0; 
		}
	}
}


