
/************** Program rele  *******************************/

#include <mbed.h>
#include "rtos.h"

#include "task.h"
#include "ext_vars.h"

//--------------- input / output ---------------------------------------
// outputs
DigitalOut led(PC_13);			// выход LED на плате
DigitalOut led_r(PB_11);		// выход LED red on case
DigitalOut led_b(PB_10);		// выход LED blue on case 

DigitalOut y_01(PB_12);			// out y01
DigitalOut y_02(PB_13);			// out y02
DigitalOut y_03(PB_14);			// out y03
DigitalOut y_04(PB_15);			// out y04
DigitalOut y_05(PA_8);			// out y05
DigitalOut y_06(PA_9);			// out y06

// inputs
DigitalIn  x_01(PB_9);			// inp x01
DigitalIn  x_02(PB_8);			// inp x02
DigitalIn  x_03(PB_7);			// inp x03
DigitalIn  x_04(PB_6);			// inp x04
DigitalIn  x_05(PB_5);			// inp x05
DigitalIn  x_06(PB_4);			// inp x06
DigitalIn  x_07(PB_3);			// inp x07	
DigitalIn  x_08(PA_15);	    	// inp x08

//------- discr input  ------------
DigitalIn  swd_01(PA_0);		// dip 1
DigitalIn  swd_02(PA_1);		// dip 2
DigitalIn  swd_03(PA_2);		// dip 3
DigitalIn  swd_04(PA_3);		// dip 4 

//--------  Prototype functions ----------------------------------------
void 	read_inputs(); 			// сохр.состояния входов в памяти
void 	write_outs();			// формирование выходов
void    save_stat();			// сохранение сост. переменных
void	logic_tasks();			// логические задачи
void  	timers();				// обработка таймеров

//----------- Local vars -----------------------------------------------
int delay_time = 10;
int t_sys = 0; 

//----------- EXT VARS -------------------------------------------------
// DC inputs
int x01 = 0;		int x01_m = 0; 
int x02 = 0;		int x02_m = 0; 
int x03 = 0;		int x03_m = 0; 
int x04 = 0;		int x04_m = 0; 
int x05 = 0;		int x05_m = 0; 
int x06 = 0;		int x06_m = 0; 
int x07 = 0;		int x07_m = 0; 
int x08 = 0;		int x08_m = 0;
// Dip inputs 
int swd01 = 0; 		int swd01_m = 0;
int swd02 = 0;		int swd02_m = 0;
int swd03 = 0;		int swd03_m = 0;
int swd04 = 0;		int swd04_m = 0;
// Outputs
int y01 = 0;		int y01_m = 0; 
int y02 = 0;		int y02_m = 0; 
int y03 = 0;		int y03_m = 0; 
int y04 = 0;		int y04_m = 0; 
int y05 = 0;		int y05_m = 0; 
int y06 = 0;		int y06_m = 0; 
// Timers
int t01 = 0;		int t101 = 0;
int t02 = 0;		int t102 = 0;
int t03 = 0;		int t103 = 0;
int t04 = 0;		int t104 = 0;
int t05 = 0;		int t105 = 0;

/****************************  main  **********************************/
int main(void)
{		
	//--- запускаем логич.задач по таймеру  delay_time msec ------
    RtosTimer t_msec(&logic_tasks); 
    t_msec.start(delay_time); 	
	
    while(true)
    {
		Thread::wait(250);
    }
}

/****************  логические задачи контроллера  *********************/

// логические  задачи.  вызываются для выполнения
// каждые delay_time мсек
void logic_tasks() {
	
	// подготовка входн.информации  
	timers();      
	read_inputs();
	
	// логичeские задачи 
	task(); 
	
	// формирование выходн.информации
	write_outs(); 
	save_stat(); 
}

//----------------------------------------
// формирование  значения  переменных
// в соответствии  с  сигналами на  входах контроллер
void read_inputs() {
	// читаем локальные входа контроллера
	x01 = x_01;	x05 = x_05;
	x02 = x_02;	x06 = x_06;
	x03 = x_03;	x07 = x_07;
	x04 = x_04;	x08 = x_08;
	swd01 = swd_01; swd02 = swd_02;
	swd03 = swd_03; swd04 = swd_04; 
}

//----------------------------------------
// установка   выходов  контроллера
// в соответствии  значения преременным
void write_outs(){
	// устанавливаем локальные выходы 
	y_01 = y01;	y_04 = y04;
	y_02 = y02;	y_05 = y05;
	y_03 = y03;	y_06 = y06;
}

//----------------------------------------
//  сохранение значения переменных  для  обработки
//  в  след.цикле  (установка, сброс)
void save_stat(){	
	x01_m = x01; x02_m = x02; x03_m = x03; x04_m = x04;    
	x05_m = x05; x06_m = x06; x07_m = x07; x08_m = x08;    
	y01_m = y01; y02_m = y02; y03_m = y03; y04_m = y04;    
	y05_m = y05; y06_m = y06;
	swd01_m = swd01; 
	swd02_m = swd02; 
	swd03_m = swd03; 
	swd04_m	= swd04; 
}

//----------------------------------------
//  изменение значения  секундных  и  милисекундных  таймеров 
//  (дискретность delay_time мсек)
void timers(){
	
	int i = delay_time;  	// время цикла в мсек
	int max1 = 60000;		// макс. значение  для мсек таймеров (60sec)
	int max2 = 36000;		// макс. значение для сек  таймеров  (10час)
	
	// timers,  1s
	if(t_sys < 1000) {
		t_sys = t_sys + i;
	} else {
		t_sys = 0;
		if(t101 < max2) { t101 = t101 + 1; }
		if(t102 < max2) { t102 = t102 + 1; }
		if(t103 < max2) { t103 = t103 + 1; }
		if(t104 < max2) { t104 = t104 + 1; }
		if(t105 < max2) { t105 = t105 + 1; }
	}
	
	// timers,  10ms
	if(t01 < max1) { t01 = t01 + i; }
	if(t02 < max1) { t02 = t02 + i; }
	if(t03 < max1) { t03 = t03 + i; }
	if(t04 < max1) { t04 = t04 + i; }
	if(t05 < max1) { t05 = t05 + i; }
}