#include "mbed.h"
#include "ihm_L476.h"
#include"math.h"
#define PI 3.14
//initialisation des objets
Serial pc(SERIAL_TX, SERIAL_RX);//permet la communication avec le terminal en liason serie
LCD_DISCO_L476VG lcd;

InterruptIn Up(PA_3,PullDown);
InterruptIn Down(PA_5,PullDown);
InterruptIn Right(PA_2,PullDown);
InterruptIn Left(PA_1,PullDown);
//initialisation des variables
int t=0;
double PER=1000;
double cadence=0.01;
double y1;
double y2;
double moyenne=0;
double somme=0;
double amplitude=2000;

bool flag=false;
bool flag2=false;
uint8_t tab[50];
uint8_t tab2[50];
Ticker tick_cadence,tick_moyenne;

void interrupt(void);
void val_moy(void);
void up(void);
void down(void);
void right(void);
void left(void);
int main()
{
    Up.rise(&up);
    Down.rise(&down);
    Right.rise(&right);
    Left.rise(&left);
    
    pc.baud(115200);
    //on attache le ticker a la fonction
    tick_cadence.attach(&interrupt, 0.01);
    tick_moyenne.attach(&val_moy, 1);
    while(1) {
        y1= (amplitude/1000)*sin(2.0*PI*(1.0/(PER/1000))*(t*cadence));
        y2= 2* fabs(y1);
        somme=somme+y2;
        if(flag2) {
            sprintf((char*)tab2,"%lf",amplitude);
            lcd.DisplayString(tab2);
            lcd.Clear();
            flag2=false;
        }
        if(flag) {
            sprintf((char*)tab2,"%lf",PER);
            lcd.DisplayString(tab2);
            lcd.Clear();
            flag=false;
        }
        sprintf((char*)tab,"%lf",moyenne);
        lcd.DisplayString(tab);
        pc.printf("$%lf %lf %lf;",y1,y2,moyenne);
    }
}
//fonction periodique qui incrémente t
void interrupt(void)
{
    t++;
}
//fonction periodique qui met a true le flag toute les 1 sec
void val_moy(void)
{
    moyenne=somme/256;
    somme=0;
}
void up(void)
{
    amplitude+=100;
    flag2=true;
}
void down(void)
{
    amplitude-=100;
    flag2=true;
}
void right(void)
{
    PER+=100;
    flag=true;
}
void left(void)
{
    PER-=100;
    flag=true;
}