#include "RTC_IUT.h"//bibliotheque de l'afficheur
#include "ihm_L476.h"//bibliotheque du chrono
DigitalIn BPC (PA_0,PullNone) ;  // bouton centre
DigitalIn BPL (PA_1,PullDown) ;//left
DigitalIn BPR(PA_2,PullDown) ;//right
DigitalIn BPU(PA_3,PullDown) ;//up
DigitalIn BPD (PA_5,PullDown) ;//down
DigitalOut LG (PE_8) ;  // led verte
DigitalOut LR (PB_2) ;  // led rouge

IHM_L476 ihm; // on chosis des noms qui nous serviront a appelé les fonctions dans les bibliotheque
Rtc rtc;
time_t heure_t,minute_t,seconde_t,mois_t,jour_t,annee_t;//on nomme nos valeur qui seront sous le format time_t
Serial pc(SERIAL_TX, SERIAL_RX);//permet la communication avec le terminal en liason serie

Timer tempo1,tempo2,tempo3,tempo4,tempsS;

// prototype et variables globales et constantes
static unsigned char Heure_t=23,Minute_t=59,Seconde_t = 50,Mois_t=01,Jour_t=01,Annee_t=18; // on defini l'heure/date avec une unsigned char

void automate(void);



int main()
{

    rtc.SetHour(Heure_t);
    rtc.SetMin(Minute_t);// On initialise l'heure , les minutes et les secondes au valeur demandes
    rtc.SetSec(Seconde_t);

    rtc.SetDay(Jour_t);
    rtc.SetMon(Mois_t);//on initialise la date au valeurs demandes
    rtc.SetYear(Annee_t);

    ihm.LCD_printf("CLK:OS");
    // début de l'application
    while(1) {
        wait(0.1);
        automate(); // ce qui se produit sur top de clock
    }
}


void automate(void)
{
    // définition d'un type énuméré permettant de manipuler l'état de l'automate
    // par son nom
    typedef enum {Menu=0,Horloge=1,Calendrier=2,inter=3,Alarme=4,bip=5,bip2=6,Minuteur=7} type_etat;
    type_etat etat_actuel = Menu ;   // déclaration état actuel init. à etat0
    static type_etat etat_futur = Menu;  // déclaration état futur

    int entreeb, entreeh, entreeg, entreed, entree;
    static int compteur=0;
    static int cptMenu=0;

    static int Heure_a=00,Minute_a =00,Seconde_a=00; // creation de mutliple variables
    static int cpt_a=0,choix_a=0;

    static int Heure_m=00,Minute_m =00,Seconde_m=00;
    static int cpt_m=0,choix_m=0;



    // gestion des entrees
    entree = BPC;// c'est le bouton centre
    entreeb = BPD;// c'est le bouton bas
    entreeh = BPU;//haut
    entreeg = BPL;//gauche
    entreed = BPR;//droit

    // gestion du diagramme de transition
    etat_actuel = etat_futur;   // mise à jour de l'état
    // calul de l'éat futur en fonction de l'état actuel et des entrées


    switch(etat_actuel) {
        //les différents états en accord avec le diagramme de transition

        case Menu :

            //a chaque que j'appui sur droite ou gauche j'ajoute ou je retire 1 au compteur ensuite le programme va regarder a combien est le compteur
            //et cela correspondera a un affichage du menu ensuite il reste appuyer pour changer d'etat correspondant
            if (cptMenu == 0) {
                ihm.LCD_printf("HORLOGE\r");
                if(entree) {
                    etat_futur = Horloge;
                }
            }
            if (cptMenu == 1) {
                ihm.LCD_printf("CALENDRIER\r");
                if(entree) {
                    etat_futur = Calendrier;
                }
            }
            if (cptMenu == 2) {
                ihm.LCD_printf("ALARME\r");
                if(entree) {
                    etat_futur = Alarme;
                }
            }
            if (cptMenu == 3) {
                ihm.LCD_printf("MINUTEUR\r");
                if(entree) {
                    etat_futur = Minuteur;
                }
            }


            if(entreed) {
                cptMenu++;
                LG=1;// j'allume verte pour l'incrementation
                LR=0;


            }
            if(entreeg) {
                cptMenu--;
                LG=0;// j'allume verte pour l'incrementation
                LR=1;

            }
            if(cptMenu > 3 or cptMenu<0) {//si le compteur depasse une certaine valeur il revient au depart
                cptMenu=0;
            }
            if (cpt_a == 1 && Heure_a == heure_t && Minute_a == minute_t && Seconde_a == seconde_t) {//alarme
                pc.printf("bip bip");
                etat_futur=bip;
            }
            if (cpt_m == 1 && Heure_m == 00 && Minute_m == 00 && Seconde_m == 00) {//alarme minuteur
                pc.printf("bip bip");
                etat_futur=bip2;
            }
            break;


        case Horloge :


            if(entreed) {
                rtc.SetMin(Minute_t++); // j'incremente Minute_t
                rtc.SetSec(00);//je met les secondes a zero a chaque changement d'etat
                heure_t = rtc.GetHour();
                rtc.SetMin(Minute_t);
                rtc.SetHour(Heure_t);
                LG=1;// j'allume verte pour l'incrementation
                LR=0;
            }//si j'appuie sur droite j'augmente les minute de 1

            if(entreeg) {
                rtc.SetMin(Minute_t--);//je diminue Minute_t
                heure_t = rtc.GetHour();
                rtc.SetMin(Minute_t);
                rtc.SetHour(Heure_t);
                rtc.SetSec(00);


                LG=0;// j'allume rouge pour la diminution
                LR=1;
            }//si j'appuie a gauche je diminue les minutes de

            if(entreeh) {
                rtc.SetHour(Heure_t++);//j'incremente Heure_t
                rtc.SetSec(00);
                jour_t=rtc.GetDay();
                minute_t = rtc.GetMin();
                rtc.SetMin(Minute_t);
                rtc.SetHour(Heure_t);

                LG=1;// j'allume verte pour l'incrementation
                LR=0;

            }//si j'appuie sur haut j'augmente les heures de 1

            else if(entreeb) {
                rtc.SetHour(Heure_t--);
                rtc.SetSec(00);
                jour_t=rtc.GetDay();
                minute_t = rtc.GetMin();
                rtc.SetHour(Heure_t);
                rtc.SetMin(Minute_t);

                LG=0;
                LR=1;// j'allume rouge pour la diminution
            }//si j'appuie en bas je diminue les heures de 1


            if(entree)etat_futur=inter;
            if (cpt_a == 1 && Heure_a == heure_t && Minute_a == minute_t && Seconde_a == seconde_t) {
                pc.printf("bip bip");
                etat_futur=bip;
            }
            if (cpt_m == 1 && Heure_m == 00 && Minute_m == 00 && Seconde_m == 00) {
                pc.printf("bip bip");
                etat_futur=bip2;
            }
            break;



        case Calendrier:
            rtc.SetDay(Jour_t);//j'incremente Jour_t


            rtc.SetMon(Mois_t);

            mois_t=rtc.GetMon();
            jour_t=rtc.GetDay();

            if(compteur==0) {
                ihm.BAR_set(1);
                if(entreeh) {
                    rtc.SetDay(Jour_t++);//j'incremente Jour_t


                    rtc.SetMon(Mois_t);

                    mois_t=rtc.GetMon();
                    jour_t=rtc.GetDay();

                    LG=1;// j'allume verte pour l'incrementation
                    LR=0;
                } else if (entreeb) {
                    rtc.SetDay(Jour_t--);
                    jour_t=rtc.GetDay();
                    rtc.SetMon(Mois_t);
                    mois_t=rtc.GetMon();

                    LG=0;
                    LR=1;
                }
            } else if(compteur==1) {
                ihm.BAR_set(2);
                if(entreeh) {
                    rtc.SetMon(Mois_t++);

                    mois_t=rtc.GetMon();
                    jour_t=rtc.GetDay();
                    rtc.SetDay(Jour_t);



                    LG=1;
                    LR=0;
                } else if (entreeb) {
                    rtc.SetMon(Mois_t--);

                    mois_t=rtc.GetMon();
                    rtc.SetDay(Jour_t);

                    jour_t=rtc.GetDay();


                    LG=0;
                    LR=1;
                }
            }//si j'appuie sur haut j'augmente les heures de 1
            /** else if(compteur==2) {
                 ihm.BAR_set(4);
                 if(entreeh) {
                     rtc.SetYear(Annee_t++);//j'incremente Heure_t

                     annee_t=rtc.GetYear();



                     jour_t=rtc.GetDay();



             mois_t=rtc.GetMon();
                     LG=1;// j'allume verte pour l'incrementation
                     LR=0;
                 }
                 if (entreeb) {
                     rtc.SetYear(Annee_t--);//j'incremente Heure_t

                     annee_t=rtc.GetYear();


                     jour_t=rtc.GetDay();



             mois_t=rtc.GetMon();
                     LG=0;// j'allume verte pour l'incrementation
                     LR=1;
                 }
             }
             **/
            //En fonction de l'appui sur droite ou gauche je change la valeur du compteur et certaine corresponde soit au jour , mois ou année
            if(entreed) {
                compteur++;

                LG=1;// j'allume verte pour l'incrementation
                LR=0;


            }
            if(entreeg) {
                compteur--;

                LG=0;
                LR=1;

            }




            if(compteur > 2 or compteur<0) {
                compteur=0;
            }
            if(entree)etat_futur=inter;
            if (cpt_a == 1 && Heure_a == heure_t && Minute_a == minute_t && Seconde_a == seconde_t) {
                pc.printf("bip bip");
                etat_futur=bip;
            }
            if (cpt_m == 1 && Heure_m == 00 && Minute_m == 00 && Seconde_m == 00) {
                pc.printf("bip bip");
                etat_futur=bip2;
            }

            break;
        case inter:
            if(entree)etat_futur=inter;
            if(!entree)etat_futur=Menu; // test pour avoir un ecran eteint quand on reste appuyé au retour au menu
            break;

        case Alarme:
            heure_t = rtc.GetHour();
            minute_t = rtc.GetMin();//J'utilise les valeurs qui ont été etablie avant et je les met dans des variables


            //pc.printf("%d\n",cpt_a);
            // en fonction de la valeur de choix_a on va selectionner soit les heure , minute ou seconde et avec la possibiliés de  les modifier
            if (entreed) {
                choix_a++;
            }
            if (choix_a == 0) {
                LG=1;
                LR=0;
                if(entreeh) {
                    Heure_a++;
                } else if(entreeb) {
                    Heure_a--;
                }
            }

            else if (choix_a == 1) {
                LG=0;
                LR=1;
                if(entreeh) {
                    Minute_a++;
                } else if(entreeb) {
                    Minute_a--;
                }
            } else if (choix_a == 2) {
                LG=0;
                LR=0;
                if(entreeh) {
                    Seconde_a++;
                } else if(entreeb) {
                    Seconde_a--;
                }
            }

            // en appuyant sur gauche on met l'alarme soit sur off ou on
            if (entreeg) {
                cpt_a++;
            }
            if (cpt_a==0) {
                //OFF
                ihm.BAR_set(1);

            }

            else if (cpt_a==1) {
                //ON
                ihm.BAR_set(2);

            }
            // si l'alarme est ON est que le temps voulu correspond au temps actuel l'alarme sonne
            if (cpt_a == 1 && Heure_a == heure_t && Minute_a == minute_t && Seconde_a == seconde_t) {
                pc.printf("bip bip");
                etat_futur=bip;
            }
            if (cpt_m == 1 && Heure_m == 00 && Minute_m == 00 && Seconde_m == 00) {
                pc.printf("bip bip");
                etat_futur=bip2;
            }


            // pour definir le temps
            if (Heure_a > 23 or Heure_a < 00) {
                Heure_a = 00;
            }
            if (Minute_a > 59 or Minute_a < 00) {
                Minute_a = 00;
            }
            if (Seconde_a > 59 or Seconde_a < 00) {
                Seconde_a = 00;
            }
            if (choix_a >2 or choix_a<0) {
                choix_a = 0;
            }
            if (cpt_a >1 or cpt_a<0) {
                cpt_a = 0;
            }

            if(entree)etat_futur=inter;
            break;
        // deux alarme
        case bip :
            if (entree) {
                cpt_a=0;
                etat_futur=Menu;
            }
            break;
        case bip2 :
            if (entree) {
                cpt_m=0;
                etat_futur=Menu;
            }
            break;
        case Minuteur :

            // meme fonctionnement que l'alarme ici on regle le temps souhaite et on le met sur on ce qui va faire que le décompte va commence
            if (entreed) {
                choix_m++;
            }
            if (choix_m == 0) {
                LG=1;
                LR=0;
                if(entreeh) {
                    Heure_m++;
                } else if(entreeb) {
                    Heure_m--;
                }
            }

            else if (choix_m == 1) {
                LG=0;
                LR=1;
                if(entreeh) {
                    Minute_m++;
                } else if(entreeb) {
                    Minute_m--;
                }
            } else if (choix_m == 2) {
                LG=0;
                LR=0;
                if(entreeh) {
                    Seconde_m++;
                } else if(entreeb) {
                    Seconde_m--;
                }
            }


            if (entreeg) {
                cpt_m++;
            }
            if (cpt_m==0) {
                //OFF
                ihm.BAR_set(1);

                tempsS.reset();

            }

            else if (cpt_m==1) {
                //ON
                ihm.BAR_set(2);

                tempsS.start();

            }
            // si le minuteur est sur on est que le decompte arrive a 0 alors l'alarme se declenche
            if (cpt_m == 1 && Heure_m == 00 && Minute_m == 00 && Seconde_m == 00) {
                pc.printf("bip bip");
                etat_futur=bip2;
            }
            if (cpt_a == 1 && Heure_a == heure_t && Minute_a == minute_t && Seconde_a == seconde_t) {
                pc.printf("bip bip");
                etat_futur=bip;
            }



            if (Heure_m > 23 or Heure_m < 00) {
                Heure_m = 00;
            }
            if (Minute_m > 59 or Minute_m < 00) {
                Minute_m = 00;
            }
            if (Seconde_m > 59 or Seconde_m < 00) {
                Seconde_m = 00;
            }
            if (choix_m >2 or choix_m<0) {
                choix_m = 0;
            }
            if (cpt_m >1 or cpt_m<0) {
                cpt_m = 0;
            }

            // partie ou le prog gere la gestion du decompte en fonction d'un chrono interne
            if(tempsS.read() >=1) {
                Seconde_m--;
                tempsS.reset();
            }
            if (cpt_m == 1 && Minute_m>00 && Seconde_m < 00) {
                Minute_m--;
                Seconde_m = 59;


            }
            if (cpt_m == 1 && Heure_m>00 && Minute_m == 00 && Seconde_m < 00 ) {
                Heure_m--;
                Minute_m = 59;
                Seconde_m = 59;



            }


            if(entree)etat_futur=inter;
            break;


    }
    // valeurs des  sorties en fonction de l'état actuel
    switch(etat_actuel) {


// a chaque etat je reprend l'information sur le temps pour l'avoir toujours a jour
        case Horloge :
            pc.printf("%02u:%02u:%02u\n",heure_t,minute_t,seconde_t);//debug
            pc.printf("%02u:%02u:%02u\n",Heure_a,Minute_a,Seconde_a);
            pc.printf("%d\n",cpt_a);
            ihm.BAR_set(0);
            heure_t = rtc.GetHour();
            minute_t = rtc.GetMin();//J'utilise les valeurs qui ont été etablie avant et je les met dans des variables
            seconde_t = rtc.GetSec();

            jour_t=rtc.GetDay();
            mois_t=rtc.GetMon();
            annee_t=rtc.GetYear();
            ihm.LCD_printf("%02u:%02u:%02u",heure_t,minute_t,seconde_t);
            LG=0;// je met les leds a 0 pour un effet de clignotement
            LR=0;
            break;

        case Calendrier:
            pc.printf("%02u:%02u:%02u\n",heure_t,minute_t,seconde_t);//debug
            pc.printf("%02u:%02u:%02u\n",Heure_a,Minute_a,Seconde_a);
            pc.printf("%d\n",cpt_a);

            jour_t=rtc.GetDay();
            mois_t=rtc.GetMon();
            annee_t=rtc.GetYear();

            heure_t = rtc.GetHour();
            minute_t = rtc.GetMin();//J'utilise les valeurs qui ont été etablie avant et je les met dans des variables
            seconde_t = rtc.GetSec();

            ihm.LCD_printf("%d:%d:%d",jour_t,mois_t);
            pc.printf("%d\n",annee_t);
            LG=0;// je met les leds a 0 pour un effet de clignotement
            LR=0;
            break;
        case Menu:
            pc.printf("%02u:%02u:%02u\n",heure_t,minute_t,seconde_t);
            pc.printf("%02u:%02u:%02u\n",Heure_a,Minute_a,Seconde_a);//debug
            pc.printf("%d\n",cpt_a);

            ihm.BAR_set(0);
            heure_t = rtc.GetHour();
            minute_t = rtc.GetMin();//J'utilise les valeurs qui ont été etablie avant et je les met dans des variables
            seconde_t = rtc.GetSec();

            jour_t=rtc.GetDay();
            mois_t=rtc.GetMon();
            annee_t=rtc.GetYear();
            break;
        case Alarme:
            pc.printf("%02u:%02u:%02u\n",heure_t,minute_t,seconde_t);//debug
            pc.printf("%02u:%02u:%02u\n",Heure_a,Minute_a,Seconde_a);
            pc.printf("%d\n",cpt_a);


            ihm.LCD_printf("%02u:%02u:%02u",Heure_a,Minute_a,Seconde_a);
            break;

        case inter:
            ihm.LCD_clear();
            break;
        case bip:
            pc.printf("%02u:%02u:%02u\n",heure_t,minute_t,seconde_t);//debug
            pc.printf("%02u:%02u:%02u\n",Heure_a,Minute_a,Seconde_a);
            LR=0;
            LG=0;
            tempo1.start();
            tempo2.start();

            //je cree un clignotement pour simuler ue alarme et je precise quelle alarme

            if(tempo1.read_ms()>500) {
                LR=!LR;
                ihm.LCD_printf("BIPALA");
                tempo1.reset();
            }
            if(tempo2.read_ms()>500) {
                LG=!LG;
                ihm.LCD_printf("BIPALA");
                tempo2.reset();
            }
            break;
        case bip2:
            pc.printf("%02u:%02u:%02u\n",heure_t,minute_t,seconde_t);
            pc.printf("%02u:%02u:%02u\n",Heure_a,Minute_a,Seconde_a);
            LR=0;
            LG=0;
            tempo3.start();
            tempo4.start();
            //je cree un clignotement pour simuler ue alarme et je precise quelle alarme

            if(tempo3.read_ms()>500) {
                LR=!LR;
                ihm.LCD_printf("BIPMIN");
                tempo3.reset();
            }
            if(tempo4.read_ms()>500) {
                LG=!LG;
                ihm.LCD_printf("BIPMIN");
                tempo4.reset();
            }
            break;
        case Minuteur :
            ihm.LCD_printf("%02u:%02u:%02u",Heure_m,Minute_m,Seconde_m);

            pc.printf("S=%02f\n\r",tempsS.read());

            break;


    }
}