//Uses x & y acceleration to simulate a bubble level
//on the application board LCD display
#include "mbed.h"
#include "MMA7660.h"
#include "C12832_lcd.h"
#include "USBMouse.h"
#include "controller.h"

USBMouse mouse;
 //On board LCD display
MMA7660 MMA(p28, p27); //I2C Accelerometer
DigitalOut connectionLed(LED1);//Accel OK LED
DigitalIn   center(p14);

int16_t a_inx;
int16_t a_iny;

int main()
{
    int menuOption = 1;
    int quit = 1;
    int flag = 1;
    lcd.cls(); //clear LCD screen
    if (MMA.testConnection())
        connectionLed = 1; //Accelerometer init OK
    while(quit){
        if(menuOption == 1 && flag == 1){
            lcd.printf("Jotstick <-     \n\r");
            lcd.printf("Pot           Use Joystick\n\r");
            lcd.printf("Accelometer        \n\r");
            flag = 0;
        }
        if(menuOption == 2 && flag == 1){
            lcd.printf("Jotstick        \n\r");
            lcd.printf("Pot <-        Use Joystick\n\r");
            lcd.printf("Accelometer         \n\r");
            flag = 0;
        }
        if(menuOption == 3 && flag == 1){
            lcd.printf("Jotstick        \n\r"); 
            lcd.printf("Pot           Use Joystick\n\r");
            lcd.printf("Accelometer <-       \n\r");
            flag = 0;
        }
        
        if(up == 1 && menuOption != 1){ menuOption--;flag = 1; wait(.3);}
        else if(down == 1 && menuOption != 3){ menuOption++;flag = 1; wait(.3); }
        if(center == 1){quit = 0;};
    }
    controller *control;
    lcd.cls();
    if(menuOption == 1){
        control = new joystickController();
        lcd.printf("Controlling With Joystick");
    }else if(menuOption == 2){
        control = new potController();
        lcd.printf("Controlling With Pots");    
    }
    else if(menuOption == 3){
        control = new accelController();
        lcd.printf("Controlling With Accelerometer");    
    }
    while(1) {
        control->moveCursor();
    }

}
