#include "mbed.h"
#include "MMA7660.h"
#include "C12832_lcd.h"
#include "USBMouse.h"

C12832_LCD lcd;
USBMouse mouseOne;
MMA7660 MMAOne(p28, p27);

DigitalIn   click(p14);
DigitalIn   left(p13);
DigitalIn   right(p16);
DigitalIn   up(p15);
DigitalIn   down(p12);

AnalogIn   potX(p19);
AnalogIn   potY(p20);

class controller{
public:
    virtual int calculateX(int x){ return x; }
    virtual int calculateY(int y){ return y; }
    virtual void leftClick(){
        if(click == 1){
            mouseOne.buttons(1,0,0);    
            wait(0.2);
        }
    }
    virtual void moveCursor() {lcd.printf("Test\n\r");}
protected:
    int x,y;
};
class accelController: public controller{
public:
    accelController(){
        x = 0;
        y = 0;
    }
    int calculateX(){ return (this->x + MMAOne.x() * 32.0)/2.0; }
    int calculateY(){ return (this->y - MMAOne.y() * 16.0)/2.0; }
    void moveCursor(){
        x = calculateX();
        y = calculateY();
        wait(.1); //time delay
        mouseOne.move((-x)*2, (-y)*2);
        leftClick();
    }
};
class joystickController: public controller{
public:
    joystickController(){
        x = 0;
        y = 0;
    }
    void calculateX(){
        if(left == 1){ this->x = (this->x - (25)) / 3; }        // move mouse left
        else if(right == 1){ this->x = (25) / 2; }        // move mouse right
        else{ this->x = 0; }                              // keeps mouse stationary
    }
    void calculateY(){
        
        if(up == 1){ this->y = (this->y - (25)) / 3; }          // move mouse down
        else if(down == 1){ this->y = (25) / 2; }         // move mouse up
        else{ this->y = 0; }                              // keeps mouse stationary
    }
    void moveCursor(){
        calculateX();
        calculateY();
        mouseOne.buttons(0,0,0);    
        mouseOne.move(x, y);
        leftClick();
        wait(0.001);
    }   
};
class potController: public controller{
    int16_t a_inx;
    int16_t a_iny;
public:
    potController(){
        x = 0;
        y = 0;
    }
    void calculateX(){
       a_inx = (int16_t)(potY.read() * 100.0);
       if(a_inx > 52){x = (x - (50 - a_inx)) / 3;}
        else if(a_inx < 47){x = (a_inx - 50) / 2;}
        else{x = 0;}
    }
    void calculateY(){
       a_iny = (int16_t)(potX.read() * 100.0);
       if(a_iny > 52 && a_iny != 99){ y = (y - (50 - a_iny)) / 3; }
        else if(a_iny < 47){ y = (a_iny - 50) / 2; }
        else{ y = 0; }
    }
    void moveCursor(){
        
        calculateX();
        calculateY();
        leftClick();
        mouseOne.move(x, y);
        wait(0.001);
    }
       
};