/* Copyright (c) <2012> <copyright J. Grelet>, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 /*
 * bitmsk.h
 */

#ifndef bitmsk_H
#define bitmsk_H

#include <string.h>

#define MAX_TACHES  32          // Maxi arbitraire
#define BITMSK_SIZE MAX_TACHES / 8
#define BITMSK_RIEN 0
typedef unsigned char BITMSK;

typedef enum          { ADD,
                        REM,
                        SETF,
                        SETB,
                        SETA,
                        IS
                      } TMODE;          // cf Win::seta()

// #define NOPID   -1    // DOS

#define NOPIDUNIX   -1
typedef int     PID;            // De NOPID a MAX_TACHES

#define BITMODE TMODE           // cf. video.h

class Bitmsk
{
    // Membres
private:
    BITMSK    bits[ BITMSK_SIZE ];

    // Methodes
public:
    bool     requete( BITMODE mode,PID pid );
    void     raz(     void );

    // Constructeurs
public:
    Bitmsk(  PID nb = 0,... );
    Bitmsk(  Bitmsk &modele );
};

/*****************************************************************************
 * Prototypes des fonctions d'interface                                      *
 *****************************************************************************/
BITMSK setmsk( BITMSK *bitmsk,BITMODE mode,BITMSK new_msk );

#endif
