/*****************************************************************************
 * bitmsk.c :                                                                *
 *                                                                           *
 *  first version       B. Buisson  july 1994                                *
 *  Ver UNIX            J. Grelet   july 1997                                *
 *  updated for ARM     J. Grelet   mai  2013                                *
 *                                                                           *
 *****************************************************************************/
#define DEBUG
#undef  DEBUG

// systeme
#include <stdarg.h>        // cf. va_list

// bitmsk
#define _BITMSK
#include <bitmsk.h>
#undef  _BITMSK

/*****************************************************************************
 *****************************************************************************/
BITMSK setmsk( BITMSK *bitmsk,BITMODE mode,BITMSK new_msk )
{
 switch( mode ) {
   case IS   : return( ( *bitmsk & new_msk ) ? new_msk : BITMSK_RIEN );
   case ADD  : *bitmsk |=  new_msk;
               break;
   case REM  : *bitmsk &= ~new_msk;
               break;
   case SETA : *bitmsk = new_msk;
               break;
   default:
               break;
 }
 return( *bitmsk );
}

/*****************************************************************************
 * classe Bitmsk                                                             *
 *****************************************************************************/

/*****************************************************************************
 *****************************************************************************/
void Bitmsk::raz( void )
{
 memset( bits,'\0',BITMSK_SIZE * sizeof( *bits ) );
}

/*****************************************************************************
 *****************************************************************************/
bool Bitmsk::requete( TMODE mode,PID pid )
{
 BITMSK msk;
 PID    num;

 if( !bits || pid < 0 ) return( BITMSK_RIEN );
 for( num = 0; pid > 7; num++, pid -= 8 );
 if( num > BITMSK_SIZE ) return( BITMSK_RIEN );
 msk = ( 1 << pid );
 switch( mode ) {
   case IS   : return( ( bits[ num ] & msk ) ? true : false );
   case REM  : bits[ num ] &= ~msk;
               break;
   case SETA : raz();            // pas de break
   case ADD  : bits[ num ] |=  msk;
               break;
   default:
               break;
 }
 for( num = 0; num < BITMSK_SIZE; num++ )
   if( bits[ num ] != BITMSK_RIEN ) return( true );
 return( false );
}

/*****************************************************************************
 *****************************************************************************/
Bitmsk::Bitmsk( PID nb /*= 0*/,... )
{
 raz();
 if( nb > 0 ) {
   va_list lbits;

   va_start( lbits,nb );
   while( nb-- > 0 )
     requete( ADD,va_arg( lbits,PID ) );
   va_end( lbits );
 }
}

/*****************************************************************************
 *****************************************************************************/
Bitmsk::Bitmsk( Bitmsk &modele )
{
 memcpy( bits,modele.bits,BITMSK_SIZE * sizeof( *bits ) );
}

