/* Copyright (c) <2012> <copyright J. Grelet>, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 // util.cpp

#include <string.h>
//#include <sys/types.h>
#include <time.h>
#include <math.h>
#include <ctype.h>
#include "util.h"


#define COMPACT 0   /* Supprime les blancs a la lecture du descripteur   */
#define CONT_CHAR '\\'  /* Caractere de continuation au milieu d'un champs   */
#define TOKEN_SIZE 240      // Taille maxi d'un element du descripteur


/*****************************************************************************
 Convertit la position exprimee en degres/minutes en degres decimaux
 lat = -1328.837 -> -13.4806
 *****************************************************************************/
double convert_position( double data )
{
    double integer;
    double dec;

    dec = (double)( modf( data / 100.0 , &integer ) );
    dec /= 0.60;

    data = ( (double)( integer ) + dec ) * 100000.0;
    return( rint( data ) / 100000.0 );
}

/*****************************************************************************
 Convertit le temps date/heure en jour julien decimal
 *****************************************************************************/
double temps( unsigned jour_julien, double heure_decimal )
{
    double heure,
           minute,
           seconde,
           dec;

    dec = modf( heure_decimal / 100.0 , &heure );
    seconde = ( modf( dec * 100.0 , &minute ) );
    return( (double)jour_julien + ( ( (heure * 3600.0) + (minute * 60.0 ) + seconde) / 86400.0 ) );
}


/*****************************************************************************
 *****************************************************************************/
STRING *gen_str( unsigned taille /*= 80*/ )
{
    static char    liste_str[ MAX_CHAR_POOL ];
    static STRING *courant                    = (STRING *) &liste_str;
    STRING        *retour;

    ++taille;              // Pour le \0 en plus
    if( *courant + taille >= liste_str + MAX_CHAR_POOL ) {
        courant = (STRING *) &liste_str;
    }
    retour  = courant;
    memset( *retour,'\0',taille );     // Initialise la zone avec \0
    courant = (STRING *) ( (char *) courant + taille );    // Bon deplacement
    return( retour );
}
