/* Copyright (c) <2012> <copyright J. Grelet>, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/*
* statis.h
*/

#include "bitmsk.h"
#include "ring.h"

#define FLOAT_ERREUR 1.e36  // valeur en cas d'erreur de mesure

#ifndef statis_H
#define statis_H

class Mediane_item
{
    // Membres
public:
    float     valeur;
    int       indice;

    // Methodes
public:
    void      raz( void );

    // Constructeur
public:
    Mediane_item( void );
};

class Mediane
{
    // Methodes virtuelles
public:
    virtual Mediane_item &mediane( Mediane_item list[],unsigned n_elem );
};

class Mediane_circ : public Mediane
{
    // Membres
private:
    float         maxi,
                  moitie;

    // Methodes virtuelles
public:
    virtual Mediane_item &mediane(      Mediane_item list[],unsigned n_elem );

    // Constructeurs
public:
    Mediane_circ( float a_maxi );
};

enum STAT_CALCULS { STAT_MED_NORM   = 0x01,
                    STAT_MED_CIRC   = 0x02,
                    STAT_MED        = 0x03,
                    STAT_MOYENNE    = 0x04,
                    STAT_ECART_TYPE = 0x08
                  };

class Statis_data
{
    // Membres
private:
    bool          stat_on;
    BITMSK        calculs;
    Ring<float>  ring;
    Mediane_item *mediane_liste;
    Mediane      *mediane_methode;

public:
    Mediane_item  med;
    float         moy,
                  ecart,
                  instant,
                  borne_inf,
                  borne_sup;
    unsigned      n_elem;

    // Methodes
private:
    Mediane_item *cons_liste(  void );
    bool          verifie(     float &val );
    bool          mediane(     void );
    bool          moyenne(     void );
    bool          ecart_type(  void );

public:
    float        put(        float val );
    unsigned     calcule(     void );

    // Constructeurs
public:
    Statis_data( BITMSK calc,unsigned taille,
                 float b_inf = 0,float b_sup = 0 );
    ~Statis_data();
};

#endif
