/*-------------------------------------------------------------------------*/
/*                       tickerEvent  class                                */
/*-------------------------------------------------------------------------*/
/*                    Ni-MH charger project US191 IRD                      */
/*-------------------------------------------------------------------------*/
/*                       Nov 2012 | J Grelet                               */
/*-------------------------------------------------------------------------*/


#include "tickerEvent.h"

// constructor
// _pin(pin) means pass pin to the DigitalOut constructor
tickerEvent::tickerEvent(PinName pin, float delay) : _pin(pin)
{
    // default the output to 0
    _pin = 0;

    // Attach a function to be called by the Ticker, specifiying the interval delay in seconds.
    _ticker.attach(this, &tickerEvent::toDo, delay);
}

// destructor
tickerEvent::~tickerEvent()
{
}

// toDo method call by ticker
void tickerEvent::toDo(void)
{
    _pin = !_pin;
}

// return state
int tickerEvent::read(void)
{
    return _pin;
}