/*-------------------------------------------------------------------------*/
/*                       temperatureSensor  class                          */
/*-------------------------------------------------------------------------*/
/*                    Ni-MH charger project US191 IRD                      */
/*-------------------------------------------------------------------------*/
/*                       Nov 2012 | J Grelet                               */
/*-------------------------------------------------------------------------*/

#include "temperatureSensor.h"


// constructor
// _pin(pin) means pass pin to the AnalogIn constructor
temperatureSensor::temperatureSensor(PinName pin, float delay, float scaleTemp, BITMSK calculs, size_t size) :
    _pin(pin), _filter(calculs, size)
{

    _scaleTemp  = scaleTemp;
    _scaleFactor = 100;

    // Attach a function to be called by the Ticker, specifiying the interval delay in seconds.
    _ticker.attach(this, &temperatureSensor::toDo, delay);
}

// destructor
temperatureSensor::~temperatureSensor()
{
}

// toDo method call by ticker
// remove 3.3
// read AnalogIn voltage and convert into temperature
void temperatureSensor::toDo(void)
{
    _temperature = (_pin * 3.3 * _scaleFactor) - _scaleTemp;
    _filter.put( _temperature );
}

void temperatureSensor::calcule(void)
{
    _n_elem = _filter.calcule();
}

// return temperature measurement
// add filtering with media and ring buffer
float temperatureSensor::mediane(void)
{
    return _filter.med.valeur;
}

int temperatureSensor::indice(void)
{
    return _filter.med.indice;
}

unsigned temperatureSensor::n_element(void)
{
    return _n_elem;
}

float temperatureSensor::moyenne(void)
{
    return _filter.moy;
}


float temperatureSensor::ecart_type(void)
{
    return _filter.ecart;
}