#include "mbed.h"
#include "util.h"
#include "bitmsk.h"
#include "ring.h"
#include "tickerEvent.h"
#include "temperatureSensor.h"

Serial pc(USBTX, USBRX);

// Ticker initialisation
tickerEvent led1(LED1, 1);
Ticker disp;

float DISP_RATE   = 2;

float LM35_FREQ   = 10;
int   LM35_SIZE   = 19;

float LM335_FREQ  = 10;
int   LM335_SIZE  = 19;

// temperature sensor intialisation
/* Statistical declaration is a bitmsk of type:
 STAT_MED_NORM   -> mediane
 STAT_MED_CIRC   -> circular mediane
 STAT_MED        -> mediane
 STAT_MOYENNE    -> average
 STAT_ECART_TYPE -> standard deviation
 */
// LM35 temperature sensor out is connected to Mbed pin : p19
temperatureSensor LM35(p19, 1.0/LM35_FREQ, 0, STAT_MED_NORM | STAT_MED | STAT_MOYENNE | STAT_ECART_TYPE, LM35_SIZE);

// LM335 temperature sensor out is connected to Mbed pin : p20
temperatureSensor LM335(p20, 1.0/LM35_SIZE, 273.15, STAT_MED_NORM | STAT_MED | STAT_MOYENNE | STAT_ECART_TYPE , LM335_SIZE);

// function call by Ticker objet disp
void display()
{
    LM35.calcule();
    pc.printf("LM35:  %+4.4g C, %+4.4g C, std: %03.1g ind: %2d (%3u)\t",
              LM35.mediane(), LM35.moyenne(), LM35.ecart_type(), LM35.indice(), LM35.n_element());
    LM335.calcule();              
    pc.printf("LM335: %+4.4g C, %+4.4g C, std: %03.1g ind: %2d (%3u)\r",
              LM335.mediane(), LM335.moyenne(), LM335.ecart_type(), LM335.indice(), LM335.n_element());
}

// main program
int main()
{
    disp.attach( &display, DISP_RATE );

    pc.printf("\r\nStarting at %5.0f Hz ...\r\n", LM35_FREQ);
    pc.printf("Sensor: mediane, average, std-dev, indice\r\n");

    while (1) {

    }

}
