/*-------------------------------------------------------------------------*/
/*                 TemperatureSensor header class declaration              */
/*-------------------------------------------------------------------------*/
/*                    Ni-MH charger project US191 IRD                      */
/*-------------------------------------------------------------------------*/
/*                       Nov 2012 | J Grelet                               */
/*-------------------------------------------------------------------------*/

#ifndef temperatureSensor_H
#define temperatureSensor_H

#include <iostream>
#include "mbed.h"       // include mbed library  
#include "statis.h"


class temperatureSensor
{
private:
    Ticker      _ticker;
    AnalogIn    _pin;
    Statis_data _filter;
    float       _scaleTemp;
    float       _scaleFactor;
    float       _temperature;
    unsigned    _n_elem;


public:
    // Constructor
    temperatureSensor(PinName pin, float delay, float scale, BITMSK calculs, size_t size);

    // Destructor
    virtual ~temperatureSensor();

    // method that give the temperature measure of the sensor
    void     calcule(void);
    float    mediane(void);
    float    moyenne(void);
    int      indice(void);
    float    ecart_type(void);
    unsigned n_element(void);

    // A shorthand for read()
    //operator float() {
    //    return read();
    //}

private:
    // method that convert voltage measure in temperature
    void toDo(void);
};

#endif // temperatureSensor_H

