#include "mbed.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "rtos.h"
#include "wave_player.h"
#include <mpr121.h>
#include "tetris.h"


Serial pc(USBTX, USBRX);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card

AnalogOut DACout(p18);
wave_player waver(&DACout);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Mutex brd_mutex;
Mutex input_mutex;
Ticker gravity;

// Create the interrupt receiver object on pin 12
InterruptIn interrupt(p12);
// Setup the i2c bus on pins 9 and 10
I2C i2c(p9, p10);
// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);
    
Board brd;
int gotInput = 0;
int gotDown = 0;

void playTheme(void const *args){
    FILE *wave_file;
    while(1){
        wave_file=fopen("/sd/TetrisA.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
    }
}    
    
    
    // Key hit/release interrupt routine
void keyPress() {
  int key_code=0;
  int i=0;
  int value=mpr121.read(0x00);
  value +=mpr121.read(0x01)<<8;
  gotInput = 1;
  input_mutex.lock();
  if(value == (0x01 << 4)){
      //Move the active block left
      brd_mutex.lock();
      brd.nextBlock.movL();
      brd_mutex.unlock();
      }else if(value == (0x01 << 6)){
        brd_mutex.lock();
        brd.nextBlock.movR();
        brd_mutex.unlock();
      } else if(value == (0x01 << 9)){
        brd_mutex.lock();
        brd.nextBlock.movD();
        brd_mutex.unlock();
        gotDown = 1;
        } else if(value == (0x01 << 0)){
        brd_mutex.lock();
        brd.nextBlock.movF();
        brd_mutex.unlock();
        } else if(value == (0x01 << 2)){
        brd_mutex.lock();
        brd.nextBlock.movB();
        brd_mutex.unlock();
        } else if(value == (0x01 << 5)){
        brd_mutex.lock();
        brd.nextBlock.rotY();
        brd_mutex.unlock();
        } else if(value == (0x01 << 11)){
        brd_mutex.lock();
        brd.nextBlock.rotZ();
        brd_mutex.unlock();
        } else if(value == (0x01 << 3)){
        brd_mutex.lock();
        brd.nextBlock.rotX();
        brd_mutex.unlock();
        }else if(value == (0x01 << 8)){
        brd_mutex.lock();
        brd.blockFall();
        brd_mutex.unlock();
        }
        else gotInput = 0;
      
}

void gravTick(){
    brd_mutex.lock();
    brd.nextBlock.movD();
    brd_mutex.unlock();
    gotDown = 1;
    gotInput = 1;
}

int main() {
    printf("Starting main...\n");
    printf("Setting up interrupts...\n");
    interrupt.fall(&keyPress);
    interrupt.mode(PullUp);
    printf("Setting up audio thread...\n");
    Thread tetrisA(playTheme);
    tetrisA.set_priority(osPriorityNormal);
    printf("Setting up the ticker timer");
    gravity.attach(&gravTick, 4.0);
    printf("Setting up LCD thread...\n");
    brd_mutex.lock();
    brd.drawGrid();
    brd_mutex.unlock();

    while(1) {
        if (gotInput){
            if(gotDown){
                if(!brd.check()){
                    brd.setBlock();
                    brd.getNewBlock();
                }
            }
            brd.checkAndUpdate();
            gotDown = 0;
            gotInput = 0;
            input_mutex.unlock();
        }
        Thread::wait(20);

    }
}
