#ifndef TETRIS_H
#define TETRIS_H

#define DIMX 8 //10
#define DIMY 4
#define DIMZ 22
#define DIMLOSE 18
#define LINE0 0x000F000F000F000FULL
#define LINE1 0x00F000F000F000F0ULL
#define LINE2 0x0F000F000F000F00ULL
#define LINE3 0xF000F000F000F000ULL
#define FACE0 0x000000000000FFFFULL
#define FACE1 0x00000000FFFF0000ULL
#define FACE2 0x0000FFFF00000000ULL
#define FACE3 0xFFFF000000000000ULL
#define SET_SIZE 7

static unsigned long long block_list[] = {0x0033003300330033ULL, 0x000000000000000FULL, 0x0000000000000017ULL,
                                     0x000000000000008EULL, 0x00000000000000C6ULL, 0x0000000000000036ULL,
                                     0X000100010001111FULL};
                                     //51, 15, 23, 142, 198, 54, 281479271747871

class Block {
    public:
        unsigned long long block;
        int offset;
        int height;
        
        Block();
        Block(short);
        Block(short, short, short);
        unsigned long long getFace(int);
        unsigned long long getLine(int);
        unsigned long long getFaceLine(int,int);
        void rotY();
        void rotZ();
        void rotX();
        void movR();
        void movL();
        void movB();
        void movF();
        void movU();
        void movD();       
};

class Board{
    
    public:
        Board();
        void setBlock();
        void setBlockFaceLine(int,int);
        void setBlockFaceLineVal(int,int,unsigned long long);
        int check();
        int checkFaceLine(int,int);
        void updateBlock();
        void checkAndUpdate();
        void drawGrid();
        void drawBlock(Block);
        void eraseBlock(Block);
        unsigned long long line[DIMZ+4];
        Block activeBlock;
        Block nextBlock;
        void drawPix(int,int,int);
        void erasePix(int,int,int);
        void getNewBlock();
        unsigned long long getFaceLine(int,int);
        void checkForClear(int);
        void clearLine(int);
        int score;
        void redrawBoardLine(int, int, unsigned long long);
        void drawScore();
        void blockFall();
        int lost;
        void checkLose();
};

unsigned long long shift(unsigned long long,int);



#endif