#include "mbed.h"
#include "SDFileSystem.h"
#define PYLD_ADD 0x48
#define BAE_ADD 0x20
/************************Include the required Header files for the code *******************************/
//#include "mbed.h"
#include "string.h"

#include "rtos.h"
#include "pin_config.h"
//const int addr = 0x20;                     //slave address 
I2C master (PIN72,PIN71);                      //configure pins p27,p28 as I2C master
Serial pc (USBTX,USBRX);
DigitalOut interrupt(PIN4);
InterruptIn data_ready(PIN39);
InterruptIn data_ready_pyld(PIN40);           //to be changed for i2c comm. between pyld and bae
void store_data(char*);

int reset;
Timer t;
Timer t1;
Timer t2;
Timer t3;

typedef struct
{
    char data;          // To avoid dynamic memory allocation
    int length;
}i2c_data;

//Mail<i2c_data,16> i2c_data_receive;
Mail<i2c_data,16> i2c_data_send;

Thread * ptr_t_i2c;
int switchflag = -1;                                    // to switch between BAE and PYLD
void FUNC_I2C_MASTER_FSLAVE(char * data,int length)
{
    
            
            bool ack0 =true; 
            
            interrupt = 1;
            t1.start();
            //wait_ms(20);
            if(switchflag == 0)
            ack0 =  master.read(BAE_ADD|1,data,length);
            else if (switchflag==1)
            ack0 =  master.read(PYLD_ADD|1,data,length);
            t1.stop();
            store_data(data); 
            
            if(!ack0)
            {
                    printf("\n master has read %s from slave\n\r",data);
                    
            }
                //master.stop();
            printf("\n%d\n\r",t1.read_us());
            t1.reset();
            
            interrupt=0;
            switchflag = -1;
}

typedef struct {
    char Voltage[9];
    char Current[5];
    char Temperature[2];
    char PanelTemperature[3];//read by the 4 thermistors on solar panels
    char BatteryTemperature;    //to be populated   
    char faultpoll;             //polled faults
    char faultir;               //interrupted faults
    char power_mode;            //power modes
    char AngularSpeed[3];
    char Bnewvalue[3];
    
    //float magnetometer,gyro=>to be addes
} hk_data;
hk_data decode_data;

/*void TC_DECODE(char *data_hk)                  //getting the structure back from hk data sent by bae
{
    for(int i=0;i<=7;i++)
    {
    decode_data.Voltage[i] = data_hk[i];
    decode_data.Voltage[8] = '\0';
    }
    for(int i=0;i<=3;i++)
    {
    decode_data.Current[i] = data_hk[8+i];
    decode_data.Current[4] = '\0';
    }
    decode_data.Temperature[0] = data_hk[12];
    decode_data.Temperature[1] = '\0'; 
    for(int i=0;i<=1;i++)
    {
    decode_data.PanelTemperature[i] = data_hk[13+i];
    decode_data.PanelTemperature[2] = '\0';
    }
    decode_data.BatteryTemperature = data_hk[15];
    decode_data.faultpoll = data_hk[16];
    decode_data.faultir = data_hk[17];
    decode_data.power_mode = data_hk[18];
    for(int i=0;i<=1;i++)
    {
    decode_data.AngularSpeed[i] = data_hk[19+i];
    decode_data.AngularSpeed[2] = '\0';
    }
    for(int i=0;i<=1;i++)
    {
    decode_data.Bnewvalue[i] = data_hk[21+i];
    decode_data.Bnewvalue[2] = '\0';
    }
    printf("\n voltage %s\n\r",decode_data.Voltage);
    printf("\n current  %s\n\r",decode_data.Current);
    printf("\n faultpoll %c\n\r",decode_data.faultpoll);
}*/

            
void T_I2C_MASTER_FSLAVE(void const *args)
{
    char data_receive[25];
    while(1)
    {
        Thread::signal_wait(0x1);
        
        
        FUNC_I2C_MASTER_FSLAVE(data_receive,25);
        /*i2c_data * i2c_data_r = i2c_data_receive.alloc();
        strcpy(i2c_data_r->data , data_receive);
        i2c_data_r->length = 25;
        i2c_data_receive.put(i2c_data_r);*/
        printf("\n Data received from slave is %s\n\r",data_receive);
        //TC_DECODE(data_receive);
    }
}

void FUNC_INT_BAE()
{

   switchflag = 0;  
   ptr_t_i2c->signal_set(0x1);
     
}

void FUNC_INT_PYLD()
{

   switchflag = 1;  
   ptr_t_i2c->signal_set(0x1);
     
}

char writedata;
bool write2slave;
bool master_status_write;
void FUNC_MASTER_WRITE()
{   //wait(1);
    write2slave=true;
   
    
     
    char data = pc.getc();
    interrupt = 1;
    t.start();
    t3.start();
    wait_ms(20);
    i2c_data * i2c_data_s = i2c_data_send.alloc();
    i2c_data_s->data = data;
    i2c_data_s->length = 1;
    i2c_data_send.put(i2c_data_s); 
    master_status_write = true;
    
   // interrupt = 1; 

    osEvent evt = i2c_data_send.get();
            if (evt.status == osEventMail) 
            {
                i2c_data *i2c_data_s = (i2c_data*)evt.value.p;
                writedata = i2c_data_s -> data;
                t.stop();
                //t3.start();
                if(data%2)         
                master_status_write = (bool) master.write(BAE_ADD|0x00,&writedata,1);
                else
                master_status_write = (bool) master.write(PYLD_ADD|0x00,&writedata,1);
                t3.stop();
                if(master_status_write==0)
                    {
                    printf("master has written %c to slave\n\r",writedata);
                    write2slave=false;
                    }
                i2c_data_send.free(i2c_data_s);
                printf("\n%d\n",t.read_us());
                t.reset();
                printf("\n%d\n",t3.read_us());
                t3.reset();
            }
    interrupt = 0;
}









/********************************** Function Prototypes declaration ***********************************/
int FUNC_CDMS_hex2int(int);                     // Need to convert the RTC time values to integers
void FUNC_CDMS_Gettime(void);                   // Function to get the time values from RTC registers 
void FUNC_CDMS_init_values(void);               // Function to initialize the registers in the RTC


/***************** Configure the SPI1 of the CDMS uc as the data bus for the RTC***********************/
SPI spi(PTE1,PTE3, PTE2);                       // mosi, miso, sclk
DigitalOut cs(PTE29);                           // PTE29 is used for chip select

char ch;
SDFileSystem sd(PTE1, PTE3, PTE2, PTE22, "sd"); // the pinout on the mbed Cool Components workshop board

char time_stamp[15];

/***********************Initialization function of the RTC********************************************/ 
void FUNC_CDMS_init_values(void)
{
    cs=0;
    spi.format(8,3);                            // Set the data bit with to be of 8 bits, 
                                                // data tx mode is 3 
    spi.frequency(1000000);                     // Set Data rate to be 1 MHz
    
    cs = 0;                                     // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x80);                            // Send the address of the Seconds register 0x80
    spi.write(0x00);                            // Set seconds value to 0
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x81);                            // Send the address of the Minutes register 0x81
    spi.write(0x00);                            // Set minutes value to 0
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x82);                            // Send the address of the Hours register 0x82
    spi.write(0x00);                            // Set hours value to 0
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x83);                            // Send the address of the Day register 0x83
    spi.write(0x01);                            // Set the day to 01
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x84);                            // Send the address of the date register 0x84
    spi.write(0x01);                            // Set date of the month to 01
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x85);                            // Send the address of the Month register 0x80
    spi.write(0x01);                            // Set month to 01
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x86);                            // Send the address of the year register 0x80
    spi.write(0x00);                            // Set year to 00(2000)
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
}// End of INIT Function


/*********************************Function to read the RTC registers*********************************/   
void FUNC_CDMS_Gettime()
{

    spi.format(8,3);                            // Set the data bit with to be of 8 bits, 
                                                // data tx mode is 3 
    spi.frequency(1000000);                     // Set Data rate to be 1 MHz
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x00);                            // Sending address of seconds register
    int seconds = spi.write(0x00);              // Read the value by sending dummy byte
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x01);                            // Sending address of Minutes register
    int minutes =spi.write(0x01);               // Read the value by sending dummy byte
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x02);                            // Sending address of hours register
    int hours =spi.write(0x01);                 // Read the value by sending dummy byte
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x03);                            // Sending address of day register
    int day =spi.write(0x01);                   // Read the value by sending dummy byte
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x04);                            // Sending address of date register
    int date =spi.write(0x01);                  // Read the value by sending dummy byte
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x05);                            // Sending address of month register
    int month =spi.write(0x01);                 // Read the value by sending dummy byte
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x06);                            // Sending address of year register
    int year =spi.write(0x01);                  // Read the value by sending dummy byte
    cs = 1;                                     // Set chip select pin to be 1: DeActivate RTC chip
    
    // RTC sends in BCD format.. SO we convert the values generated by RTC to integers
    year = FUNC_CDMS_hex2int(year);             
    month = FUNC_CDMS_hex2int(month);
    date = FUNC_CDMS_hex2int(date);
    day = FUNC_CDMS_hex2int(day);
    hours = FUNC_CDMS_hex2int(hours);
    minutes = FUNC_CDMS_hex2int(minutes);
    seconds = FUNC_CDMS_hex2int(seconds);
    
    // Print the obtained Time stamp
    //printf("The time is :%d %d %d %d %d %d %d \n\r",seconds,minutes,hours,day,date,month,year);
    sprintf(time_stamp,"%02d%02d%02d%02d%02d%02d",year,month,date,hours,minutes,seconds);
    printf(" \n\r Received HK data from BAE");
    printf("\n HK_data stored in %s.txt",time_stamp);
    //puts(time_stamp);
    //printf(".txt");
}//End of Read Function

/**************************Function to convert Hex values to Int values*****************************/
int FUNC_CDMS_hex2int(int a)
{
a=(a/16)*10+(a%16); //function to convert hex type to int type
return a;
}// End of convert function


/******************************************END OF RTC CODE ****************************************/

//char count = 10;
void store_data(char *hkdata)
{
    FUNC_CDMS_Gettime();
    
    //char hk_data[25];
//    count++;
    //strcpy(hk_data,"hk_Data ");
    //strcat(hk_data,"!@@#");
//    hk_data[10] = count;
    //storedata(hk_data);
    mkdir("/sd/hk", 0777);
    char add[20];
    strcpy(add,"/sd/hk/");
    strcat(add,time_stamp);
    strcat(add,".txt");
    
    FILE *fp = fopen(add, "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    else
    {
       
    fprintf(fp, "%s ",hkdata);
    fclose(fp);
    printf("\n File stored in SD card\n");
    //printf("\n Reading from the file .... \n Data is %s\n",hk_data);
    
    }
}



//void create_file()
//{
    
    /*
    fprintf(fp, "Hello fun SD Card World!\n");
    fclose(fp); 
    
    fp = fopen("/sd/mydir/sdtest.txt", "r");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    //fprintf(fp, "Hello fun SD Card World!");
   // fprintf("The contents of %s file are :\n", "/sd/mydir/sdtest.txt");
    while( ( ch = fgetc(fp) ) != '\n' )
    {
      pc.printf("%c",ch);
      }
    //fprintf(fp);
    fclose(fp); 
 
    printf("Jai Mata Di..Goodbye World!\n");*/
//}
    
Ticker tx;

int main() 
{
    interrupt=0;
    ptr_t_i2c = new Thread(T_I2C_MASTER_FSLAVE); 
    master.frequency(100000);     
    printf("IITMSAT - CDMS\n");   
    data_ready.rise(&FUNC_INT_BAE);
    data_ready_pyld.rise(&FUNC_INT_PYLD);
    FUNC_CDMS_init_values();  
    //tx.attach(&store_data, 20);
    while(1)
    {
         FUNC_MASTER_WRITE();
    }
    
}
