#include "mbed.h"
#include "rtos.h"


// The trigger D4 is connected to Watchdog input and WD output is connected to interrupt button D3. The ISR thus evoked will trigger reset. Alternately, D3 can be connected to reset as well 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut trigger(D2);             //triggering watchdog
DigitalOut reset(D4);             //D4 is connected to uC reset
Serial pc(USBTX,USBRX);
InterruptIn button(D3);             //ISR initialize

void led2_thread(void const *args) {
    while (true) {
        led2 = !led2;
        Thread::wait(1000);
    }
}
 
void led1_thread(void const *args)
{
    while(true)
    {
        led1!=led1;
        Thread::wait(500);
    }
}

void WDT(void const *args)
{
    trigger=1;
    while(true)
    {
        trigger=!trigger;
        Thread::wait(5000);
    }
}
void fault()
{
    printf("\n Watchdog triggered... Saving parameters\n");
    reset=1;
}

int main() {
    button.rise(&fault);
    Thread thread1(led1_thread);
    Thread thread2(led2_thread);
    Thread watchdog(WDT);
    
    thread1.set_priority(osPriorityRealtime);
    thread2.set_priority(osPriorityHigh);
    watchdog.set_priority(osPriorityIdle);
    
    while (true) {
       Thread::wait(8000);
    }
}