#include "slave.h"
#include "HK.h"

extern SensorData Sensor;
I2CSlave slave(p28,p27);                       //configuring pins p27, p28 as I2Cslave
Serial screen (USBTX,USBRX);
void write_to_master(char send)                           //function to write data to master
        {
           int acknowledge; 
           acknowledge = slave.write(send);    //sending the byte to master
           if(acknowledge==1)
            {
              screen.printf(" acknowledge %d sent %x \n",acknowledge,send);
            }
        }
        
 void split(float data)                      //function to split data into 4 individual bytes and send to master
        {
            union convert
              {              
                   char byte[4];             //array containing individual bytes
                   float number;             //floating point number to be split into four bytes 
              }v;
              v.number=data; 
              write_to_master(v.byte[0]);
              write_to_master(v.byte[1]);
              write_to_master(v.byte[2]);
              write_to_master(v.byte[3]);
              screen.printf("sent %f\n",v.number);
        }



void FUNC_I2C_SLAVE_MAIN()
{
    wait(0.5);
    screen.printf("\nSlave entered\n");
    slave.address(0x20);                           //assigning slave address
    int Switch_Variable;
    int ReadAddressed=1;
    int WriteGeneral=3;
    int loopvariable1=1;
    int loopvariable2=0;
//initialising dummy sensor data                         
    
    while(loopvariable1)
    { 
//to read data from master       
    if(slave.receive()==WriteGeneral)                   //checking if slave is addressed to write
    {
      Switch_Variable=slave.read();                   //receiving data
      screen.printf("switch variable=%d\n",Switch_Variable);
      slave.stop();                          //reset slave to default receiving state
      loopvariable1=0;
//to interpret and write data to master       
      switch(Switch_Variable)
      {
      
       case 1: while(loopvariable2<30)
                {
                     if(slave.receive()==ReadAddressed)             //check if slave is addressed to read 
                   {
                      if(loopvariable2%3==0)
                          {
                          screen.printf("\nvoltage%d\n",loopvariable2/3);
                          split(Sensor.Voltage[loopvariable2/3]);
                          }
                      else if(loopvariable2%3==1)
                          {   
                          screen.printf("\ncurrent%d\n",loopvariable2/3);
                          split(Sensor.Current[loopvariable2/3]);
                          }
                      else if(loopvariable2%3==2)
                          {   
                          screen.printf("\ntemp%d\n",loopvariable2/3);
                          split(Sensor.Temperature[loopvariable2/3]);
                          }         
                      loopvariable2++;
                      slave.stop();      
                    }
                  }
                  break;
         case 2 : screen.printf(" telecommand 2\n");
                  break;         
                 
        }//switch case ends
   }   
}
   screen.printf("done");
}
