#include "rtos.h"
#include "HK.h"
#include "slave.h"

#define _bool uint8_t
#define intmax 65531                        //to allow smooth functioning of scheduler
Serial pc(USBTX,USBRX);
Timer t;
Thread *t_acs;
Thread *t_bea;
Thread *t_hk_acq;
Thread *t_acs_write2flash;
Thread *t_hk_write2cdms;
Thread *t_fault;



_bool beac_flag = 0;                                   //for detecting keypress from computer


/*----------------------------------------------------------------------------------------------------------------------------------------------------
  TASK 1:ACS
----------------------------------------------------------------------------------------------------------------------------------------------------*/
typedef struct
{
    int B;
    int omega;
}sens_data;

void FUNC_ACS_READDATA(sens_data * s);

Mail <sens_data,16> q_sensor;
/*----------------------------------------------------------------------------------------------------------------------------------------------------
  Definitions of functions for thread T_ACS_MAIN begin here
-----------------------------------------------------------------------------------------------------------------------------------------------------*/
//This function is called only once after the microcontroller is reset.
void FUNC_ACS_SENSORINIT()
{
    /*
    
    Lines of code to be given by Shruti and Jahnavi
    
    */
    pc.printf("\nInitializing the sensors.. \n");
}

void FUNC_ACS_READDATA(sens_data * s)
{
    /*
    
    Lines of code to be given by Shruti and Jahnavi
    
    Request sensor data
    
    */
    
    
    // this is the dummy data
    s->B=10;
    s->omega=100;
    
    pc.printf("\nReceived sensor data\n");
}

float FUNC_ACS_CONTROLALGO(sens_data * s)
{
    /*
    
    Lines of code to be given by Shruti and Jahnavi
    
    Control algorithm implementation
    
    */
    float m;
    s->B=10 *10;
    s->omega=100*10;
    m = 10;
    pc.printf("\nImplemented control algo\n");
    
    return(m);
}

void FUNC_ACS_PWMGEN(float m)
{
    float dc;
    dc = m*2;
    
    /*
    
    Lines of code to be given by Kumar and Karthik
    
    PWM implementation
    
    */
    
       
    pc.printf("\nGenerating pwm signal\n");
    
    
}

// Definitions of functions for thread T_ACS_MAIN end here
//----------------------------------------------------------------------------------------------------------------------------------------------------



// Definitions of functions for thread T_ACS_WRITE2FLASH starts here
//----------------------------------------------------------------------------------------------------------------------------------------------------

void FUNC_ACS_WRITE2FLASH(sens_data *s1)
{
    pc.printf("\nWritng ACS data to BAE flash\n");
    pc.printf("\nB      :%d",s1->B);
    pc.printf("\nomega  :%d",s1->omega);
    
}

// Definitions of functions for thread T_ACS_WRITE2FLASH end here
//----------------------------------------------------------------------------------------------------------------------------------------------------

// This is the main thread of ACS

void T_ACS_MAIN(void const * args)
{
    FUNC_ACS_SENSORINIT();                                                                      //Initializing sensors
    while(1)
    {
        
        float m;
        Thread::signal_wait(0x1);                                                           // waiting for signal from scheduler every ten seconds
        printf("\nACS   :%fn",t.read());
        printf("\nACS thread state is %d\n",t_acs->get_state());
        printf("\nBeacon thread state  :%d\n",t_bea->get_state());
        printf("\nACS_WRITE2FLASH thread state is %d\n",t_acs_write2flash->get_state());
        printf("\nHK_ACQ thread state is %d\n",t_hk_acq->get_state());
        printf("\nHK_WRITE2CDMS thread state is %d\n",t_hk_write2cdms->get_state());
        
        sens_data * s = q_sensor.alloc(); 
        
        FUNC_ACS_READDATA(s);
        q_sensor.put(s);
        m=FUNC_ACS_CONTROLALGO(s);
        FUNC_ACS_PWMGEN(m);
        pc.printf("\nTorque rods actuated\n");
        //Thread::wait(9899);
    }    
}

void T_ACS_WRITE2FLASH(void const * args)
{
        while(1)
        {
        
            osEvent evt=q_sensor.get();
            if(evt.status==osEventMail)
            {
                printf("\nACS thread status is %d\n",t_acs->get_state());
                printf("\nBeacon thread status  :%d\n",t_bea->get_state());
                printf("\nACS_WRITE2FLASH thread status is %d\n",t_acs_write2flash->get_state());
                printf("\nHK_ACQ thread status is %d\n",t_hk_acq->get_state());
                printf("\nHK_WRITE2CDMS thread status is %d\n",t_hk_write2cdms->get_state());   
                sens_data *s1 =(sens_data *)evt.value.p;// please see
                FUNC_ACS_WRITE2FLASH(s1);
                
                q_sensor.free(s1);
            }
        }
}

/*-----------------------------------------------------------------------------------------------------------------------------------------------------
  TASK 2 : HK
------------------------------------------------------------------------------------------------------------------------------------------------------*/

//Functions for the thread T_HK_ACQ begins here
//----------------------------------------------------------------------------------------------------------------------------------------------------
extern void FUNC_HK_MAIN();                                  // declared in HK.h

//Functions of the thread T_HK_SEND2CDMS starts here.
//----------------------------------------------------------------------------------------------------------------------------------------------------

extern void FUNC_I2C_SLAVE_MAIN();

//----------------------------------------------------------------------------------------------------------------------------------------------------
// Defintion of thread for sending data to CDMS
//----------------------------------------------------------------------------------------------------------------------------------------------------
void T_HK_SEND2CDMS(void const * args)
{
   
    while(1)
    {
        Thread::signal_wait(0x1);                                       // Waiting for signal from T_HK_ACQ
        printf("\nACS thread status is %d\n",t_acs->get_state());
        printf("\nBeacon thread status  :%d\n",t_bea->get_state());
        printf("\nACS_WRITE2FLASH thread status is %d\n",t_acs_write2flash->get_state());
        printf("\nHK_ACQ thread status is %d\n",t_hk_acq->get_state());
        printf("\nHK_WRITE2CDMS thread status is %d\n",t_hk_write2cdms->get_state());
        FUNC_I2C_SLAVE_MAIN();
    }
}

//----------------------------------------------------------------------------------------------------------------------------------------------
//Definition for the thread to collect HK data and store to flash memory
//----------------------------------------------------------------------------------------------------------------------------------------------

void T_HK_ACQ(void const *args)
{
    //t_hk_write2cdms = new Thread(T_HK_SEND2CDMS);
    //t_hk_write2cdms->set_priority(osPriorityLow);
    while(1)
    {
    
        Thread::signal_wait(0x1);                                   //Waiting for the signal from sceduler every 20 seconds
        printf("\n\nHK  :%f\n",t.read());
        printf("\nACS thread status is %d\n",t_acs->get_state());
        printf("\nBeacon thread status  :%d\n",t_bea->get_state());
        printf("\nACS_WRITE2FLASH thread status is %d\n",t_acs_write2flash->get_state());
        printf("\nHK_ACQ thread status is %d\n",t_hk_acq->get_state());
        printf("\nHK_WRITE2CDMS thread status is %d\n",t_hk_write2cdms->get_state());
        
        FUNC_HK_MAIN();
        t_hk_write2cdms->signal_set(0x1);
        //Thread::wait(19925);
    }
    
}

/*--------------------------------------------------------------------------------------------------------------------------------------------------
 TASK 3 : BEACON
-----------------------------------------------------------------------------------------------------------------------------------------------------*/


void FUNC_BEA_READBAERAM()
{
    /*
      Code to be given by Nathaniel
                                        */
    
    pc.printf("\nReading HK data from BAE RAM\n");
}

void FUNC_BEA_WRITE2SPI()
{
    /*
      Code to be given by Nathaniel
                                        */
    
    pc.printf("\nSending data through SPI\n");
}


void T_BEA(void const * args)
{
    extern SensorData Sensor;                                                           //Defined in HK.h
    while(1)
    {
    
        Thread::signal_wait(0x1);                                       //waiting for signal from scheduler every 30 seconds.
        pc.printf("\nBEACON     :%f\n",t.read());
        printf("\nACS thread status is %d\n",t_acs->get_state());
        printf("\nBeacon thread status  :%d\n",t_bea->get_state());
        printf("\nACS_WRITE2FLASH thread status is %d\n",t_acs_write2flash->get_state());
        printf("\nHK_ACQ thread status is %d\n",t_hk_acq->get_state());
        printf("\nHK_WRITE2CDMS thread status is %d\n",t_hk_write2cdms->get_state());    
        
        if(beac_flag==0)
        {
               
            FUNC_BEA_READBAERAM();
            FUNC_BEA_WRITE2SPI();
           // Thread::wait(30000);
        }
        else
        {
            //led=1;
            Thread::wait(60000);
            
            beac_flag=0;
            //myled=0;
        }
     }
    
}

void keypress(void const *args)
{
    
    while(1)
    {
        if(pc.getc()=='s')
        {
            pc.printf("\nTime of telecommand %f",t.read());
            beac_flag=1;
        }
    }
}
    

//---------------------------------------------------------------------------------------------------------------------------------------------------
//TASK 4 : FAULT MANAGEMENT
//---------------------------------------------------------------------------------------------------------------------------------------------------
//Dummy fault rectifier functions

Mail<int,16> faults;

void FUNC_FAULT_FUNCT1()
{
    pc.printf("\nFault 1 detected... \n");
}

void FUNC_FAULT_FUNCT2()
{
    pc.printf("\nFault 2 detected...\n");
}

void T_FAULT(void const *args)
{
    while(1)
    {
        osEvent evt = faults.get();
        if(evt.status==osEventMail)
        {
            int *fault_id= (int *)evt.value.p;
            switch(*fault_id)
            {
                case 1: FUNC_FAULT_FUNCT1();
                        break;
                case 2: FUNC_FAULT_FUNCT2();
                        break;
            }
            faults.free(fault_id);
        }
    }
}

//----------------------------------------------------------------------------------------------------------------------------------------------
//Scheduler
//----------------------------------------------------------------------------------------------------------------------------------------------
uint16_t schedcount=1;                                      //the value will reset to 0 after reaching 65535 which again will reset to 0. 
void scheduler(void const * args)
{
    if(schedcount == intmax+1)                              //the value is reset at this value so as to ensure smooth flow, 65532 and 0 are divisible by 3 and 2.
    {
        schedcount =0;
    }
    if(schedcount == 7)
    {
        int * fault_id = faults.alloc();
        *fault_id = 1;
        faults.put(fault_id);
    }
    t_acs->signal_set(0x1);
    
    if(schedcount%2==0)
       {
            //pc.printf("\nHK signal at %f",t.read());
            t_hk_acq->signal_set(0x1);
            
       } 
    if(schedcount%3==0)
        {
            //pc.printf("\nBeacon signal at %f",t.read());
            t_bea->signal_set(0x1);
            
        }
    schedcount++;
}

    
/*-----------------------------------------------------------------------------------------------------------------------------------------------------
  MAIN
-----------------------------------------------------------------------------------------------------------------------------------------------------*/
int main()
{
        t.start();
       
        t_acs = new Thread(T_ACS_MAIN);
        t_bea = new Thread(T_BEA);
        t_hk_acq = new Thread(T_HK_ACQ);
        t_acs_write2flash = new Thread(T_ACS_WRITE2FLASH);
        Thread key(keypress);
        t_fault = new Thread(T_FAULT); 
        t_hk_write2cdms = new Thread(T_HK_SEND2CDMS);           
  
        t_fault->set_priority(osPriorityRealtime);
        t_acs->set_priority(osPriorityHigh);
        t_bea->set_priority(osPriorityAboveNormal);
        t_hk_acq->set_priority(osPriorityNormal);
        t_acs_write2flash->set_priority(osPriorityBelowNormal);
        
        key.set_priority(osPriorityIdle);
        
                
        /*RtosTimer t_hk_timer(T_HK_ACQ,osTimerPeriodic);
        RtosTimer t_bea_timer(T_BEA,osTimerPeriodic);
        RtosTimer t_acs_timer(T_ACS_MAIN,osTimerPeriodic);
        
        t_hk_timer.start(10000);
        t_bea_timer.start(20000);
        t_acs_timer.start(30000);*/
        
        RtosTimer schedule(scheduler,osTimerPeriodic);
        schedule.start(10000);
        t_hk_write2cdms->set_priority(osPriorityLow);
        pc.printf("\n T_HK_SEND2CDMS priority is %d",t_hk_write2cdms->get_priority());
        pc.printf("\n T_ACS priority is %d",t_acs->get_priority());
        pc.printf("\n T_FAULTS priority is %d",t_fault->get_priority());
        
        while(1)
        {
            /*if(i%10==0)
                {
                    t_acs->signal_set(0x1);
                    pc.printf("Priority of t_hk_write2cdms is %d and t_acs_write2flash is %d",t_hk_write2cdms->get_priority(),t_acs_write2flash->get_priority());
                }
            if(i%20==0)
                t_hk_acq->signal_set(0x1);
            if(i%30==0)
                t_bea->signal_set(0x1);
            
            i++;*/
            Thread::wait(1000);
           
           // pc.printf("\n%f\n",t.read());
        }
}