#include "HK.h"
 
 MAX17048 master(A4,A5,100000);//object for battery gauge class--CHECK SDA,SCL LINES,FREQUENCY
 void FUNC_BATTERYGAUGE_INIT();
 
//GPIO pins used=> D2-D12, A0-A1

DigitalOut SelectLinesA[]={D2,D3,D4,D5};//to mux1=>voltage mux
DigitalOut SelectLinesB[]={PTB18,D7,PTB19};//to mux2=>current mux(differential mux)   Is this 3 or 4?
DigitalOut SelectLinesC[]={PTC0,PTC4,PTC6,PTC7};//to mux3=>temp mux

//--------------------------------------------MSB is SelectLines[0],LSB is SelectLines[3]-------------------------------- 

AnalogIn CurrentInput(A0); // Input from Current Mux
AnalogIn VoltageInput(A1); // Input from Voltage Multiplexer
AnalogIn TemperatureInput(A2); /*Input from Temperature Multiplexer,thermistor Multiplexer- same multiplexer for both(lines 1-4 for thermistor,line 0 for temperature sensor)*/
 


 
int quantiz(float start,float step,float x)     // accepts min and measured values and step->quantises on a scale 0-15..(4 bit quantisation)
{
    int y=(x-start)/step;
    if(y<=0)y=0;
    if(y>=15)y=15;
    return y;
}
 
void init_beacon(ShortBeacy* x,SensorDataQuantised y)  
{
    (*x).Voltage[0]=y.Vcell_soc>>4;//quantised value
    (*x).Temp[0]=y.PanelTemperature[0];//quantised value
    (*x).Temp[1]=y.PanelTemperature[1];//quantised value
    (*x).AngularSpeed[0]=y.AngularSpeed[0];
    (*x).AngularSpeed[1]=y.AngularSpeed[1];
    
    (*x).SubsystemStatus[0]=145;//dummy values----------to be changed-------------------
    (*x).ErrorFlag[0]=3;//dummy values----------to be changed-------------------
}
   SensorData SensorUQ; 
    SensorDataQuantised SensorQuantised;
    ShortBeacy Shortbeacon;

void FUNC_HK_MAIN()             
{
    //define structure variables    
 
    
    
    
    //initialise all selectlines to zeroes->1st line of muxes selected
    SelectLinesA[0]=SelectLinesA[1]=SelectLinesA[2]=SelectLinesA[3]=0;
    SelectLinesB[0]=SelectLinesB[1]=SelectLinesB[2]=0;
    SelectLinesC[0]=SelectLinesC[1]=SelectLinesC[2]=SelectLinesC[3]=0;
    
    int LoopIterator;
    int SelectLineIterator;
    
    float resistance_thermistor,voltage_thermistor;//for thermistor
 
  //measurement from voltage sensor=> 16 sensors in place
 for(LoopIterator=0; LoopIterator<16; LoopIterator++) 
{       
        //following lines read the sensor values and stores them in 'SensorData' structure's variable 'Sensor'
        SensorUQ.Voltage[LoopIterator]=(VoltageInput.read()*3.3*5.545454);//resistors in voltage divider=>15Mohm,3.3Mohm
               
        if(LoopIterator%2==0)
            SensorQuantised.Voltage[LoopIterator/2]=quantiz(vstart,vstep,SensorUQ.Voltage[LoopIterator]);
                           
        else
            SensorQuantised.Voltage[(LoopIterator)/2]=SensorQuantised.Voltage[(LoopIterator)/2]<<4+quantiz(vstart,vstep,SensorUQ.Voltage[LoopIterator]);
            
    
    
    // The following lines are used to iterate the select lines from 0 to 15
    //following is an algorithm similar to counting binary numbers of 4 bit
       for(SelectLineIterator=3;SelectLineIterator>=0;SelectLineIterator--)
        {
            if(SelectLinesA[SelectLineIterator]==0)
            {
                SelectLinesA[SelectLineIterator]=1;
                break;
            }
            else SelectLinesA[SelectLineIterator]=0;
    
        }
    
    
        wait_us(10.0); //  A delay of 10 microseconds between each sensor output. Can be changed.
 
 }
 
 
 
 
 
 //measurement from current sensor=>  8 sensors in place 

    for(LoopIterator=0; LoopIterator<8; LoopIterator++) 
{       
        //following lines read the sensor values and stores them in 'SensorData' structure variable 'Sensor'
        SensorUQ.Current[LoopIterator]=(CurrentInput.read()*3.3/(50*rsens));
        if(LoopIterator%2==0)
            SensorQuantised.Current[LoopIterator/2]=quantiz(cstart,cstep,SensorUQ.Current[LoopIterator]);
        else
            SensorQuantised.Current[(LoopIterator)/2]=SensorQuantised.Current[(LoopIterator)/2]<<4+quantiz(cstart,cstep,SensorUQ.Current[LoopIterator]);

        
        // The following lines are used to iterate the select lines from 0 to 7
        //following is an algorithm similar to counting binary numbers of 3 bits
        for(SelectLineIterator=2;SelectLineIterator>=0;SelectLineIterator--)
        {
            if(SelectLinesB[SelectLineIterator]==0)
            {
                SelectLinesB[SelectLineIterator]=1;
                break;
            }
            else SelectLinesB[SelectLineIterator]=0;
    
        }
    
    
        wait_us(10.0); //  A delay of 10 microseconds between each sensor output. Can be changed.
 
}
    
    
//measurement of temperature
//temperature measurement=> 4 thermistors, 1 temperature sensor
//mux line 1=>temp sensor, mux lines 2 to 5 =>thermistors

    for(LoopIterator=0; LoopIterator<5; LoopIterator++) 
{       
        //following lines read the sensor values and stores them in 'SensorData' structure variable 'Sensor'
        SensorUQ.Temperature[LoopIterator]=(-90.7*3.3*TemperatureInput.read()+190.1543);
        voltage_thermistor=TemperatureInput.read()*3.3;//voltage across thermistor
        resistance_thermistor=24000*voltage_thermistor/(3.3-voltage_thermistor);//resistance of thermistor
        //PanelTemperature will be updated depending on voltage_thermistor value later in the lines to follow
        
        if(LoopIterator%2==0)
     {                
            if(LoopIterator<1)                      //->corresponding to temperature sensor
                SensorQuantised.Temperature[(LoopIterator)/2]=quantiz(tstart,tstep,SensorUQ.Temperature[LoopIterator]);
         
            else                                    //->corresponding to thermistor
            {    
                if(voltage_thermistor<1.378) //Temperature>12 degC
                    SensorUQ.PanelTemperature[(LoopIterator-1)]=(3694/log(24.032242*resistance_thermistor));
                    
                else   
                    SensorUQ.PanelTemperature[(LoopIterator-1)]=(3365.4792/log(7.60404*resistance_thermistor));
                    
                    
                SensorQuantised.PanelTemperature[(LoopIterator-1)/2]=quantiz(tstart_thermistor,tstep_thermistor,SensorUQ.PanelTemperature[(LoopIterator-1)]);
                    
            }
            
     } 
    
    else
     {           
            if(LoopIterator<1)
                SensorQuantised.Temperature[(LoopIterator)/2]=SensorQuantised.Temperature[(LoopIterator)/2]<<4+quantiz(tstart,tstep,SensorUQ.Temperature[LoopIterator]); 
            
            else
             {  
                if(voltage_thermistor<1.378) //Temperature>12 degC 
                     SensorUQ.PanelTemperature[LoopIterator-1]=(3694/log(24.032242*resistance_thermistor));
                                    
                  
                else
                     SensorUQ.PanelTemperature[LoopIterator-1]=(3365.4792/log(7.60404*resistance_thermistor));
                    
                SensorQuantised.PanelTemperature[(LoopIterator-1)/2]=SensorQuantised.PanelTemperature[(LoopIterator-1)/2]<<4+quantiz(tstart_thermistor,tstep_thermistor,SensorUQ.PanelTemperature[LoopIterator-1]);
                  
            }
            
      }
      

    
    
// The following lines are used to iterate the select lines from 0 to 4
    
       //following is an algorithm similar to counting binary numbers of 4 bit
       for(SelectLineIterator=3;SelectLineIterator>=0;SelectLineIterator--)
        {
            if(SelectLinesC[SelectLineIterator]==0)
            {
                SelectLinesC[SelectLineIterator]=1;
                break;
            }
            else SelectLinesC[SelectLineIterator]=0;
    
        }
    
    
        wait_us(10.0); //  A delay of 10 microseconds between each sensor output. Can be changed.
        
}



    //update battery gauge parameters->
    float batteryparameters[4];//to populate battery parameters of struct variable Sensor
    FUNC_BATTERYGAUGE_MAIN(batteryparameters);//passing array to function 
    
    SensorUQ.Vcell=batteryparameters[0];
    SensorUQ.soc=batteryparameters[1];
    SensorUQ.crate=batteryparameters[2];
    SensorUQ.alerts=batteryparameters[3];
    
    SensorQuantised.Vcell_soc=quantiz(Vcell_start,Vcell_step,SensorUQ.Vcell);
    SensorQuantised.Vcell_soc=SensorQuantised.Vcell_soc<<4+quantiz(soc_start,soc_step,SensorUQ.soc);
    SensorQuantised.alerts=SensorUQ.alerts;
    SensorQuantised.crate=quantiz(crate_start,crate_step,SensorUQ.crate);   

    
    //update magnetometer data->
    //populate values in structure variable 'Sensor' from data to be given by Green
     SensorQuantised.AngularSpeed[0]=quantiz(AngularSpeed_start,AngularSpeed_step,SensorUQ.AngularSpeed[1]);
     SensorQuantised.AngularSpeed[0]=SensorQuantised.AngularSpeed[0]<<4+quantiz(AngularSpeed_start,AngularSpeed_step,SensorUQ.AngularSpeed[0]);
     SensorQuantised.AngularSpeed[1]=quantiz(AngularSpeed_start,AngularSpeed_step,SensorUQ.AngularSpeed[2]);
     
     //update gyro data->
    //populate values in structure variable 'Sensor' from data to be given by Green
     SensorQuantised.Bnewvalue[0]=quantiz(Bnewvalue_start,Bnewvalue_step,SensorUQ.Bnewvalue[1]);
     SensorQuantised.Bnewvalue[0]=SensorQuantised.Bnewvalue[0]<<4+quantiz(Bnewvalue_start,Bnewvalue_step,SensorUQ.Bnewvalue[0]);
     SensorQuantised.Bnewvalue[1]=quantiz(Bnewvalue_start,Bnewvalue_step,SensorUQ.Bnewvalue[2]);

     
     
     
      //update beacon structure
    init_beacon(&Shortbeacon,SensorQuantised);//Shortbeacon is passed 
    
    
}


void FUNC_BATTERYGAUGE_MAIN(float array[])
{
    float vcell=master.vcell();
    float soc=master.soc();
    float crate=master.crate();
    
    printf("\nVcell=%f",vcell);
    printf("\nSOC=%f",soc);
    printf("\nC_rate=%f",crate);
    
    array[0]=vcell;
    array[1]=soc;
    array[2]=crate;
    if (master.alerting()== true)       //alert is on
    {   
        array[3]=master.alertFlags();
        master.clearAlert();//clear alert
        master.clearAlertFlags();//clear all alert flags
    }
    
    
}

void FUNC_BATTERYGAUGE_INIT()
{
    master.disable_sleep();
    master.disable_hibernate();
    master.socChangeAlertEnabled(true);//enabling alert on soc changing by 1%
    master.emptyAlertThreshold(1);//giving minimum value to disable it to disabling it----------------------
    master.vAlertMinMaxThreshold();//set min, max value of Valrt register
    master.vResetThresholdSet();//set threshold voltage for reset
    master.vResetAlertEnabled(true);//enable alert on reset for V < Vreset
}