#include "HK.h"
 MAX17048 master(A4,A5,100000);//CHECK SDA,SCL LINES,FREQUENCY
int quantiz(float start,float step,float x);
//GPIO pins used=> D2-D13, A0-A1
DigitalOut SelectLinesA[]={D2,D3,D4,D5};//to mux1
DigitalOut SelectLinesB[]={D6,D7,D8,D9};//to mux2
DigitalOut SelectLinesC[]={D10,D11,D12,D13};//to mux3

//--------------------------------------------MSB is SelectLines[0],LSB is SelectLines[3]-------------------------------- 

AnalogIn CurrentInput(A0); // Input from Current
AnalogIn VoltageInput(A1); // Input from Voltage Multiplexer
AnalogIn TemperatureInput(A2); /*Input from Temperature Multiplexer,thermistor Multiplexer- same multiplexer for both(0-3 for thermistor,4-15 for temperature sensor)*/
    
SensorData Sensor;//struct variable
 
int quantiz(float start,float step,float x)     // accepts min and measured values and step->quantises on a scale 0-15
{
    int y=(x-start)/step;
    if(y<=0)y=0;
    if(y>=15)y=15;
    return y;
}
 
void init_beacon(ShortBeacy x)  //dummy values----------to be changed-------------------
{
    x.Voltage[0]=1;
    x.AngularSpeed[0]=2;
    x.AngularSpeed[1]=3;
    x.SubsystemStatus[0]=145;
    x.Temp[0]=1;
    x.Temp[1]=2;
    x.Temp[2]=3;
    x.ErrorFlag[0]=3;
}
 ShortBeacy Shortbeacon;//struct variable
void FUNC_HK_MAIN()             
{
    
    
    init_beacon(Shortbeacon);
    //initialise all selectlines to zeroes->1st line of mux selected
    SelectLinesA[0]=SelectLinesA[1]=SelectLinesA[2]=SelectLinesA[3]=0;
    SelectLinesB[0]=SelectLinesB[1]=SelectLinesB[2]=SelectLinesB[3]=0;
    SelectLinesC[0]=SelectLinesC[1]=SelectLinesC[2]=SelectLinesC[3]=0;
    int LoopIterator;
    float resistance_thermistor,voltage_thermistor;//for thermistor
 
    for(LoopIterator=0; LoopIterator<16; LoopIterator++) 
{
 
        if(LoopIterator%2==0)
     {
           
            Sensor.Voltage[LoopIterator/2]=quantiz(vstart,vstep,(VoltageInput.read()*3.18*5.37));
            Sensor.Current[LoopIterator/2]=quantiz(cstart,cstep,(CurrentInput.read()*3.18/(50*rsens)));
        if(LoopIterator>3)
        Sensor.Temperature[(LoopIterator-4)/2]=quantiz(tstart,tstep,(-90.7*3.18*TemperatureInput.read()+190.1543));
         else
        {    voltage_thermistor=TemperatureInput.read()*3.18;
            resistance_thermistor=24000*voltage_thermistor/(3.3-voltage_thermistor);
        if(voltage_thermistor<1.378) //Temperature>12 degC
             Sensor.PanelTemperature[(LoopIterator)/2]=quantiz(tstart_thermistor,tstep_thermistor,(3694/log(24.032242*resistance_thermistor)));
            
        else    {
            Sensor.PanelTemperature[(LoopIterator)/2]=quantiz(tstart_thermistor,tstep_thermistor,(3365.4792/log(7.60404*resistance_thermistor)));
            }
        }
        } 
    
    else
     {
           
            Sensor.Voltage[(LoopIterator-1)/2]=Sensor.Voltage[(LoopIterator-1)/2]<<4+quantiz(vstart,vstep,(VoltageInput.read()*3.18*5.37));
            Sensor.Current[(LoopIterator-1)/2]=Sensor.Current[(LoopIterator-1)/2]<<4+quantiz(cstart,cstep,(CurrentInput.read()*3.18/(50*rsens)));
            if(LoopIterator>3)
                 Sensor.Temperature[(LoopIterator-5)/2]=Sensor.Temperature[(LoopIterator-5)/2]<<4+quantiz(tstart,tstep,(-90.7*3.18*TemperatureInput.read()+190.1543)); 
             else
             {   voltage_thermistor=TemperatureInput.read()*3.18;
                    resistance_thermistor=24000*voltage_thermistor/(3.3-voltage_thermistor);
            if(voltage_thermistor<1.378) //Temperature>12 degC 
                        Sensor.PanelTemperature[(LoopIterator-1)/2]=Sensor.PanelTemperature[(LoopIterator-1)/2]<<4+quantiz(tstart_thermistor,tstep_thermistor,(3694/log(24.032242*resistance_thermistor)));
                    else
                    Sensor.PanelTemperature[(LoopIterator-1)/2]=Sensor.PanelTemperature[(LoopIterator-1)/2]<<4+quantiz(tstart_thermistor,tstep_thermistor,(3364.4792/log(7.60404*resistance_thermistor)));
                
        }
      }
    float batteryparameters[4];//to populate battery parameters of struct variable Sensor
    FUNC_BATTERYGAUGE_MAIN(batteryparameters);//passing array to function 
    
    Sensor.Vcell=batteryparameters[0];
    Sensor.soc=batteryparameters[1];
    Sensor.crate=batteryparameters[2];
    Sensor.alerts=batteryparameters[3];
    
// The following lines are used to iterate the select lines from 0 to 15
    int SelectLineIterator;
       //following is an algorithm similar to counting binary numbers of 4 bit
       for(SelectLineIterator=3;SelectLineIterator>=0;SelectLineIterator--)
        {
            if(SelectLinesA[SelectLineIterator]==0)
            {
                SelectLinesA[SelectLineIterator]=1;
                break;
            }
            else SelectLinesA[SelectLineIterator]=0;
    
       SelectLinesB[SelectLineIterator]=SelectLinesA[SelectLineIterator];
           SelectLinesC[SelectLineIterator]=SelectLinesA[SelectLineIterator];
        }
    
    
        wait_us(10.0); //  A delay of 10 microseconds between each sensor output. Can be changed.
 
    }
    
}
void FUNC_BATTERYGAUGE_MAIN(float array[])
{
    float vcell=master.vcell();
    float soc=master.soc();
    float crate=master.crate();
    
    printf("\nVcell=%f",vcell);
    printf("\nSOC=%f",soc);
    printf("\nC_rate=%f",crate);
    
    array[0]=vcell;
    array[1]=soc;
    array[2]=crate;
    if (master.alerting()== true)       //alert is on
    {   
        array[3]=master.alertFlags();
        master.clearAlert();//clear alert
        master.clearAlertFlags();//clear all alert flags
    }
    
    
}