#include "HK.h"
 
DigitalOut SelectLine3 (D4); // MSB of Select Lines
DigitalOut SelectLine2 (D3);
DigitalOut SelectLine1 (D2);
DigitalOut SelectLine0 (D1); // LSB of Select Lines
 
AnalogIn CurrentInput(A1); // Input from Current Multiplexer
AnalogIn VoltageInput(A2); // Input from Voltage Multiplexer
AnalogIn TemperatureInput(A3); // input from Temperature Multiplexer

SensorData Sensor; 
int quantiz(float start,float step,float x)
{
    int y=(x-start)/step;
    if(y<=0)y=0;
    if(y>=15)y=15;
    return y;
}
ShortBeacy Shortbeacon; 
void init_beacon(ShortBeacy x){
   ;
}
 

void FUNC_HK_MAIN()
{
    printf("\nEntered function  HK MAIN\n");
    
     Shortbeacon.Voltage[0]=1;
   Shortbeacon.AngularSpeed[0]=2;
    Shortbeacon.AngularSpeed[1]=3;
    Shortbeacon.SubsystemStatus[0]=145;
    Shortbeacon.Temp[0]=1;
    Shortbeacon.Temp[1]=2;
    Shortbeacon.Temp[2]=3;
    Shortbeacon.ErrorFlag[0]=3;
    
    int LoopIterator;
 
    SelectLine0=0;
    SelectLine1=0;
    SelectLine2=0;
    SelectLine3=0;
 
    for(LoopIterator=0; LoopIterator<16; LoopIterator++) {
        
        if(LoopIterator%2==0) {
            Sensor.Current[LoopIterator/2]=quantiz(cstart,cstep,((CurrentInput.read()*3.18)/(50*rsens)));
            Sensor.Voltage[LoopIterator/2]=quantiz(vstart,vstep,(VoltageInput.read()*3.18*5.37));
            Sensor.Temperature[LoopIterator/2]=quantiz(tstart,tstep,(-90.7*3.18*TemperatureInput.read()+190.1543));
        } else {
            Sensor.Current[(LoopIterator-1)/2]=(Sensor.Current[(LoopIterator-1)/2]<<4)+quantiz(cstart,cstep,((CurrentInput.read()*3.18)/(50*rsens)));
            Sensor.Voltage[(LoopIterator-1)/2]=(Sensor.Voltage[(LoopIterator-1)/2]<<4)+quantiz(vstart,vstep,(VoltageInput.read()*3.18*5.37));
            Sensor.Temperature[(LoopIterator-1)/2]=(Sensor.Temperature[(LoopIterator-1)/2]<<4)+quantiz(tstart,tstep,(-90.7*3.18*TemperatureInput.read()+190.1543));
        }
// The following lines are used to iterate the select lines from 0 to 15
        SelectLine0=!(SelectLine0);
 
        if(LoopIterator%2==1)
            SelectLine1=!(SelectLine1);
 
        if(LoopIterator%4==3)
            SelectLine2=!(SelectLine2);
 
        if(LoopIterator%8==7)
            SelectLine3=!(SelectLine3);
        
        wait_us(10.0); //  A delay of 10 microseconds between each sensor output. Can be changed.
 
    }
   
       printf("\nVoltage  is %u\n",Shortbeacon.Voltage[0]);
       printf("\nCurrent  is %u\n",Shortbeacon.Temp[0]);
       
    
        
 printf("\nExited function HK MAIN\n");
}
