#include "mbed.h"
#include "SDFileSystem.h"


Serial pc(USBTX,USBRX);
//SDFileSystem sd(PB_15, PB_14, PB_13, PB_12, "sd",NC,SWITCH_NONE,25000000);

//使用Nucleo-L476RG 的 SPI2 
//              mosi   miso   sclk   cs
SDFileSystem sd(PB_15, PB_14, PB_13, PB_12, "sd");  
//文档里说SDFileSystem 的最高频率就是1MHz,即构造函数的默认参数，这个需要确认一下

Timer timer;
DigitalIn button(PC_13, PullUp);  //使用Nucleo-L476RG 的 User button 就在PC_13上

char buffer[4096];


void writeTest()
{
    //Test write performance by creating a 1MB file
    pc.printf("Testing %iB write performance...", sizeof(buffer));
    FileHandle* file = sd.open("Test File.bin", O_WRONLY | O_CREAT | O_TRUNC);
    if (file != NULL) {
        timer.start();
        for (int i = 0; i < (1048576 / sizeof(buffer)); i++) {
            if (file->write(buffer, sizeof(buffer)) != sizeof(buffer)) {
                timer.stop();
                pc.printf("write error!\n");
                timer.reset();
                return;
            }
        }
        timer.stop();
        if (file->close())
            pc.printf("failed to close file!\n");
        else
            pc.printf("done!\n\tResult: %.2fKB/s\n", 1024 / (timer.read_us() / 1000000.0));
        timer.reset();
    } else {
        pc.printf("failed to create file!\n");
    }
}

void readTest()
{
    //Test read performance by reading the 1MB file created by writeTest()
    pc.printf("Testing %iB read performance...", sizeof(buffer));
    FileHandle* file = sd.open("Test File.bin", O_RDONLY);
    if (file != NULL) {
        timer.start();
        int iterations = 0;
        while (file->read(buffer, sizeof(buffer)) == sizeof(buffer))
            iterations++;
        timer.stop();
        if (iterations != (1048576 / sizeof(buffer)))
            pc.printf("read error!\n");
        else if (file->close())
            pc.printf("failed to close file!\n");
        else if (sd.remove("Test File.bin"))
            pc.printf("failed to delete file!\n");
        else
            pc.printf("done!\n\tResult: %.2fKB/s\n", 1024 / (timer.read_us() / 1000000.0));
        timer.reset();
    } else {
        pc.printf("failed to open file!\n");
    }
}

int main1()
{
    //Configure CRC, large frames, and write validation
    sd.crc(true);
    sd.large_frames(true);
    sd.write_validation(true);

    //Fill the buffer with random data for the write test
    srand(time(NULL));
    for (int i = 0; i < sizeof(buffer); i++)
        buffer[i] = rand();

    while(1) {
        //Simple button debouncing
        wait(0.5);

        //Print the start message
        pc.printf("\nPress the button to perform tests: ");

        //Wait for the button to be pressed
        while(button);

        //Make sure a card is present
        if (!sd.card_present()) {
            pc.printf("\nNo card present!\n");
            continue;
        }
        
        //挂载SD卡，失败，原因不明，但是即使不挂载，后续的读写文件操作也能正常进行
/*
        //Try to mount the SD card
        printf("\nMounting SD card...");
        if (sd.mount() != 0) {
            pc.printf("failed!\n");
            continue;
        }
        pc.printf("success!\n");
*/
    
    
        //卡类型也不能识别，原因不明
        //Display the card type
        pc.printf("\tCard type: ");
        SDFileSystem::CardType cardType = sd.card_type();
        if (cardType == SDFileSystem::CARD_NONE)
            pc.printf("None\n");
        else if (cardType == SDFileSystem::CARD_MMC)
            pc.printf("MMC\n");
        else if (cardType == SDFileSystem::CARD_SD)
            pc.printf("SD\n");
        else if (cardType == SDFileSystem::CARD_SDHC)
            pc.printf("SDHC\n");
        else
            pc.printf("Unknown\n");

        //卡的扇区数，容量也不能正确获取，原因不明
        //Display the card capacity
        pc.printf("\tSectors: %u\n", sd.disk_sectors());
        pc.printf("\tCapacity: %.1fMB\n", sd.disk_sectors() / 2048.0);

        
        //格式化，但是格式化一个8G的盘我是没等到结束
        /* //Format the card
        printf("Formatting SD card...");
        if (sd.format() != 0) {
            printf("failed!\n");
            continue;
        }
        printf("success!\n");*/

        //读写测试，即使前面的挂载等操作不能正常运行，读写测试也可以正常运行
        //Perform a read/write test
        writeTest();
        readTest();

        //Unmount the SD card
        sd.unmount();
    }
}


int main() {
     
    pc.printf("SD card test!\r\n");   

    //建立文件夹
    mkdir("/sd/mydir", 0777);

    //追加方式打开或创建文件，写入数据
    FILE *fp = fopen("/sd/1.txt", "a");
    if(fp == NULL) {
        pc.printf("Could not open file for write\r\n"); 
    }
    fprintf(fp, "Hello fun SD Card World!\r\n");
    fclose(fp);
    pc.printf("File successfully written and closed!\r\n");
    
    //写测试
    writeTest();
    //读测试
    readTest();
}