#include "mbed.h"
#include "C12832.h"
#include "MMA7660.h"

C12832 lcd(p5, p7, p6, p8, p11);
BusIn joy(p15, p16, p12, p16);
DigitalIn fire(p14);
DigitalIn up(p15);
DigitalIn down(p12);
DigitalIn right(p16);
DigitalIn left(p13);
BusOut leds(LED1,LED2,LED3,LED4);
PwmOut speaker(p26);
PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);
MMA7660 MMA(p28, p27);
AnalogIn pot1(p19);
AnalogIn pot2(p20);
Ticker timeInt;


DigitalOut led(LED1);
DigitalOut led2(LED2);

LocalFileSystem local("local");

/*ゲームステータス*/
int racketP1,shot,enemyX=127,enemyY,enemyX2,life=3,lifeLED=3,lvl=2,score=0;
unsigned int randoms=0;

void setHz(int Hz){
    float sycle;
    sycle = (float)1/Hz;
    speaker.period(sycle);
    speaker = 0.3;
}

void end(){
    FILE *fp;
    int i;
    timeInt.detach();
    r = g = b = 1;
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("SCORE:%d  ", score);
    fp = fopen("/local/test.txt","r");
    led = 1;
    if(!fp){
        printf("error");
        exit(1);
    }
    else{
        fscanf(fp,"%d",&i);
        fclose(fp);
    }
    led2 = 1;
    
    if(score > i){
        fp = fopen("/local/test.txt","w");
        fprintf(fp,"%d",score);
        fclose(fp);
        lcd.locate(0, 10);
        lcd.printf("NEW RECORD!!\nHIGH SCORE:%d",score);
    }
    else{
        lcd.locate(0, 10);
        lcd.printf("HIGH SCORE:%d",i);
    }
    
    wait(2);
    speaker = 0;
    while(1);
}


void timeIntFunc(){
    static unsigned int sownd=0,safeTime=40;
    
    lcd.cls();
    
    if(shot){
        if(sownd<9)sownd = 1;
        lcd.rect(9, (racketP1*8)+3, 127, (racketP1*8)+4, 1);
    }
    
    if(safeTime>0){
        safeTime--;
        enemyY = randoms % 4;
    }
    else if(enemyY == racketP1 && shot){
        if(sownd<9)sownd = 5;
        score++;
//        lcd.fillcircle(enemyX+3, (enemyY*8)+4, 14, 1);
        enemyX = 127;
        enemyY = randoms%4;
        if(!(score%20)){
            lvl++;
        }
    }else{
        enemyX -= lvl;
    }
    
    if(enemyX < 1){
        life--;
        sownd = 9;
        enemyX = 127;
        safeTime = 40;
    }
    
    if(enemyX > 120)enemyX2 = 127;
    else enemyX2 = enemyX+7;
    if(!safeTime)lcd.fillrect(enemyX, enemyY*8, enemyX2, (enemyY*8)+7, 1);
    lcd.rect(0, racketP1*8, 7, (racketP1*8)+7, 1);
    
    switch(sownd){
        case 0:
        speaker = 0;
        sownd = 0;
        break;
        case 1:
        setHz(1000);
        sownd++;
        break;
        case 2:
        setHz(660);
        sownd++;
        break;
        case 3:
        setHz(440);
        sownd++;
        break;
        case 4:
        setHz(200);
        sownd = 0;
        break;
        
        case 5:
        setHz(150);
        sownd++;
        break;
        case 6:
        setHz(100);
        sownd++;
        break;
        case 7:
        setHz(150);
        sownd++;
        break;
        case 8:
        setHz(100);
        sownd = 0;
        break;
        
        case 9:
        setHz(100);
        sownd++;
        lifeLED = life;
        break;
        case 10:
        setHz(150);
        sownd++;
        lifeLED = life+1;
        break;
        case 11:
        setHz(300);
        sownd++;
        lifeLED = life;
        break;
        case 12:
        setHz(150);
        sownd++;
        lifeLED = life+1;
        break;
        case 13:
        setHz(300);
        sownd++;
        lifeLED = life;
        break;
        case 14:
        setHz(150);
        sownd++;
        lifeLED = life+1;
        break;
        case 15:
        setHz(100);
        sownd = 0;
        lifeLED = life;
        if(life == 0){
            end();
        }
        break;
    }
    switch(lifeLED){
        case 0:
        r = b = g = 1;
        break;
        case 1:
        r = 0;
        g = 1;
        break;
        case 2:
        r = g = 0;
        break;
        case 3:
        g = 0;
        r = 1;
        break;
    }
    shot = 0;
}

int main() {
    int upE,downE,rightE,leftE,fireE;
    lcd.cls();
    speaker = 0;
    r.period(0.01);
    g.period(0.01);
    b.period(0.01);
    r = g = b = 1;
    lcd.locate(0, 0);
    lcd.printf("PLEASE PRESS\n    ANY BUTTON");
    while(!joy && !fire);
    timeInt.attach(&timeIntFunc, 0.050);
    while(1){
        randoms++;
        if(!up)upE = 1;
        if(!down)downE = 1;
        if(!right)rightE = 1;
        if(!left)leftE = 1;
        if(!fire)fireE = 1;
        if(fire && fireE){
            randoms = 0;
            fireE = 0;
            shot = 1;
        }else if(up && upE && racketP1!=0){
            randoms = 0;
            upE = 0;
            racketP1--;
        }else if(down && downE && racketP1!=3){
            randoms = 0;
            downE = 0;
            racketP1++;
        }
    }
}