/*
 * Ultrasonic.cpp
 * A library for ultrasonic ranger
 *
 * Copyright (c) 2012 seeed technology inc.
 * Website    : www.seeed.cc
 * Author     : LG, FrankieChu
 * Create Time: Jan 17,2013
 *
 * Change Log :
 *   adapted to ARM mbed by Guido Grassel, Oct 2014
 *
 * The MIT License (MIT)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "Ultrasonic.h"

Ultrasonic::Ultrasonic(PinName pin)
    : _pin(pin)
{
}

/*The measured distance from the range 0 to 400 Centimeters*/
long Ultrasonic::measureInCentimeters(void)
{
    _pin.output();
    _pin = 0; // digitalWrite(_pin, LOW);
    wait_us(2); //  delayMicroseconds(2);
    _pin = 1; //  digitalWrite(_pin, HIGH);

    wait_us(5);     //delayMicroseconds(5);
    _pin = 0;      //digitalWrite(_pin,LOW);
    _pin.input();   // pinMode(_pin,INPUT);
    long duration;
    duration = pulseIn();
    long RangeInCentimeters;
    RangeInCentimeters = duration/29/2;
    return RangeInCentimeters;
}

long Ultrasonic::pulseIn(void) {
    Timer tmr;
    _pin.input();
    while (_pin!=1) {
        ;    // wait for high
    }
    tmr.start();
    while (_pin!=0) {
        ;    // wait for low
    }
    int duration = tmr.read_us();
    tmr.stop();
    return (long) duration;
}
