
#include "mbed.h"
#include "I2CX.h"
#include "BMP085.h"

// this little program onlu works with the modified mbed-src, 
// see https://developer.mbed.org/questions/5107/Arch-BLE-I2C-working/#answer5390

int main(void)
{
    printf("Creating i2c interface  ...\r\n");
    I2CX ic(I2C_0, p29, p28); // I2CName peripheral, pin sda, pin slc)
    printf("Creating barometer interface  ...\r\n");
    BMP085 barometer(ic, BMP085_oss1);

    float p = 0.0f, t = 0.0f;

    printf("Entering main loop  ...\r\n");
    while(1) {
        barometer.update();
        p = barometer.get_pressure();
        t = barometer.get_temperature();
        printf("Pressure: %6.2f Temperature(c): %6.2f Temperature(F): %6.2f\r\n", p, t, 32 + t * 1.8f);
        wait(1.0f);
    }
}
