#include "STM32F4_RNG.h"
#include "mbed.h"


STM32F4_RNG::STM32F4_RNG() {
    RCC->AHB2ENR |= RCC_AHB2ENR_RNGEN;  /* Enable RNG clock source */
    RNG->CR |= RNG_CR_RNGEN;            /* RNG Peripheral enable */
}


unsigned long STM32F4_RNG::Get() {
    while (!(RNG->SR & (RNG_SR_DRDY))); /* Wait until one RNG number is ready */

    return RNG->DR;                     /* Get a 32-bit Random number */
}