/* STM32F4_RNG Library v1.0
 * Copyright (c) 2016 Grant Phillips
 * grant.phillips@nmmu.ac.za
 * 
 * This library was adapted from tm_stm32f4_rng written by Tilen Majerle.
 * (http://stm32f4-discovery.com/2014/07/library-22-true-random-number-generator-stm32f4xx/)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#ifndef STM32F4_RNG_H
#define STM32F4_RNG_H
 
#include "mbed.h"

/** Class library for using the true Random Number Generator on STM32F4xxx devices.
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include "STM32F4_RNG.h"
 * #include "SWO.h"
 * 
 * STM32F4_RNG rnd;
 *
 * int main() { 
 *     // create a 32-bit unsigned variable
 *     unsigned long num;   //or uint32_t num
 *
 *     while(1) {
 *         num = rnd.Get();
 *         printf("%u\n", num);
 *         wait(1.0);
 *     } 
 * }
 * @endcode
 */
 
class STM32F4_RNG {
  public:
    /** Create a STM32F4_RNG object.
    *
    */
    STM32F4_RNG();
    
    /** Gets a 32-bit random number.
    * @param 
    *     None
    * @return 
    *     32-bit random number.
    */
    unsigned long Get();
};
 
#endif