#include "LM6029ACW.h"
#include "mbed.h"
 

/* ***************************************** Public Functions ***************************************** */

LM6029ACW::LM6029ACW(PinName CS1, PinName RES, PinName RS, PinName WR, PinName RD, PinName DB7, PinName DB6, PinName DB5, PinName DB4, PinName DB3, PinName DB2, PinName DB1, PinName DB0) 
: CS1pin(CS1), RESpin(RES), RSpin(RS), WRpin(WR), RDpin(RD), DATApins(DB0, DB1, DB2, DB3, DB4, DB5, DB6, DB7) {
    character_x = 0;
    character_y = 0;
    Init();
}


void LM6029ACW::ClrScr(unsigned char color)
{
    unsigned char i, j, x=0;

    CS1pin = 0;
    for(i=0; i<8; i++)
    {
        x=0;
        SetColumn(0);
        SetPage(i);
        for(j=0; j<128; j++)
            if(color==0)
            {
                WriteData(0x00);
                DisplayRAM[x][i] = 0x00;
                x++;
            }
            else
            {
                WriteData(0xff);
                DisplayRAM[x][i] = 0xff;
                x++;
            }
    }
    CS1pin = 1;
}


void LM6029ACW::PowerSave(void)
{
    CS1pin = 0;
    WriteCommand(0xae);
    WriteCommand(0xa5);
    CS1pin = 1;
}


void LM6029ACW::PowerActive(void)
{
    CS1pin = 0;
    WriteCommand(0xa4);
    WriteCommand(0xaf);
    CS1pin = 1;
}


void LM6029ACW::DrawPixel(unsigned char x, unsigned char y, unsigned char color)
{
    unsigned char page, temp1, temp2;

    page = y >> 3;
    y = y & 0x07;
    temp1 = DisplayRAM[x][page];
    temp2 = 1 << y;
    switch(color)
    {
        case 0: temp1 = temp1 & ~temp2;
                break;
        case 1: temp1 = temp1 | temp2;
                break;
        case 2: temp1 = temp1 ^ temp2;
                break;
    }
    DisplayRAM[x][page] = temp1;
    CS1pin = 0;
    SetColumn(x);
    SetPage(page);
    WriteData((unsigned char)(temp1));
    CS1pin = 1;
}


void LM6029ACW::DrawLine(int x1, int y1, int x2, int y2, unsigned int color)
{
   int        dy, dx;
   signed char  addx=1, addy=1;
   signed int P, diff;

   int i=0;
   dx = abs((signed int)(x2 - x1));
   dy = abs((signed int)(y2 - y1));

   if(x1 > x2)
      addx = -1;
   if(y1 > y2)
      addy = -1;

   if(dx >= dy)
   {
      dy *= 2;
      P = dy - dx;
      diff = P - dx;

      for(; i<=dx; ++i)
      {
         DrawPixel(x1, y1, color);

         if(P < 0)
         {
            P  += dy;
            x1 += addx;
         }
         else
         {
            P  += diff;
            x1 += addx;
            y1 += addy;
         }
      }
   }
   else
   {
      dx *= 2;
      P = dx - dy;
      diff = P - dy;

      for(; i<=dy; ++i)
      {
          DrawPixel(x1, y1, color);

         if(P < 0)
         {
            P  += dx;
            y1 += addy;
         }
         else
         {
            P  += diff;
            x1 += addx;
            y1 += addy;
         }
      }
   }
}


void LM6029ACW::DrawCircle(unsigned char x, unsigned char y, unsigned char radius, unsigned char fill, unsigned char color)
{
   signed char a, b, P;

   a = 0;
   b = radius;
   P = 1 - radius;

   do
   {
      if(fill)
      {
         DrawLine(x-a, y+b, x+a, y+b, color);
         DrawLine(x-a, y-b, x+a, y-b, color);
         DrawLine(x-b, y+a, x+b, y+a, color);
         DrawLine(x-b, y-a, x+b, y-a, color);
      }
      else
      {
         DrawPixel(a+x, b+y, color);
         DrawPixel(b+x, a+y, color);
         DrawPixel(x-a, b+y, color);
         DrawPixel(x-b, a+y, color);
         DrawPixel(b+x, y-a, color);
         DrawPixel(a+x, y-b, color);
         DrawPixel(x-a, y-b, color);
         DrawPixel(x-b, y-a, color);
      }

      if(P < 0)
         P += 3 + 2 * a++;
      else
         P += 5 + 2 * (a++ - b--);
    } while(a <= b);
}


void LM6029ACW::GotoXY(unsigned char x, unsigned char y)
{
  if(x<=20)
    character_x = x;
  else
    character_x = 0;

  if(y<=7)
    character_y = y;
  else
    character_y = 0;
}


void LM6029ACW::PutStr(char *str, unsigned char color)
{
    unsigned int i=0;

    do
    {
        PutChar(str[i], color);
        i++;
    }while(str[i]!='\0');
}


void LM6029ACW::PutChar(unsigned char c, unsigned char color)
{
    unsigned char x, page;

    x = character_x * 6 + 1;
    page = character_y;

    DrawChar(c, x, page, color);
    if(character_x == 20)
    {
        character_x=0;
        if(character_y==7)
            character_y=0;
        else
            character_y++;
    }
    else
        character_x++;
}












/* ***************************************** Private Functions ***************************************** */

void LM6029ACW::Delay(unsigned int del)
{
    unsigned int i=0;

    while(i<del)
        i++;
}


void LM6029ACW::WriteCommand(unsigned char cmd)
{
    RSpin = 0;

    DATApins = cmd; 
    wait(lcd_delayx);
    WRpin = 0;  
    wait(lcd_delayx);
    WRpin = 1;
}


void LM6029ACW::WriteData(unsigned char dat)
{
    RSpin = 1;

    DATApins = dat;
    wait(lcd_delayx);
    WRpin = 0;  
    wait(lcd_delayx);
    WRpin = 1;
}
 

void LM6029ACW::SetPage(unsigned char Page)
{
    Page = Page & 0x0f;
    Page = Page | 0xb0;
    WriteCommand(Page);
}


void LM6029ACW::SetColumn(unsigned char Col)
{
    unsigned char temp;

    temp = Col;
    Col = Col & 0x0f;
    Col = Col | 0x00;
    WriteCommand(Col);
    temp = temp >> 4;
    Col = temp & 0x0f;
    Col = Col | 0x10;
    WriteCommand(Col);
}

 
void LM6029ACW::Init(void)
{
    unsigned char i,j;
    
    RDpin = 1;
    CS1pin = 0;
    RESpin = 0;
    wait(lcd_init_delay);
    RESpin = 1;

    WriteCommand(0xa0);    //ADC=0 Normal
    WriteCommand(0xc8);    //SHL=1 flipped in y-direction
    WriteCommand(0xa2);    //Bias=0; 1/9 Bias
    WriteCommand(0x2f);    //Power Control VF, VR, VC
    WriteCommand(0xae);    //Display OFF
    WriteCommand(0x81);    //Set voltage reference mode
    WriteCommand(0x29);    //Power Control VF
    WriteCommand(0x40);    //Set display start line
    WriteCommand(0xaf);    //Display ON

    for(i=0;i<128;i++)
        for(j=0;j<8;j++)
            DisplayRAM[i][j]=0x00;

    CS1pin = 1;
    
    ClrScr(0);
}


void LM6029ACW::WriteCharCol(unsigned char v, unsigned char x, unsigned char page, unsigned char color)
{
    if(color==0)
    {
        WriteData(~v);
        DisplayRAM[x][page] = ~v;
    }
    else
    {
        WriteData(v);
        DisplayRAM[x][page] = v;
    }
}



void LM6029ACW::DrawChar(unsigned char c, unsigned char x, unsigned char page, unsigned char color)
{
    CS1pin = 0;
    SetColumn(x);
    SetPage(page);

    switch(c)
    {
        case 32:    // 'SPACE'
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0x00, x+1, page, color);
            WriteCharCol(0x00, x+2, page, color);
            WriteCharCol(0x00, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 33:    // '!'
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0x00, x+1, page, color);
            WriteCharCol(0x9e, x+2, page, color);
            WriteCharCol(0x00, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 34:    // '"'
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0x0e, x+1, page, color);
            WriteCharCol(0x00, x+2, page, color);
            WriteCharCol(0x0e, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 35:    // '#'
        {
            WriteCharCol(0x28, x, page, color);
            WriteCharCol(0xfe, x+1, page, color);
            WriteCharCol(0x28, x+2, page, color);
            WriteCharCol(0xfe, x+3, page, color);
            WriteCharCol(0x28, x+4, page, color);
        }break;

        case 36:    // '$'
        {
            WriteCharCol(0x48, x, page, color);
            WriteCharCol(0x54, x+1, page, color);
            WriteCharCol(0xfe, x+2, page, color);
            WriteCharCol(0x54, x+3, page, color);
            WriteCharCol(0x24, x+4, page, color);
        }break;

        case 37:    // '%'
        {
            WriteCharCol(0x46, x, page, color);
            WriteCharCol(0x26, x+1, page, color);
            WriteCharCol(0x10, x+2, page, color);
            WriteCharCol(0xc8, x+3, page, color);
            WriteCharCol(0xc4, x+4, page, color);
        }break;

        case 38:    // '&'
        {
            WriteCharCol(0x6c, x, page, color);
            WriteCharCol(0x92, x+1, page, color);
            WriteCharCol(0xaa, x+2, page, color);
            WriteCharCol(0x44, x+3, page, color);
            WriteCharCol(0xa0, x+4, page, color);
        }break;

        case 39:    // '''
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0x0a, x+1, page, color);
            WriteCharCol(0x06, x+2, page, color);
            WriteCharCol(0x00, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 40:    // '('
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0x38, x+1, page, color);
            WriteCharCol(0x44, x+2, page, color);
            WriteCharCol(0x82, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 41:    // ')'
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0x82, x+1, page, color);
            WriteCharCol(0x44, x+2, page, color);
            WriteCharCol(0x38, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 42:    // '*'
        {
            WriteCharCol(0x28, x, page, color);
            WriteCharCol(0x10, x+1, page, color);
            WriteCharCol(0x7c, x+2, page, color);
            WriteCharCol(0x10, x+3, page, color);
            WriteCharCol(0x28, x+4, page, color);
        }break;

        case 43:    // '+'
        {
            WriteCharCol(0x10, x, page, color);
            WriteCharCol(0x10, x+1, page, color);
            WriteCharCol(0x7c, x+2, page, color);
            WriteCharCol(0x10, x+3, page, color);
            WriteCharCol(0x10, x+4, page, color);
        }break;

        case 44:    // ','
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0xa0, x+1, page, color);
            WriteCharCol(0x60, x+2, page, color);
            WriteCharCol(0x00, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 45:    // '-'
        {
            WriteCharCol(0x10, x, page, color);
            WriteCharCol(0x10, x+1, page, color);
            WriteCharCol(0x10, x+2, page, color);
            WriteCharCol(0x10, x+3, page, color);
            WriteCharCol(0x10, x+4, page, color);
        }break;

        case 46:    // '.'
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0xc0, x+1, page, color);
            WriteCharCol(0xc0, x+2, page, color);
            WriteCharCol(0x00, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 47:    // '/'
        {
            WriteCharCol(0x40, x, page, color);
            WriteCharCol(0x20, x+1, page, color);
            WriteCharCol(0x10, x+2, page, color);
            WriteCharCol(0x08, x+3, page, color);
            WriteCharCol(0x04, x+4, page, color);
        }break;

        case 48:    // '0'
        {
            WriteCharCol(0x7c, x, page, color);
            WriteCharCol(0xa2, x+1, page, color);
            WriteCharCol(0x92, x+2, page, color);
            WriteCharCol(0x8a, x+3, page, color);
            WriteCharCol(0x7c, x+4, page, color);
        }break;

        case 49:    // '1'
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0x84, x+1, page, color);
            WriteCharCol(0xfe, x+2, page, color);
            WriteCharCol(0x80, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 50:    // '2'
        {
            WriteCharCol(0x84, x, page, color);
            WriteCharCol(0xc2, x+1, page, color);
            WriteCharCol(0xa2, x+2, page, color);
            WriteCharCol(0x92, x+3, page, color);
            WriteCharCol(0x8c, x+4, page, color);
        }break;

        case 51:    // '3'
        {
            WriteCharCol(0x42, x, page, color);
            WriteCharCol(0x82, x+1, page, color);
            WriteCharCol(0x8a, x+2, page, color);
            WriteCharCol(0x96, x+3, page, color);
            WriteCharCol(0x62, x+4, page, color);
        }break;

        case 52:    // '4'
        {
            WriteCharCol(0x30, x, page, color);
            WriteCharCol(0x28, x+1, page, color);
            WriteCharCol(0x24, x+2, page, color);
            WriteCharCol(0xfe, x+3, page, color);
            WriteCharCol(0x20, x+4, page, color);
        }break;

        case 53:    // '5'
        {
            WriteCharCol(0x4e, x, page, color);
            WriteCharCol(0x8a, x+1, page, color);
            WriteCharCol(0x8a, x+2, page, color);
            WriteCharCol(0x8a, x+3, page, color);
            WriteCharCol(0x72, x+4, page, color);
        }break;

        case 54:    // '6'
        {
            WriteCharCol(0x78, x, page, color);
            WriteCharCol(0x94, x+1, page, color);
            WriteCharCol(0x92, x+2, page, color);
            WriteCharCol(0x92, x+3, page, color);
            WriteCharCol(0x60, x+4, page, color);
        }break;

        case 55:    // '7'
        {
            WriteCharCol(0x02, x, page, color);
            WriteCharCol(0xe2, x+1, page, color);
            WriteCharCol(0x12, x+2, page, color);
            WriteCharCol(0x0a, x+3, page, color);
            WriteCharCol(0x06, x+4, page, color);
        }break;

        case 56:    // '8'
        {
            WriteCharCol(0x6c, x, page, color);
            WriteCharCol(0x92, x+1, page, color);
            WriteCharCol(0x92, x+2, page, color);
            WriteCharCol(0x92, x+3, page, color);
            WriteCharCol(0x6c, x+4, page, color);
        }break;

        case 57:    // '9'
        {
            WriteCharCol(0x0c, x, page, color);
            WriteCharCol(0x92, x+1, page, color);
            WriteCharCol(0x92, x+2, page, color);
            WriteCharCol(0x52, x+3, page, color);
            WriteCharCol(0x3c, x+4, page, color);
        }break;

        case 58:    // ':'
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0x6c, x+1, page, color);
            WriteCharCol(0x6c, x+2, page, color);
            WriteCharCol(0x00, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 59:    // ';'
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0xac, x+1, page, color);
            WriteCharCol(0x6c, x+2, page, color);
            WriteCharCol(0x00, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 60:    // '<'
        {
            WriteCharCol(0x10, x, page, color);
            WriteCharCol(0x28, x+1, page, color);
            WriteCharCol(0x44, x+2, page, color);
            WriteCharCol(0x82, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 61:    // '='
        {
            WriteCharCol(0x28, x, page, color);
            WriteCharCol(0x28, x+1, page, color);
            WriteCharCol(0x28, x+2, page, color);
            WriteCharCol(0x28, x+3, page, color);
            WriteCharCol(0x28, x+4, page, color);
        }break;

        case 62:    // '>'
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0x82, x+1, page, color);
            WriteCharCol(0x44, x+2, page, color);
            WriteCharCol(0x28, x+3, page, color);
            WriteCharCol(0x10, x+4, page, color);
        }break;

        case 63:    // '?'
        {
            WriteCharCol(0x04, x, page, color);
            WriteCharCol(0x02, x+1, page, color);
            WriteCharCol(0xa2, x+2, page, color);
            WriteCharCol(0x12, x+3, page, color);
            WriteCharCol(0x0c, x+4, page, color);
        }break;

        case 64:    // '@'
        {
            WriteCharCol(0x64, x, page, color);
            WriteCharCol(0x92, x+1, page, color);
            WriteCharCol(0xf2, x+2, page, color);
            WriteCharCol(0x82, x+3, page, color);
            WriteCharCol(0x7c, x+4, page, color);
        }break;

        case 65:    // 'A'
        {
            WriteCharCol(0xfc, x, page, color);
            WriteCharCol(0x22, x+1, page, color);
            WriteCharCol(0x22, x+2, page, color);
            WriteCharCol(0x22, x+3, page, color);
            WriteCharCol(0xfc, x+4, page, color);
        }break;

        case 66:    // 'B'
        {
            WriteCharCol(0xfe, x, page, color);
            WriteCharCol(0x92, x+1, page, color);
            WriteCharCol(0x92, x+2, page, color);
            WriteCharCol(0x92, x+3, page, color);
            WriteCharCol(0x6c, x+4, page, color);
        }break;

        case 67:    // 'C'
        {
            WriteCharCol(0x7c, x, page, color);
            WriteCharCol(0x82, x+1, page, color);
            WriteCharCol(0x82, x+2, page, color);
            WriteCharCol(0x82, x+3, page, color);
            WriteCharCol(0x44, x+4, page, color);
        }break;

        case 68:    // 'D'
        {
            WriteCharCol(0xfe, x, page, color);
            WriteCharCol(0x82, x+1, page, color);
            WriteCharCol(0x82, x+2, page, color);
            WriteCharCol(0x44, x+3, page, color);
            WriteCharCol(0x38, x+4, page, color);
        }break;

        case 69:    // 'E'
        {
            WriteCharCol(0xfe, x, page, color);
            WriteCharCol(0x92, x+1, page, color);
            WriteCharCol(0x92, x+2, page, color);
            WriteCharCol(0x92, x+3, page, color);
            WriteCharCol(0x82, x+4, page, color);
        }break;

        case 70:    // 'F'
        {
            WriteCharCol(0xfe, x, page, color);
            WriteCharCol(0x12, x+1, page, color);
            WriteCharCol(0x12, x+2, page, color);
            WriteCharCol(0x12, x+3, page, color);
            WriteCharCol(0x02, x+4, page, color);
        }break;

        case 71:    // 'G'
        {
            WriteCharCol(0x7c, x, page, color);
            WriteCharCol(0x82, x+1, page, color);
            WriteCharCol(0x92, x+2, page, color);
            WriteCharCol(0x92, x+3, page, color);
            WriteCharCol(0xf4, x+4, page, color);
        }break;

        case 72:    // 'H'
        {
            WriteCharCol(0xfe, x, page, color);
            WriteCharCol(0x10, x+1, page, color);
            WriteCharCol(0x10, x+2, page, color);
            WriteCharCol(0x10, x+3, page, color);
            WriteCharCol(0xfe, x+4, page, color);
        }break;

        case 73:    // 'I'
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0x82, x+1, page, color);
            WriteCharCol(0xfe, x+2, page, color);
            WriteCharCol(0x82, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 74:    // 'J'
        {
            WriteCharCol(0x40, x, page, color);
            WriteCharCol(0x80, x+1, page, color);
            WriteCharCol(0x82, x+2, page, color);
            WriteCharCol(0x7e, x+3, page, color);
            WriteCharCol(0x02, x+4, page, color);
        }break;

        case 75:    // 'K'
        {
            WriteCharCol(0xfe, x, page, color);
            WriteCharCol(0x10, x+1, page, color);
            WriteCharCol(0x28, x+2, page, color);
            WriteCharCol(0x44, x+3, page, color);
            WriteCharCol(0x82, x+4, page, color);
        }break;

        case 76:    // 'L'
        {
            WriteCharCol(0xfe, x, page, color);
            WriteCharCol(0x80, x+1, page, color);
            WriteCharCol(0x80, x+2, page, color);
            WriteCharCol(0x80, x+3, page, color);
            WriteCharCol(0x80, x+4, page, color);
        }break;

        case 77:    // 'M'
        {
            WriteCharCol(0xfe, x, page, color);
            WriteCharCol(0x04, x+1, page, color);
            WriteCharCol(0x18, x+2, page, color);
            WriteCharCol(0x04, x+3, page, color);
            WriteCharCol(0xfe, x+4, page, color);
        }break;

        case 78:    // 'N'
        {
            WriteCharCol(0xfe, x, page, color);
            WriteCharCol(0x08, x+1, page, color);
            WriteCharCol(0x10, x+2, page, color);
            WriteCharCol(0x20, x+3, page, color);
            WriteCharCol(0xfe, x+4, page, color);
        }break;

        case 79:    // 'O'
        {
            WriteCharCol(0x7c, x, page, color);
            WriteCharCol(0x82, x+1, page, color);
            WriteCharCol(0x82, x+2, page, color);
            WriteCharCol(0x82, x+3, page, color);
            WriteCharCol(0x7c, x+4, page, color);
        }break;

        case 80:    // 'P'
        {
            WriteCharCol(0xfe, x, page, color);
            WriteCharCol(0x12, x+1, page, color);
            WriteCharCol(0x12, x+2, page, color);
            WriteCharCol(0x12, x+3, page, color);
            WriteCharCol(0x0c, x+4, page, color);
        }break;

        case 81:    // 'Q'
        {
            WriteCharCol(0x7c, x, page, color);
            WriteCharCol(0x82, x+1, page, color);
            WriteCharCol(0xa2, x+2, page, color);
            WriteCharCol(0x42, x+3, page, color);
            WriteCharCol(0xbc, x+4, page, color);
        }break;

        case 82:    // 'R'
        {
            WriteCharCol(0xfe, x, page, color);
            WriteCharCol(0x12, x+1, page, color);
            WriteCharCol(0x32, x+2, page, color);
            WriteCharCol(0x52, x+3, page, color);
            WriteCharCol(0x8c, x+4, page, color);
        }break;

        case 83:    // 'S'
        {
            WriteCharCol(0x8c, x, page, color);
            WriteCharCol(0x92, x+1, page, color);
            WriteCharCol(0x92, x+2, page, color);
            WriteCharCol(0x92, x+3, page, color);
            WriteCharCol(0x62, x+4, page, color);
        }break;

        case 84:    // 'T'
        {
            WriteCharCol(0x02, x, page, color);
            WriteCharCol(0x02, x+1, page, color);
            WriteCharCol(0xfe, x+2, page, color);
            WriteCharCol(0x02, x+3, page, color);
            WriteCharCol(0x02, x+4, page, color);
        }break;

        case 85:    // 'U'
        {
            WriteCharCol(0x7e, x, page, color);
            WriteCharCol(0x80, x+1, page, color);
            WriteCharCol(0x80, x+2, page, color);
            WriteCharCol(0x80, x+3, page, color);
            WriteCharCol(0x7e, x+4, page, color);
        }break;

        case 86:    // 'V'
        {
            WriteCharCol(0x3e, x, page, color);
            WriteCharCol(0x40, x+1, page, color);
            WriteCharCol(0x80, x+2, page, color);
            WriteCharCol(0x40, x+3, page, color);
            WriteCharCol(0x3e, x+4, page, color);
        }break;

        case 87:    // 'W'
        {
            WriteCharCol(0x7e, x, page, color);
            WriteCharCol(0x80, x+1, page, color);
            WriteCharCol(0x70, x+2, page, color);
            WriteCharCol(0x80, x+3, page, color);
            WriteCharCol(0x7e, x+4, page, color);
        }break;

        case 88:    // 'X'
        {
            WriteCharCol(0xc6, x, page, color);
            WriteCharCol(0x28, x+1, page, color);
            WriteCharCol(0x10, x+2, page, color);
            WriteCharCol(0x28, x+3, page, color);
            WriteCharCol(0xc6, x+4, page, color);
        }break;

        case 89:    // 'Y'
        {
            WriteCharCol(0x0e, x, page, color);
            WriteCharCol(0x10, x+1, page, color);
            WriteCharCol(0xe0, x+2, page, color);
            WriteCharCol(0x10, x+3, page, color);
            WriteCharCol(0x0e, x+4, page, color);
        }break;

        case 90:    // 'Z'
        {
            WriteCharCol(0xc2, x, page, color);
            WriteCharCol(0xa2, x+1, page, color);
            WriteCharCol(0x92, x+2, page, color);
            WriteCharCol(0x8a, x+3, page, color);
            WriteCharCol(0x86, x+4, page, color);
        }break;

        case 91:    // '['
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0xfe, x+1, page, color);
            WriteCharCol(0x82, x+2, page, color);
            WriteCharCol(0x82, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 92:    // '\'
        {
            WriteCharCol(0x04, x, page, color);
            WriteCharCol(0x08, x+1, page, color);
            WriteCharCol(0x10, x+2, page, color);
            WriteCharCol(0x20, x+3, page, color);
            WriteCharCol(0x40, x+4, page, color);
        }break;

        case 93:    // ']'
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0x82, x+1, page, color);
            WriteCharCol(0x82, x+2, page, color);
            WriteCharCol(0xfe, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 94:    // '^'
        {
            WriteCharCol(0x08, x, page, color);
            WriteCharCol(0x04, x+1, page, color);
            WriteCharCol(0x02, x+2, page, color);
            WriteCharCol(0x04, x+3, page, color);
            WriteCharCol(0x08, x+4, page, color);
        }break;

        case 95:    // '_'
        {
            WriteCharCol(0x80, x, page, color);
            WriteCharCol(0x80, x+1, page, color);
            WriteCharCol(0x80, x+2, page, color);
            WriteCharCol(0x80, x+3, page, color);
            WriteCharCol(0x80, x+4, page, color);
        }break;

        case 96:    // '`'
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0x02, x+1, page, color);
            WriteCharCol(0x04, x+2, page, color);
            WriteCharCol(0x08, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 97:    // 'a'
        {
            WriteCharCol(0x40, x, page, color);
            WriteCharCol(0xa8, x+1, page, color);
            WriteCharCol(0xa8, x+2, page, color);
            WriteCharCol(0xa8, x+3, page, color);
            WriteCharCol(0xf0, x+4, page, color);
        }break;

        case 98:    // 'b'
        {
            WriteCharCol(0xfe, x, page, color);
            WriteCharCol(0x90, x+1, page, color);
            WriteCharCol(0x88, x+2, page, color);
            WriteCharCol(0x88, x+3, page, color);
            WriteCharCol(0x70, x+4, page, color);
        }break;

        case 99:    // 'c'
        {
            WriteCharCol(0x70, x, page, color);
            WriteCharCol(0x88, x+1, page, color);
            WriteCharCol(0x88, x+2, page, color);
            WriteCharCol(0x88, x+3, page, color);
            WriteCharCol(0x40, x+4, page, color);
        }break;

        case 100:   // 'd'
        {
            WriteCharCol(0x70, x, page, color);
            WriteCharCol(0x88, x+1, page, color);
            WriteCharCol(0x88, x+2, page, color);
            WriteCharCol(0x90, x+3, page, color);
            WriteCharCol(0xfe, x+4, page, color);
        }break;

        case 101:   // 'e'
        {
            WriteCharCol(0x70, x, page, color);
            WriteCharCol(0xa8, x+1, page, color);
            WriteCharCol(0xa8, x+2, page, color);
            WriteCharCol(0xa8, x+3, page, color);
            WriteCharCol(0x30, x+4, page, color);
        }break;

        case 102:   // 'f'
        {
            WriteCharCol(0x10, x, page, color);
            WriteCharCol(0xfc, x+1, page, color);
            WriteCharCol(0x12, x+2, page, color);
            WriteCharCol(0x02, x+3, page, color);
            WriteCharCol(0x04, x+4, page, color);
        }break;

        case 103:   // 'g'
        {
            WriteCharCol(0x18, x, page, color);
            WriteCharCol(0xa4, x+1, page, color);
            WriteCharCol(0xa4, x+2, page, color);
            WriteCharCol(0xa4, x+3, page, color);
            WriteCharCol(0x7c, x+4, page, color);
        }break;

        case 104:   // 'h'
        {
            WriteCharCol(0xfe, x, page, color);
            WriteCharCol(0x10, x+1, page, color);
            WriteCharCol(0x08, x+2, page, color);
            WriteCharCol(0x08, x+3, page, color);
            WriteCharCol(0xf0, x+4, page, color);
        }break;

        case 105:   // 'i'
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0x88, x+1, page, color);
            WriteCharCol(0xfa, x+2, page, color);
            WriteCharCol(0x80, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 106:   // 'j'
        {
            WriteCharCol(0x40, x, page, color);
            WriteCharCol(0x80, x+1, page, color);
            WriteCharCol(0x88, x+2, page, color);
            WriteCharCol(0x7a, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 107:   // 'k'
        {
            WriteCharCol(0xfe, x, page, color);
            WriteCharCol(0x20, x+1, page, color);
            WriteCharCol(0x50, x+2, page, color);
            WriteCharCol(0x88, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 108:   // 'l'
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0x82, x+1, page, color);
            WriteCharCol(0xfe, x+2, page, color);
            WriteCharCol(0x80, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 109:   // 'm'
        {
            WriteCharCol(0xf8, x, page, color);
            WriteCharCol(0x08, x+1, page, color);
            WriteCharCol(0x30, x+2, page, color);
            WriteCharCol(0x08, x+3, page, color);
            WriteCharCol(0xf0, x+4, page, color);
        }break;

        case 110:   // 'n'
        {
            WriteCharCol(0xf8, x, page, color);
            WriteCharCol(0x10, x+1, page, color);
            WriteCharCol(0x08, x+2, page, color);
            WriteCharCol(0x08, x+3, page, color);
            WriteCharCol(0xf0, x+4, page, color);
        }break;

        case 111:   // 'o'
        {
            WriteCharCol(0x70, x, page, color);
            WriteCharCol(0x88, x+1, page, color);
            WriteCharCol(0x88, x+2, page, color);
            WriteCharCol(0x88, x+3, page, color);
            WriteCharCol(0x70, x+4, page, color);
        }break;

        case 112:   // 'p'
        {
            WriteCharCol(0xf8, x, page, color);
            WriteCharCol(0x28, x+1, page, color);
            WriteCharCol(0x28, x+2, page, color);
            WriteCharCol(0x28, x+3, page, color);
            WriteCharCol(0x10, x+4, page, color);
        }break;

        case 113:   // 'q'
        {
            WriteCharCol(0x10, x, page, color);
            WriteCharCol(0x28, x+1, page, color);
            WriteCharCol(0x28, x+2, page, color);
            WriteCharCol(0x30, x+3, page, color);
            WriteCharCol(0xf8, x+4, page, color);
        }break;

        case 114:   // 'r'
        {
            WriteCharCol(0xf8, x, page, color);
            WriteCharCol(0x10, x+1, page, color);
            WriteCharCol(0x08, x+2, page, color);
            WriteCharCol(0x08, x+3, page, color);
            WriteCharCol(0x10, x+4, page, color);
        }break;

        case 115:   // 's'
        {
            WriteCharCol(0x90, x, page, color);
            WriteCharCol(0xa8, x+1, page, color);
            WriteCharCol(0xa8, x+2, page, color);
            WriteCharCol(0xa8, x+3, page, color);
            WriteCharCol(0x40, x+4, page, color);
        }break;

        case 116:   // 't'
        {
            WriteCharCol(0x08, x, page, color);
            WriteCharCol(0x7e, x+1, page, color);
            WriteCharCol(0x88, x+2, page, color);
            WriteCharCol(0x80, x+3, page, color);
            WriteCharCol(0x40, x+4, page, color);
        }break;

        case 117:   // 'u'
        {
            WriteCharCol(0x78, x, page, color);
            WriteCharCol(0x80, x+1, page, color);
            WriteCharCol(0x80, x+2, page, color);
            WriteCharCol(0x40, x+3, page, color);
            WriteCharCol(0xf8, x+4, page, color);
        }break;

        case 118:   // 'v'
        {
            WriteCharCol(0x38, x, page, color);
            WriteCharCol(0x40, x+1, page, color);
            WriteCharCol(0x80, x+2, page, color);
            WriteCharCol(0x40, x+3, page, color);
            WriteCharCol(0x38, x+4, page, color);
        }break;

        case 119:   // 'w'
        {
            WriteCharCol(0x78, x, page, color);
            WriteCharCol(0x80, x+1, page, color);
            WriteCharCol(0x60, x+2, page, color);
            WriteCharCol(0x80, x+3, page, color);
            WriteCharCol(0x78, x+4, page, color);
        }break;

        case 120:   // 'x'
        {
            WriteCharCol(0x88, x, page, color);
            WriteCharCol(0x50, x+1, page, color);
            WriteCharCol(0x20, x+2, page, color);
            WriteCharCol(0x50, x+3, page, color);
            WriteCharCol(0x88, x+4, page, color);
        }break;

        case 121:   // 'y'
        {
            WriteCharCol(0x18, x, page, color);
            WriteCharCol(0xa0, x+1, page, color);
            WriteCharCol(0xa0, x+2, page, color);
            WriteCharCol(0xa0, x+3, page, color);
            WriteCharCol(0x78, x+4, page, color);
        }break;

        case 122:   // 'z'
        {
            WriteCharCol(0x88, x, page, color);
            WriteCharCol(0xc8, x+1, page, color);
            WriteCharCol(0xa8, x+2, page, color);
            WriteCharCol(0x98, x+3, page, color);
            WriteCharCol(0x88, x+4, page, color);
        }break;

        case 123:   // '{'
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0x10, x+1, page, color);
            WriteCharCol(0x6c, x+2, page, color);
            WriteCharCol(0x82, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 124:   // '|'
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0x00, x+1, page, color);
            WriteCharCol(0xfe, x+2, page, color);
            WriteCharCol(0x00, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 125:   // '}'
        {
            WriteCharCol(0x00, x, page, color);
            WriteCharCol(0x82, x+1, page, color);
            WriteCharCol(0x6c, x+2, page, color);
            WriteCharCol(0x10, x+3, page, color);
            WriteCharCol(0x00, x+4, page, color);
        }break;

        case 126:   // '~'
        {
            WriteCharCol(0x20, x, page, color);
            WriteCharCol(0x10, x+1, page, color);
            WriteCharCol(0x10, x+2, page, color);
            WriteCharCol(0x20, x+3, page, color);
            WriteCharCol(0x10, x+4, page, color);
        }break;
        /*

        case :  // ''
        {
            WriteCharCol(0x, x, page, color);
            WriteCharCol(0x, x+1, page, color);
            WriteCharCol(0x, x+2, page, color);
            WriteCharCol(0x, x+3, page, color);
            WriteCharCol(0x, x+4, page, color);
        }break;
        */

        default:    // not supported, print box
        {
            WriteData(0xfe);
            WriteData(0xfe);
            WriteData(0xfe);
            WriteData(0xfe);
            WriteData(0xfe);
        }
    }
    WriteCharCol(0x00, x+5, page, color); //default last blank column of 6 x 8 character

    CS1pin = 1;
}

