#include "KEYPAD_DISCO_F429ZI.h"
#include "mbed.h"
#include "TS_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h"


KEYPAD_DISCO_F429ZI::KEYPAD_DISCO_F429ZI() {
    LastKey=0;
    ReadKeyState = 0;
    MsgBColor = LCD_COLOR_BLACK;
    MsgFColor = LCD_COLOR_WHITE;
    OutBColor = LCD_COLOR_WHITE;
    OutFColor = LCD_COLOR_BLACK;
    BackColor = LCD_COLOR_BLACK;
    KeyBColor = LCD_COLOR_WHITE;
    KeyFColor = LCD_COLOR_BLACK;
    KeyPressColor = LCD_COLOR_GRAY;
    KeysTopY=110;
    
    Keys[0][0] = '1';
    Keys[0][1] = '2';
    Keys[0][2] = '3';
    Keys[0][3] = 'A';
    Keys[1][0] = '4';
    Keys[1][1] = '5';
    Keys[1][2] = '6';
    Keys[1][3] = 'B';
    Keys[2][0] = '7';
    Keys[2][1] = '8';
    Keys[2][2] = '9';
    Keys[2][3] = 'C';
    Keys[3][0] = '*';
    Keys[3][1] = '0';
    Keys[3][2] = '#';
    Keys[3][3] = 'D';
}
 
 
void KEYPAD_DISCO_F429ZI::Show(int MessageBoxEnable, int OutBoxEnable) {
    uint16_t x, y;
    uint8_t row, col;
    
    if(MessageBoxEnable > 0)
        MessageBoxEnabledFlag = 1;
    else
        MessageBoxEnabledFlag = 0;
    
    if(OutBoxEnable > 0)
        OutBoxEnabledFlag = 1;
    else
        OutBoxEnabledFlag = 0;
          
    lcd.Clear(BackColor);
    
    /* Display Message textbox */
    if(MessageBoxEnabledFlag) {
        lcd.SetFont(&Font16);
        lcd.SetBackColor(MsgBColor);
        lcd.SetTextColor(MsgFColor);
        lcd.DisplayStringAt(4, LINE(0)+4,(uint8_t *) "                     ", LEFT_MODE);
        lcd.DisplayStringAt(4, LINE(1)+4,(uint8_t *) "                     ", LEFT_MODE);
        lcd.SetTextColor(MsgBColor);
        lcd.FillRect(0,0,240,4);            //top filler
        lcd.FillRect(0,LINE(0),4,36);       //left filler
        lcd.FillRect(235,LINE(0),5,36);     //right filler
    }
    
    /* Display Output textbox */
    if(OutBoxEnabledFlag) {
        lcd.SetFont(&Font24);
        lcd.SetBackColor(OutBColor);
        lcd.SetTextColor(OutFColor);
        lcd.DisplayStringAt(1,LINE(2),(uint8_t *) "              ", LEFT_MODE);
        lcd.SetTextColor(OutBColor);
        lcd.FillRect(1,LINE(2)-4,238,5);    //top filler
        lcd.DrawVLine(0,LINE(2)-4,28);      //left filler
        lcd.DrawVLine(239,LINE(2)-4,28);    //right filler
    }
    
    /* Draw buttons */
    lcd.SetTextColor(KeyBColor);
    for(y=KeysTopY; y<=KeysTopY+180; y=y+60)
        for(x=30; x<=210; x=x+60)
            lcd.FillCircle(x,y,25);
    
    /* Draw button text */
    lcd.SetFont(&Font24);
    lcd.SetTextColor(KeyFColor);
    lcd.SetBackColor(KeyBColor);
    row=0;
    for(y=KeysTopY; y<=KeysTopY+180; y=y+60)
    {
        col=0;
        for(x=30; x<=210; x=x+60)
        {
            lcd.DisplayChar(x-8, y-8, Keys[row][col]);
            col++;
        }
        row++;
    }
    
    ts.Init(240, 320);
}

char KEYPAD_DISCO_F429ZI::ReadKey() {
    uint16_t x, y;        
    TS_StateTypeDef TS_State;

    ts.GetState(&TS_State);  
    
    switch(ReadKeyState) {
        case 0: {    //wait for key press
            if (TS_State.TouchDetected) {                                   //if the screen was touched
                x = TS_State.X;                                             //read the x value
                y = TS_State.Y;                                             //read the y value                                    
                if((x > 3) && (x <= 60) && (y > KeysTopY - 30) && (y <= KeysTopY + 30)) {             //row0, col0
                    row=0;col=0;
                    LastkeyX = 30;
                    LastkeyY = KeysTopY;
                    LastKey = Keys[row][col];
                    ReadKeyState = 10;
                }
                else if((x > 60) && (x <= 120) && (y > KeysTopY - 30) && (y <= KeysTopY + 30)) {      //row0, col1
                    row=0;col=1;
                    LastkeyX = 90;
                    LastkeyY = KeysTopY;
                    LastKey = Keys[row][col];
                    ReadKeyState = 10;
                }
                else if((x > 120) && (x <= 180) && (y > KeysTopY - 30) && (y <= KeysTopY + 30)) {     //row0, col2
                    row=0;col=2;
                    LastkeyX = 150;
                    LastkeyY = KeysTopY;
                    LastKey = Keys[row][col];
                    ReadKeyState = 10;
                }
                else if((x > 180) && (x <= 237) && (y > KeysTopY - 30) && (y <= KeysTopY + 30)) {      //row0, col3
                    row=0;col=3;
                    LastkeyX = 210;
                    LastkeyY = KeysTopY;
                    LastKey = Keys[row][col];
                    ReadKeyState = 10;
                }
                    
                if((x > 3) && (x <= 60) && (y > KeysTopY + 30) && (y <= KeysTopY + 90)) {                               //row1, col0
                    row=1;col=0;
                    LastkeyX = 30;
                    LastkeyY = KeysTopY+60;
                    LastKey = Keys[row][col];
                    ReadKeyState = 10;
                }
                else if((x > 60) && (x <= 120) && (y > KeysTopY + 30) && (y <= KeysTopY + 90)) {               //row1, col1
                    row=1;col=1;
                    LastkeyX = 90;
                    LastkeyY = KeysTopY+60;
                    LastKey = Keys[row][col];
                    ReadKeyState = 10;
                }
                else if((x > 120) && (x <= 180) && (y > KeysTopY + 30) && (y <= KeysTopY + 90)) {               //row1, col2
                    row=1;col=2;
                    LastkeyX = 150;
                    LastkeyY = KeysTopY+60;
                    LastKey = Keys[row][col];
                    ReadKeyState = 10;
                }
                else if((x > 180) && (x <= 237) && (y > KeysTopY + 30) && (y <= KeysTopY + 90)) {               //row1, col3
                    row=1;col=3;
                    LastkeyX = 210;
                    LastkeyY = KeysTopY+60;
                    LastKey = Keys[row][col];
                    ReadKeyState = 10;
                }
                    
                if((x > 3) && (x <= 60) && (y > KeysTopY + 90) && (y <= KeysTopY + 150)) {                              //row2, col0
                    row=2;col=0;
                    LastkeyX = 30;
                    LastkeyY = KeysTopY+120;
                    LastKey = Keys[row][col];
                    ReadKeyState = 10;
                }
                else if((x > 60) && (x <= 120) && (y > KeysTopY + 90) && (y <= KeysTopY + 150)) {              //row2, col1
                    row=2;col=1;
                    LastkeyX = 90;
                    LastkeyY = KeysTopY+120;
                    LastKey = Keys[row][col];
                    ReadKeyState = 10;
                }
                else if((x > 120) && (x <= 180) && (y > KeysTopY + 90) && (y <= KeysTopY + 150)) {             //row2, col2
                    row=2;col=2;
                    LastkeyX = 150;
                    LastkeyY = KeysTopY+120;
                    LastKey = Keys[row][col];
                    ReadKeyState = 10;
                }
                else if((x > 180) && (x <= 237) && (y > KeysTopY + 90) && (y <= KeysTopY + 150)) {             //row2, col3
                    row=2;col=3;
                    LastkeyX = 210;
                    LastkeyY = KeysTopY+120;
                    LastKey = Keys[row][col];
                    ReadKeyState = 10;
                }
                    
                if((x > 3) && (x <= 60) && (y > KeysTopY + 150) && (y <= KeysTopY + 210)) {                            //row3, col0
                    row=3;col=0;
                    LastkeyX = 30;
                    LastkeyY = KeysTopY+180;
                    LastKey = Keys[row][col];
                    ReadKeyState = 10;
                }
                else if((x > 60) && (x <= 120) && (y > KeysTopY + 150) && (y <= KeysTopY + 210)) {             //row3, col1
                    row=3;col=1;
                    LastkeyX = 90;
                    LastkeyY = KeysTopY+180;
                    LastKey = Keys[row][col];
                    ReadKeyState = 10;
                }
                else if((x > 120) && (x <= 180) && (y > KeysTopY + 150) && (y <= KeysTopY + 210)) {             //row3, col2
                    row=3;col=2;
                    LastkeyX = 150;
                    LastkeyY = KeysTopY+180;
                    LastKey = Keys[row][col];
                    ReadKeyState = 10;
                }
                else if((x > 180) && (x <= 237) && (y > KeysTopY + 150) && (y <= KeysTopY + 210)) {             //row3, col3
                    row=3;col=3;
                    LastkeyX = 210;
                    LastkeyY = KeysTopY+180;
                    LastKey = Keys[row][col];
                    ReadKeyState = 10;
                }
                    
                    
                   // else
                   // {
                   //         //do nothing when not incorrect touch position
                   // }
            }  
        } break;
                
        
        case 10: {      //draw button darker
            lcd.SetFont(&Font24);
            lcd.SetTextColor(KeyPressColor);
            lcd.FillCircle(LastkeyX,LastkeyY,25);
            lcd.SetTextColor(KeyFColor);
            lcd.SetBackColor(KeyPressColor);
            lcd.DisplayChar(LastkeyX-8, LastkeyY-8, Keys[row][col]);
            
            ReadKeyState = 20;
        } break;
        
        
        case 20: {      //wait for key to be released                              
            if(TS_State.TouchDetected == 0)
                ReadKeyState = 30;
        } break;
             
        
        case 30:        //draw key normal again
        {
            lcd.SetFont(&Font24);
            lcd.SetTextColor(KeyBColor);
            lcd.FillCircle(LastkeyX,LastkeyY,25);
            lcd.SetTextColor(KeyFColor);
            lcd.SetBackColor(KeyBColor);
            lcd.DisplayChar(LastkeyX-8, LastkeyY-8, Keys[row][col]);
            
            LastKey = 0;
            ReadKeyState = 0;
        } break;
    }

    wait(0.01);     //to allow for contact bounce
    
    return LastKey;
}

void KEYPAD_DISCO_F429ZI::WriteMsgBoxLine(int LineNum, char *text) {
    if(MessageBoxEnabledFlag) {
        if((LineNum < 0) || (LineNum > 1))
            LineNum = 0;
        lcd.SetFont(&Font16);
        lcd.SetBackColor(MsgBColor);
        lcd.SetTextColor(MsgFColor);
        lcd.DisplayStringAt(4, LINE(LineNum)+4,(uint8_t *) text, LEFT_MODE);
    }
}
  
void KEYPAD_DISCO_F429ZI::WriteOutBox(char *text) {
    if(OutBoxEnabledFlag) {
        lcd.SetFont(&Font24);
        lcd.SetBackColor(OutBColor);
        lcd.SetTextColor(OutFColor);
        lcd.DisplayStringAt(1,LINE(2),(uint8_t *) text, LEFT_MODE);
    }
}

void KEYPAD_DISCO_F429ZI::SetKeys(char (*keymap)[4]) {
    int i, j;
    
    for(i=0; i<=3; i++)
        for(j=0; j<=3; j++)
            Keys[i][j] = keymap[i][j];
}

void KEYPAD_DISCO_F429ZI::SetKeyForeColor(uint32_t color) {
    KeyFColor = color;
}

void KEYPAD_DISCO_F429ZI::SetKeyBackColor(uint32_t color) {
    KeyBColor = color;
}

void KEYPAD_DISCO_F429ZI::SetKeyPressColor(uint32_t color) {
    KeyPressColor = color;
}

void KEYPAD_DISCO_F429ZI::SetMsgBoxForeColor(uint32_t color) {
    MsgFColor = color;
}
    
void KEYPAD_DISCO_F429ZI::SetMsgBoxBackColor(uint32_t color) {
    MsgBColor = color;
}
    
void KEYPAD_DISCO_F429ZI::SetOutBoxForeColor(uint32_t color) {
    OutFColor = color;
}
    
void KEYPAD_DISCO_F429ZI::SetOutBoxBackColor(uint32_t color) {
    OutBColor = color;
}

void KEYPAD_DISCO_F429ZI::SetBackColor(uint32_t color) {
    BackColor = color;
}
