#include "HCSR04.h"
#include "mbed.h"
 
 
HCSR04::HCSR04(PinName t, PinName e) : trig(t), echo(e) {
    trig.period(0.06);
    trig.pulsewidth_us(20);
    echo.rise(this,&HCSR04::HighTrigger);
    echo.fall(this,&HCSR04::LowTrigger);
}
 
unsigned int HCSR04::read_us() {
    return us;
}
 
float HCSR04::read_cm() {
    return (float)us/58;
}

void HCSR04::HighTrigger() {
    timer.start();
}

void HCSR04::LowTrigger() {
    timer.stop();
    us = timer.read_us();
    timer.reset();
}