#include "DISCOF469SerialLCD.h"
#include "mbed.h"
 

/* ***************************************** Public Functions ***************************************** */

DISCOF469SerialLCD::DISCOF469SerialLCD(PinName Tx, PinName Rx) : lcd(Tx, Rx, 500, 100, NULL) {
    lcd.baud(57600);
    
    mTouches=0;
    mRxIdx=0;
    
    
    mReadPixelColor = 0;
    mcnt=0;
    Clear(LCD_BLACK);
}

void DISCOF469SerialLCD::Clear(uint32_t Color) {
    lcd.printf("CLR %u###", Color);
}

void DISCOF469SerialLCD::DrawPixel(uint16_t Xpos, uint16_t Ypos, uint32_t Color) {
    lcd.printf("DPX %d %d %d###", Xpos, Ypos, Color);
}

uint32_t DISCOF469SerialLCD::ReadPixel(uint16_t Xpos, uint16_t Ypos) {
    uint32_t temp;
    
    lcd.printf("RPX %u %u###", Xpos, Ypos);
    while(mReadPixelColor == 0) {
        ServiceSerialRX();
    }

    temp = mReadPixelColor;
    mReadPixelColor=0;
    return temp;
}

void DISCOF469SerialLCD::DrawLine(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint32_t Color) {
    lcd.printf("DLI %u %u %u %u %u###", x1, y1, x2, y2, Color);
}

void DISCOF469SerialLCD::DrawRectangle(uint16_t Xpos, uint16_t Ypos, uint16_t Width, uint16_t Height, uint32_t Color) {
    lcd.printf("DRE %u %u %u %u %u###", Xpos, Ypos, Width, Height, Color);
}

void DISCOF469SerialLCD::FillRectangle(uint16_t Xpos, uint16_t Ypos, uint16_t Width, uint16_t Height, uint32_t Color) {
    lcd.printf("FRE %u %u %u %u %u###", Xpos, Ypos, Width, Height, Color);
}

void DISCOF469SerialLCD::DrawCircle(uint16_t Xpos, uint16_t Ypos, uint16_t Radius, uint32_t Color) {
    lcd.printf("DCI %u %u %u %u###", Xpos, Ypos, Radius, Color);
}

void DISCOF469SerialLCD::FillCircle(uint16_t Xpos, uint16_t Ypos, uint16_t Radius, uint32_t Color) {
    lcd.printf("FCI %u %u %u %u###", Xpos, Ypos, Radius, Color);
}

void DISCOF469SerialLCD::DrawEllipse(uint16_t Xpos, uint16_t Ypos, uint16_t XRadius, uint16_t YRadius, uint32_t Color) {
    lcd.printf("DEL %u %u %u %u %u###", Xpos, Ypos, XRadius, YRadius, Color);
}

void DISCOF469SerialLCD::FillEllipse(uint16_t Xpos, uint16_t Ypos, uint16_t XRadius, uint16_t YRadius, uint32_t Color) {
    lcd.printf("FEL %u %u %u %u %u###", Xpos, Ypos, XRadius, YRadius, Color);
}

void DISCOF469SerialLCD::DrawStringAtXY(uint16_t Xpos, uint16_t Ypos, uint8_t FontSize, uint32_t TextColor, uint32_t BackColor, char *Text) {
    lcd.printf("DSX %u %u %u %u %u %s###", Xpos, Ypos, FontSize, TextColor, BackColor, Text);
}

void DISCOF469SerialLCD::DrawStringAtLine(uint16_t Line, uint8_t FontSize, uint32_t TextColor, uint32_t BackColor, uint8_t Mode, char *Text) {
    lcd.printf("DSL %u %u %u %u %u %s###", Line, FontSize, TextColor, BackColor, Mode, Text);  
}

uint8_t DISCOF469SerialLCD::Touches(void) {
    lcd.printf("TCS###");
    mTouches = 0xff;        // dummy setting
    while(mTouches == 0xff) {
        ServiceSerialRX();
    }
    return mTouches;
}

void DISCOF469SerialLCD::GetTouch1(uint16_t *x, uint16_t *y) {
    lcd.printf("T1C###");
    mTouch1X = 0xffff;      // dummy setting
    while(mTouch1X == 0xffff) {
        ServiceSerialRX();
    }
    *x = mTouch1X;
    *y = mTouch1Y;
}

void DISCOF469SerialLCD::GetTouch2(uint16_t *x, uint16_t *y) {
    lcd.printf("T2C###");
    mTouch2X = 0xffff;      // dummy setting
    while(mTouch2X == 0xffff) {
        ServiceSerialRX();
    }
    *x = mTouch2X;
    *y = mTouch2Y;
}

void DISCOF469SerialLCD::LED1(uint8_t OnOff) {
    lcd.printf("LD1 %d###", 1-OnOff);
}

void DISCOF469SerialLCD::LED2(uint8_t OnOff) {
    lcd.printf("LD2 %d###", 1-OnOff);
}

void DISCOF469SerialLCD::LED3(uint8_t OnOff) {
    lcd.printf("LD3 %d###", 1-OnOff);
}

void DISCOF469SerialLCD::LED4(uint8_t OnOff) {
    lcd.printf("LD4 %d###", 1-OnOff);
}

/* ***************************************** Private Functions ***************************************** */

void DISCOF469SerialLCD::ServiceSerialRX(void) {
    char c;

    if(lcd.readable()) {
        c = lcd.getc(); 
        mRxMsg[mRxIdx] = c;
        mRxIdx++;
        
        if ((mRxIdx >= 3) && (mRxMsg[mRxIdx-3] == '#') && (mRxMsg[mRxIdx-2] == '#') && (mRxMsg[mRxIdx-1] == '#')) {  //valid rx message
            strncpy(cmd, mRxMsg, 3);
            mRxMsg[mRxIdx-3]='\0';
            mRxIdx=0;
            
            if(strcmp(cmd, "-PX")==0)                       // ---------- Read Pixel return
            {
                sscanf(mRxMsg, "%s %u", cmd, &data32_0);    //cmd,Color
                mReadPixelColor = data32_0;      
            }
            
            else if(strcmp(cmd, "-CS")==0)                  // ---------- Touches return
            {
                sscanf(mRxMsg, "%s %hhu", cmd, &data8_0);     //cmd, numTouches
                mTouches = data8_0;      
            }
                       
            else if(strcmp(cmd, "-T1")==0)                  // ---------- GetTouch1 return
            {
                sscanf(mRxMsg, "%s %hu %hu", cmd, &data16_0, &data16_1);    //cmd,x,y
                mTouch1X = data16_0;    
                mTouch1Y = data16_1;  
            }
            
            else if(strcmp(cmd, "-T2")==0)                  // ---------- GetTouch2 return
            {
                sscanf(mRxMsg, "%s %hu %hu", cmd, &data16_0, &data16_1);    //cmd,x,y
                mTouch2X = data16_0;    
                mTouch2Y = data16_1;  
            }
        }
    }
}