#include "DISCOF469LCD.h"
#include "mbed.h"

/* ***************************************** Public Functions ***************************************** */

DISCOF469LCD::DISCOF469LCD(void) {
    //mTouches=0;
    ts.Init(lcd.GetXSize(), lcd.GetYSize());
    Clear(LCD_BLACK);
}

void DISCOF469LCD::Clear(uint32_t Color) {
    lcd.Clear(Color);
}

void DISCOF469LCD::DrawPixel(uint16_t Xpos, uint16_t Ypos, uint32_t RGB_Code)
{
    lcd.DrawPixel(Xpos, Ypos, RGB_Code);
}

uint32_t DISCOF469LCD::ReadPixel(uint16_t Xpos, uint16_t Ypos)
{
    return(lcd.ReadPixel(Xpos, Ypos));
}

void DISCOF469LCD::DrawLine(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint32_t Color)
{
    lcd.SetTextColor(Color);
    lcd.DrawLine(x1, y1, x2, y2);
}

void DISCOF469LCD::DrawRectangle(uint16_t Xpos, uint16_t Ypos, uint16_t Width, uint16_t Height, uint32_t Color)
{
    lcd.SetTextColor(Color);
    lcd.DrawRect(Xpos, Ypos, Width, Height);
}

void DISCOF469LCD::FillRectangle(uint16_t Xpos, uint16_t Ypos, uint16_t Width, uint16_t Height, uint32_t Color)
{
    lcd.SetTextColor(Color);
    lcd.FillRect(Xpos, Ypos, Width, Height);
}

void DISCOF469LCD::DrawCircle(uint16_t Xpos, uint16_t Ypos, uint16_t Radius, uint32_t Color)
{
    lcd.SetTextColor(Color);
    lcd.DrawCircle(Xpos, Ypos, Radius);
}

void DISCOF469LCD::FillCircle(uint16_t Xpos, uint16_t Ypos, uint16_t Radius, uint32_t Color)
{
    lcd.SetTextColor(Color);
    lcd.FillCircle(Xpos, Ypos, Radius);
}

void DISCOF469LCD::DrawEllipse(uint16_t Xpos, uint16_t Ypos, uint16_t XRadius, uint16_t YRadius, uint32_t Color)
{
    lcd.SetTextColor(Color);
    lcd.DrawEllipse(Xpos, Ypos, XRadius, YRadius);
}


void DISCOF469LCD::FillEllipse(uint16_t Xpos, uint16_t Ypos, uint16_t XRadius, uint16_t YRadius, uint32_t Color)
{
    lcd.SetTextColor(Color);
    lcd.FillEllipse(Xpos, Ypos, XRadius, YRadius);
}

void DISCOF469LCD::DrawStringAtXY(uint16_t Xpos, uint16_t Ypos, uint8_t FontSize, uint32_t TextColor, uint32_t BackColor, char *Text)
{
    switch(FontSize)
    {
        case 0:    BSP_LCD_SetFont(&Font8); break;
        case 1:    BSP_LCD_SetFont(&Font12); break; 
        case 2:    BSP_LCD_SetFont(&Font16); break; 
        case 3:    BSP_LCD_SetFont(&Font20); break;
        case 4:    BSP_LCD_SetFont(&Font24); break;
        default:   BSP_LCD_SetFont(&Font8); 
    }
    lcd.SetBackColor(BackColor);
    lcd.SetTextColor(TextColor);
    lcd.DisplayStringAt(Xpos, Ypos, (uint8_t *)Text, LEFT_MODE);
}

void DISCOF469LCD::DrawStringAtLine(uint16_t Line, uint8_t FontSize, uint32_t TextColor, uint32_t BackColor, uint8_t Mode, char *Text)
{
    switch(FontSize)
    {
        case 0:    BSP_LCD_SetFont(&Font8); break;
        case 1:    BSP_LCD_SetFont(&Font12); break; 
        case 2:    BSP_LCD_SetFont(&Font16); break; 
        case 3:    BSP_LCD_SetFont(&Font20); break;
        case 4:    BSP_LCD_SetFont(&Font24); break;
        default:   BSP_LCD_SetFont(&Font8); 
    }
    lcd.SetBackColor(BackColor);
    lcd.SetTextColor(TextColor);
    switch(Mode)
    {
        case 0:    lcd.DisplayStringAt(0, LINE(Line), (uint8_t *)Text, LEFT_MODE); break;
        case 1:    lcd.DisplayStringAt(0, LINE(Line), (uint8_t *)Text, CENTER_MODE); break;
        case 2:    lcd.DisplayStringAt(0, LINE(Line), (uint8_t *)Text, RIGHT_MODE); break;
        default:    lcd.DisplayStringAt(0, LINE(Line), (uint8_t *)Text, LEFT_MODE);
    }
    
}

uint8_t DISCOF469LCD::Touches(void)
{
    TS_StateTypeDef TS_State;
    
    ts.GetState(&TS_State);
    return TS_State.touchDetected;
}

void DISCOF469LCD::GetTouch1(uint16_t *x, uint16_t *y)
{
    TS_StateTypeDef TS_State;
    
    ts.GetState(&TS_State);
    *x = TS_State.touchX[0];
    *y = TS_State.touchY[0];
}

void DISCOF469LCD::GetTouch2(uint16_t *x, uint16_t *y)
{
    TS_StateTypeDef TS_State;
    
    ts.GetState(&TS_State);
    *x = TS_State.touchX[1];
    *y = TS_State.touchY[1];
}

/* ***************************************** Private Functions ***************************************** */
