/* WiFi Example
 * Copyright (c) 2016 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "MQTTmbed.h"
#include "MQTTClientMbedOs.h"
#include "Sht31.h"
#define MQTT_MAX_PACKET_SIZE 400 
#define MQTT_MAX_PAYLOAD_SIZE 300

Sht31 temp_sensor(I2C_SDA, I2C_SCL);
int temp = 1;
AnalogIn my_adc(D11);
float t;
float h;
void ibm_cloud_demo(NetworkInterface *net)
{
    TCPSocket socket;
    MQTTClient client(&socket);
     SocketAddress a;
    char* hostname = "dev.rightech.io";
    net->gethostbyname(hostname, &a);
    int port = 1883;
    a.set_port(port);
     printf("Connecting to %s:%d\r\n", hostname, port);
    socket.open(net);
     printf("Opened socket\n\r");
     int rc = socket.connect(a);
     if (rc != 0)
        printf("rc from TCP connect is %d\r\n", rc);
     printf("Connected socket\n\r");
     MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
     data.MQTTVersion = 3;
     data.clientID.cstring = "mqtt-graf2114-ylbl1u";
     data.username.cstring = "Qwerty1";
     data.password.cstring = "Qwerty1";
     //{clientId:"Qwerty1",userName:"Qwerty2",password:"Qwerty3"}
    if ((rc = client.connect(data)) != 0)
    printf("rc from MQTT connect is %d\r\n", rc);
    t = temp_sensor.readTemperature();
    MQTT::Message message;
    char buf[MQTT_MAX_PAYLOAD_SIZE];   
    sprintf(buf,"%d", t);
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf);
    char* topic = "temp";
    if( (message.payloadlen + strlen(topic)+1) >= MQTT_MAX_PACKET_SIZE )
    printf("message too long!\r\n");
    rc = client.publish(topic, message);
    
    h = temp_sensor.readHumidity();  
    sprintf(buf,"%f", h);
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf);
    char* topic = "uhum";
    if( (message.payloadlen + strlen(topic)+1) >= MQTT_MAX_PACKET_SIZE )
    printf("message too long!\r\n");
    rc = client.publish(topic, message);
     
    sprintf(buf,"%f"(my_adc.read()*100);
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf);
    char* topic = "hum";
    if( (message.payloadlen + strlen(topic)+1) >= MQTT_MAX_PACKET_SIZE )
    printf("message too long!\r\n");
    rc = client.publish(topic, message);

    return; 
}


WiFiInterface *wifi;

const char *sec2str(nsapi_security_t sec)
{
    switch (sec) {
        case NSAPI_SECURITY_NONE:
            return "None";
        case NSAPI_SECURITY_WEP:
            return "WEP";
        case NSAPI_SECURITY_WPA:
            return "WPA";
        case NSAPI_SECURITY_WPA2:
            return "WPA2";
        case NSAPI_SECURITY_WPA_WPA2:
            return "WPA/WPA2";
        case NSAPI_SECURITY_UNKNOWN:
        default:
            return "Unknown";
    }
}

int scan_demo(WiFiInterface *wifi)
{
    WiFiAccessPoint *ap;

    printf("Scan:\n");

    int count = wifi->scan(NULL,0);

    if (count <= 0) {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }

    /* Limit number of network arbitrary to 15 */
    count = count < 15 ? count : 15;

    ap = new WiFiAccessPoint[count];
    count = wifi->scan(ap, count);

    if (count <= 0) {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }

    for (int i = 0; i < count; i++) {
        printf("Network: %s secured: %s BSSID: %hhX:%hhX:%hhX:%hhx:%hhx:%hhx RSSI: %hhd Ch: %hhd\n", ap[i].get_ssid(),
               sec2str(ap[i].get_security()), ap[i].get_bssid()[0], ap[i].get_bssid()[1], ap[i].get_bssid()[2],
               ap[i].get_bssid()[3], ap[i].get_bssid()[4], ap[i].get_bssid()[5], ap[i].get_rssi(), ap[i].get_channel());
    }
    printf("%d networks available.\n", count);

    delete[] ap;
    return count;
}

int main()
{
    printf("WiFi example\n");

#ifdef MBED_MAJOR_VERSION
    printf("Mbed OS version %d.%d.%d\n\n", MBED_MAJOR_VERSION, MBED_MINOR_VERSION, MBED_PATCH_VERSION);
#endif

    wifi = WiFiInterface::get_default_instance();
    if (!wifi) {
        printf("ERROR: No WiFiInterface found.\n");
        return -1;
    }

    int count = scan_demo(wifi);
    if (count == 0) {
        printf("No WIFI APs found - can't continue further.\n");
        return -1;
    }

    printf("\nConnecting to %s...\n", MBED_CONF_APP_WIFI_SSID);
    int ret = wifi->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0) {
        printf("\nConnection error: %d\n", ret);
        return -1;
    }

    printf("Success\n\n");
    printf("MAC: %s\n", wifi->get_mac_address());
    printf("IP: %s\n", wifi->get_ip_address());
    printf("Netmask: %s\n", wifi->get_netmask());
    printf("Gateway: %s\n", wifi->get_gateway());
    printf("RSSI: %d\n\n", wifi->get_rssi());
    while (1)
    {
   if (temp<2) {
    ibm_cloud_demo(wifi);
    wait_ms(1000);
    temp++;
    } 
    else 
        while(1)
            {
                relay = !relay;
                wait_ms(500);
                }
    }
    printf("Done\n\n");
}
