/**********************************************************************/
/*                                                                    */
/*          Programme de test de l'extension codeur                   */
/*                   pour la carte F446RE                             */
/*                                                                    */
/*             Sylvain CASTANET - Novembre 2019                       */
/*                                                                    */
/*                          ------                                    */
/*                                                                    */
/*  Test des différentes fonctions de la carte  :                     */
/*      - codeur incrémental et BP sur interruptions timer            */
/*      - Led                                                         */
/*                                                                    */
/**********************************************************************/

#include "mbed.h"
#include "C12832.h"
#include "Fonts/Arial12x12.h"

// Using Arduino pin notation
C12832 lcd(D11, D13, D12, D7, D10);

// Entrées numériques
DigitalIn BP(PC_12,PullUp);           // Mode PullUp
DigitalIn CodeurA(PB_7);
DigitalIn CodeurB(PA_15);

// Led
DigitalOut Led(PC_10);

Ticker timer1;
int counter=0;

void codeur(){
    static uint8_t code;

    code = (code << 2) + (((CodeurA << 1) | (CodeurB << 0)) & 3);
    code &= 15;
    switch (code) {
        case 0x7:
            counter--;
            Led = !Led;
            break;
        case 0xd:
            counter++;
            Led = !Led;
            break;
    }
    if (!BP){
        Led = 1;
        code = 0x00;
        counter = 0;
    }
}

int main()
{
    lcd.cls();          // Clear screen
    lcd.set_font((unsigned char*)Arial12x12);  
    lcd.locate(0,3);    // 1ere ligne
    lcd.printf("Essai du module codeur");
    lcd.locate(0,15);   // 2nde ligne
    lcd.printf("Compteur : %d ",counter);

    // Interruption timer
    timer1.attach_us(&codeur, 500);
 
    Led = 1;
    while(1) {
        lcd.locate(0,15);
        lcd.printf("Compteur : %d ",counter);
//        wait_ms(100);
    }
}
