/* mbed simple H-bridge motor controller
 * Copyright (c) 
 
 */
 
#ifndef MBED_MOTOR_H
#define MBED_MOTOR_H
 
#include "mbed.h"
 
/** Interface to control a standard DC motor 
 *
 * with an H-bridge using a PwmOut and 3 DigitalOuts
 */
class Motor {
public:
 
    /** Create a motor control interface    
     *
     * @param pwm A PwmOut pin, driving the H-bridge enable line to control the speed
     * @param in1 A DigitalOut, 
     * @param in2 A DigitalOut, 
     * @param sb  
     A DigitalOut, 
     */
    Motor(PinName pwm, PinName in1, PinName in2, PinName sb);
    
    /** Set the speed of the motor
     * 
     * @param speed The speed of the motor as a normalised value between -1.0 and 1.0
     */
    void speed(float speed);
 
protected:
    PwmOut _pwm;
    DigitalOut _in1;
    DigitalOut _in2;
    DigitalOut _sb;
 
};
 
#endif
 